/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators.composite;

import java.util.Arrays;
import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.GeneratorException;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.generators.CopyableGenerator;
import org.cthul.fixsure.generators.GeneratorTools;

public class MergingGenerator<T>
implements CopyableGenerator<T> {
    private static final Object NO_VALUE = new Object();
    private final Generator<? extends T>[] generators;
    private final Object[] nextValues;
    private Class<?> valueType = Void.TYPE;

    public static <T> MergingGenerator<T> merge(DataSource<? extends T> ... generators) {
        return new MergingGenerator<T>(generators);
    }

    public MergingGenerator(DataSource<? extends T> first, DataSource<? extends T>[] more) {
        this(DataSource.toGenerators(first, more));
    }

    public MergingGenerator(DataSource<? extends T>[] generators) {
        this(DataSource.toGenerators(generators));
    }

    public MergingGenerator(Generator<? extends T>[] generators) {
        this.generators = generators;
        this.nextValues = new Object[generators.length];
        for (int i = 0; i < this.nextValues.length; ++i) {
            this.nextValue(i);
        }
    }

    public MergingGenerator(Class<T> valueType, DataSource<? extends T>[] generators) {
        this(generators);
        this.valueType = valueType;
    }

    public MergingGenerator(MergingGenerator<T> src) {
        this.generators = (Generator[])src.generators.clone();
        for (int i = 0; i < this.generators.length; ++i) {
            this.generators[i] = GeneratorTools.copyGenerator(this.generators[i]);
        }
        this.valueType = src.valueType;
        this.nextValues = src.nextValues;
    }

    private void nextValue(int i) {
        try {
            this.nextValues[i] = this.generators[i].next();
        }
        catch (GeneratorException e) {
            this.nextValues[i] = NO_VALUE;
        }
    }

    @Override
    public T next() {
        int index = -1;
        Object value = null;
        for (int i = 0; i < this.nextValues.length; ++i) {
            Object valueI = this.nextValues[i];
            if (valueI == NO_VALUE || index >= 0 && !this.lessThan(valueI, value)) continue;
            value = valueI;
            index = i;
        }
        if (index < 0) {
            throw new GeneratorException("No more items");
        }
        this.nextValue(index);
        return (T)value;
    }

    private boolean lessThan(Object o1, Object o2) {
        Comparable c1 = (Comparable)o1;
        Comparable c2 = (Comparable)o2;
        return c1.compareTo(c2) < 0;
    }

    @Override
    public Class<T> getValueType() {
        if (this.valueType == Void.TYPE) {
            this.valueType = GeneratorTools.commonTypeOf(this.generators);
        }
        return this.valueType;
    }

    @Override
    public MergingGenerator<T> copy() {
        return new MergingGenerator<T>(this);
    }

    @Override
    public long randomSeedHint() {
        long seed = DistributionRandomizer.toSeed(this.getClass());
        for (Generator<? extends T> g : this.generators) {
            seed ^= GeneratorTools.getRandomSeedHint(g);
        }
        return seed;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        return GeneratorTools.printList(Arrays.asList(this.generators), sb.append("Merge(")).append(')');
    }
}

