/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators.composite;

import java.util.Arrays;
import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.generators.CopyableGenerator;
import org.cthul.fixsure.generators.GeneratorTools;
import org.cthul.fixsure.generators.GeneratorWithScalar;
import org.cthul.fixsure.generators.primitives.RandomIntegersGenerator;

public class MixingGenerator<T>
extends GeneratorWithScalar<T>
implements CopyableGenerator<T> {
    private final Generator<? extends T>[] generators;
    private Class<?> valueType = Void.TYPE;

    public static <T> MixingGenerator<T> mix(DataSource<? extends T> ... sources) {
        return new MixingGenerator<T>(sources);
    }

    public MixingGenerator(DataSource<? extends T>[] sources) {
        super(RandomIntegersGenerator.integers(sources.length));
        this.generators = DataSource.toGenerators(sources);
    }

    public MixingGenerator(Class<T> valueType, Generator<? extends T>[] generators) {
        this(generators);
        this.valueType = valueType;
    }

    public MixingGenerator(MixingGenerator<T> src) {
        super(src);
        this.generators = (Generator[])src.generators.clone();
        for (int i = 0; i < this.generators.length; ++i) {
            this.generators[i] = GeneratorTools.copyGenerator(this.generators[i]);
        }
        this.valueType = src.valueType;
    }

    @Override
    public T next() {
        return this.generators[this.nextScalar()].next();
    }

    @Override
    public Class<T> getValueType() {
        if (this.valueType == Void.TYPE) {
            this.valueType = GeneratorTools.commonTypeOf(this.generators);
        }
        return this.valueType;
    }

    @Override
    public MixingGenerator<T> copy() {
        return new MixingGenerator<T>(this);
    }

    @Override
    public long randomSeedHint() {
        long seed = DistributionRandomizer.toSeed(this.getClass());
        for (Generator<? extends T> g : this.generators) {
            seed ^= GeneratorTools.getRandomSeedHint(g);
        }
        return seed;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        super.toString(sb.append("Mix(")).append(':');
        return GeneratorTools.printList(Arrays.asList(this.generators), sb).append(')');
    }
}

