/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators.composite;

import org.cthul.fixsure.Distribution;
import org.cthul.fixsure.Sequence;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.generators.CopyableGenerator;
import org.cthul.fixsure.generators.GeneratorTools;
import org.cthul.fixsure.generators.GeneratorWithDistribution;

public class RandomizedSequenceGenerator<T>
extends GeneratorWithDistribution<T>
implements CopyableGenerator<T> {
    private static final long CLASS_SEED = DistributionRandomizer.toSeed(RandomizedSequenceGenerator.class);
    private final Sequence<T> source;
    private final long l;

    public static <T> RandomizedSequenceGenerator<T> random(Sequence<T> seq) {
        return new RandomizedSequenceGenerator<T>(seq);
    }

    public RandomizedSequenceGenerator(Sequence<T> source) {
        this(source, null);
    }

    public RandomizedSequenceGenerator(Sequence<T> source, Distribution distribution) {
        this(source, distribution, RandomizedSequenceGenerator.randomSeedHint(source));
    }

    public RandomizedSequenceGenerator(Sequence<T> source, Distribution distribution, long seedHint) {
        super(distribution, seedHint);
        this.source = source;
        this.l = RandomizedSequenceGenerator.maxLen(source);
    }

    protected RandomizedSequenceGenerator(RandomizedSequenceGenerator src) {
        super(src);
        this.source = src.source;
        this.l = src.l;
    }

    @Override
    public T next() {
        return this.source.value(this.rnd().nextLong(this.l));
    }

    @Override
    public Class<T> getValueType() {
        return GeneratorTools.typeOf(this.source);
    }

    @Override
    public RandomizedSequenceGenerator<T> copy() {
        return new RandomizedSequenceGenerator<T>(this);
    }

    @Override
    public long randomSeedHint() {
        return RandomizedSequenceGenerator.randomSeedHint(this.source);
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        this.source.toString(sb).append('[');
        return super.toString(sb).append(']');
    }

    private static long randomSeedHint(Sequence<?> source) {
        return GeneratorTools.getRandomSeedHint(source) ^ CLASS_SEED;
    }

    private static long maxLen(Sequence<?> source) {
        return source.isUnbounded() ? Long.MAX_VALUE : source.length();
    }
}

