/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators.composite;

import java.util.Arrays;
import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.GeneratorException;
import org.cthul.fixsure.Template;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.generators.CopyableGenerator;
import org.cthul.fixsure.generators.GeneratorTools;

public class RepeatingGenerator<T>
implements CopyableGenerator<T> {
    private final Template<? extends T>[] templates;
    private int nextIndex = 0;
    private Generator<? extends T> current = null;
    private Class<?> valueType = Void.TYPE;

    public static <T> RepeatingGenerator<T> repeat(DataSource<? extends T> ... sources) {
        Template[] templates = new Template[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            templates[i] = sources[i].fluentData().snapshot();
        }
        return new RepeatingGenerator<T>(templates);
    }

    public RepeatingGenerator(Template<? extends T>[] templates) {
        this.templates = (Template[])templates.clone();
    }

    protected RepeatingGenerator(RepeatingGenerator<T> src) {
        this(src.templates);
        this.nextIndex = src.nextIndex;
        if (src.current != null) {
            this.current = GeneratorTools.copyGenerator(src.current);
        }
    }

    @Override
    public T next() {
        if (this.current != null) {
            try {
                return this.current.next();
            }
            catch (GeneratorException generatorException) {
                // empty catch block
            }
        }
        GeneratorException lastException = null;
        for (int i = 0; i < this.templates.length; ++i) {
            this.current = this.templates[this.nextIndex].newGenerator();
            this.nextIndex = (this.nextIndex + 1) % this.templates.length;
            try {
                return this.current.next();
            }
            catch (GeneratorException e) {
                lastException = e;
                continue;
            }
        }
        throw new GeneratorException("No generator provided items", lastException);
    }

    @Override
    public RepeatingGenerator<T> copy() {
        return new RepeatingGenerator<T>(this);
    }

    @Override
    public Class<T> getValueType() {
        if (this.valueType == Void.TYPE) {
            this.valueType = GeneratorTools.commonTypeOf(this.templates);
        }
        return this.valueType;
    }

    @Override
    public long randomSeedHint() {
        return GeneratorTools.getRandomSeedHint(this.current) * 3L ^ DistributionRandomizer.toSeed(this.getClass());
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (this.templates.length == 1) {
            return this.templates[0].toString(sb).append(".repeat()");
        }
        Template<? extends T>[] all = this.templates;
        if (this.current != null) {
            Arrays.copyOf(this.templates, this.templates.length, Object[].class);
            int i = (this.nextIndex + this.templates.length - 1) % this.templates.length;
            all[i] = this.current;
        }
        return GeneratorTools.printList(Arrays.asList(all), sb.append("Repeat(")).append(')');
    }
}

