/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators.composite;

import java.util.Arrays;
import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.generators.CopyableGenerator;
import org.cthul.fixsure.generators.GeneratorTools;

public class RoundRobinGenerator<T>
implements CopyableGenerator<T> {
    private final Generator<? extends T>[] generators;
    private Class<?> valueType = Void.TYPE;
    private int n = 0;

    public static <T> RoundRobinGenerator<T> rotate(DataSource<? extends T> ... generators) {
        return new RoundRobinGenerator<T>(generators);
    }

    public static <T> RoundRobinGenerator<T> alternate(DataSource<? extends T> ... generators) {
        return new RoundRobinGenerator<T>(generators);
    }

    public RoundRobinGenerator(DataSource<? extends T>[] generators) {
        this.generators = DataSource.toGenerators(generators);
    }

    public RoundRobinGenerator(Class<T> valueType, DataSource<? extends T>[] generators) {
        this(generators);
        this.valueType = valueType;
    }

    public RoundRobinGenerator(RoundRobinGenerator<T> src) {
        this.generators = (Generator[])src.generators.clone();
        for (int i = 0; i < this.generators.length; ++i) {
            this.generators[i] = GeneratorTools.copyGenerator(this.generators[i]);
        }
        this.valueType = src.valueType;
        this.n = src.n;
    }

    @Override
    public T next() {
        return this.generators[this.n++].next();
    }

    @Override
    public Class<T> getValueType() {
        if (this.valueType == Void.TYPE) {
            this.valueType = GeneratorTools.commonTypeOf(this.generators);
        }
        return this.valueType;
    }

    @Override
    public RoundRobinGenerator<T> copy() {
        return new RoundRobinGenerator<T>(this);
    }

    @Override
    public long randomSeedHint() {
        long seed = DistributionRandomizer.toSeed(this.getClass());
        for (Generator<? extends T> g : this.generators) {
            seed ^= GeneratorTools.getRandomSeedHint(g);
        }
        return seed;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        return GeneratorTools.printList(Arrays.asList(this.generators), sb.append("Alternate(")).append(')');
    }
}

