/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators.composite;

import java.util.Arrays;
import org.cthul.fixsure.Sequence;
import org.cthul.fixsure.SequenceLength;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.fluents.FlSequence;
import org.cthul.fixsure.generators.GeneratorTools;

public class RoundRobinSequence<T>
implements FlSequence<T> {
    private final Sequence<? extends T>[] sequences;
    private long length = -3L;
    private Class<?> valueType = Void.TYPE;

    public static <T> RoundRobinSequence<T> rotate(Sequence<? extends T> ... generators) {
        return new RoundRobinSequence<T>(generators);
    }

    public static <T> RoundRobinSequence<T> alternate(Sequence<? extends T> ... generators) {
        return new RoundRobinSequence<T>(generators);
    }

    public RoundRobinSequence(Sequence<? extends T>[] generators) {
        this.sequences = generators;
    }

    public RoundRobinSequence(Class<T> valueType, Sequence<? extends T>[] generators) {
        this(generators);
        this.valueType = valueType;
    }

    protected RoundRobinSequence(RoundRobinSequence<T> src) {
        this.sequences = (Sequence[])src.sequences.clone();
        this.length = src.length;
        this.valueType = src.valueType;
    }

    @Override
    public Class<T> getValueType() {
        if (this.valueType == Void.TYPE) {
            this.valueType = GeneratorTools.commonTypeOf(this.sequences);
        }
        return this.valueType;
    }

    @Override
    public T value(long n) {
        int g = (int)(n % (long)this.sequences.length);
        long i = n / (long)this.sequences.length;
        return this.sequences[g].value(i);
    }

    @Override
    public long length() {
        if (this.length == -3L) {
            if (Arrays.stream(this.sequences).allMatch(SequenceLength::negativeIndices)) {
                this.length = -2L;
            } else if (Arrays.stream(this.sequences).allMatch(SequenceLength::isUnbounded)) {
                this.length = -1L;
            } else {
                long l = Long.MAX_VALUE;
                for (Sequence<T> sequence : this.sequences) {
                    long l2 = sequence.length();
                    if (l2 < 0L) continue;
                    l = Math.min(l, l2);
                }
                this.length = l * (long)this.sequences.length / (long)this.sequences.length != l ? -1L : l * (long)this.sequences.length;
            }
        }
        return this.length;
    }

    @Override
    public long randomSeedHint() {
        long seed = DistributionRandomizer.toSeed(this.getClass());
        for (Sequence<? extends T> s : this.sequences) {
            seed ^= GeneratorTools.getRandomSeedHint(s);
        }
        return seed;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        return GeneratorTools.printList(Arrays.asList(this.sequences), sb.append("Alternate(")).append(')');
    }
}

