/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators.composite;

import org.cthul.fixsure.Distribution;
import org.cthul.fixsure.GeneratorException;
import org.cthul.fixsure.Sequence;
import org.cthul.fixsure.api.AbstractStringify;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.distributions.UniformDistribution;
import org.cthul.fixsure.fluents.FlDistribution;
import org.cthul.fixsure.generators.CopyableGenerator;
import org.cthul.fixsure.generators.GeneratorTools;

public class ShuffledSequenceGenerator<T>
extends AbstractStringify
implements CopyableGenerator<T> {
    private static final long CLASS_SEED = DistributionRandomizer.toSeed(ShuffledSequenceGenerator.class);
    private final Sequence<T> source;
    private final long l;
    private final long m;
    private final long first;
    private final int a;
    private final int c;
    private long i = -1L;

    public static <T> ShuffledSequenceGenerator<T> shuffle(Sequence<T> seq) {
        return new ShuffledSequenceGenerator<T>(seq);
    }

    public ShuffledSequenceGenerator(Sequence<T> source) {
        this(source, UniformDistribution.uniform(), CLASS_SEED ^ GeneratorTools.getRandomSeedHint(source));
    }

    public ShuffledSequenceGenerator(Sequence<T> source, Distribution randomSource, long seedHint) {
        this.source = source;
        long len = source.length();
        if (len < 0L) {
            len = Long.MAX_VALUE;
        }
        this.l = len;
        this.m = this.nextPowerOf2(this.l);
        int mInt = this.m > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.m;
        FlDistribution.FlRandom rnd = FlDistribution.wrap(randomSource.toRandomNumbers(seedHint));
        this.c = rnd.nextInt(mInt / 2) * 2 + 1;
        this.a = rnd.nextInt(mInt / 4) * 4 + 1;
        this.first = rnd.nextLong() % this.m;
    }

    protected ShuffledSequenceGenerator(ShuffledSequenceGenerator<T> src) {
        this.source = src.source;
        this.l = src.l;
        this.m = src.m;
        this.c = src.c;
        this.a = src.a;
        this.first = src.first;
        this.i = src.i;
    }

    private long nextPowerOf2(long n) {
        long p;
        if (n < 0L || n > 0x40000000L) {
            return 0x40000000L;
        }
        for (p = 2L; p < n; p <<= 1) {
        }
        return p;
    }

    @Override
    public T next() {
        if (this.i == this.first) {
            throw new GeneratorException();
        }
        if (this.i < 0L) {
            this.i = this.first;
        }
        do {
            this.i = ((long)this.a * this.i + (long)this.c & Long.MAX_VALUE) % this.m;
            if (this.i >= this.l) continue;
            return this.source.value(this.i);
        } while (this.i != this.first);
        throw new GeneratorException();
    }

    @Override
    public Class<T> getValueType() {
        return GeneratorTools.typeOf(this.source);
    }

    @Override
    public ShuffledSequenceGenerator<T> copy() {
        return new ShuffledSequenceGenerator<T>(this);
    }

    @Override
    public long randomSeedHint() {
        return GeneratorTools.getRandomSeedHint(this.source) ^ CLASS_SEED;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        return this.source.toString(sb).append(".shuffle(").append(this.first).append(';').append(this.a).append(';').append(this.c).append(';').append(this.i).append(')');
    }
}

