/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators.composite;

import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Distribution;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.GeneratorException;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.generators.CopyableGenerator;
import org.cthul.fixsure.generators.GeneratorTools;
import org.cthul.fixsure.generators.GeneratorWithDistribution;

public class ShufflingGenerator<T>
extends GeneratorWithDistribution<T>
implements CopyableGenerator<T> {
    private static final long CLASS_SEED = DistributionRandomizer.toSeed(ShufflingGenerator.class);
    private final Generator<T> source;
    private final Object[] hold;
    private int end = -1;

    public static <T> ShufflingGenerator<T> shuffle(DataSource<T> source) {
        return new ShufflingGenerator<T>(source, 64);
    }

    public static <T> ShufflingGenerator<T> shuffle(DataSource<T> source, long seed) {
        return new ShufflingGenerator<T>(source, 64, null, seed);
    }

    public ShufflingGenerator(DataSource<T> source, int hold) {
        this(source, hold, null);
    }

    public ShufflingGenerator(DataSource<T> source, int hold, Distribution distribution) {
        this(source.toGenerator(), hold, distribution);
    }

    private ShufflingGenerator(Generator<T> source, int hold, Distribution distribution) {
        super(distribution, CLASS_SEED ^ GeneratorTools.getRandomSeedHint(source));
        this.source = source;
        this.hold = new Object[hold];
    }

    public ShufflingGenerator(DataSource<T> source, int hold, Distribution distribution, long seedHint) {
        super(distribution, seedHint);
        this.source = source.toGenerator();
        this.hold = new Object[hold];
    }

    protected ShufflingGenerator(ShufflingGenerator src) {
        super(src);
        this.source = src.source;
        this.hold = src.hold;
        this.end = src.end;
    }

    @Override
    public long randomSeedHint() {
        return CLASS_SEED ^ GeneratorTools.getRandomSeedHint(this.source);
    }

    @Override
    public T next() {
        while (this.end < 0) {
            try {
                T value = this.source.next();
                int i = this.rnd().nextInt(this.hold.length);
                Object next = this.hold[i];
                this.hold[i] = value;
                if (next == null) continue;
                return (T)next;
            }
            catch (GeneratorException e) {
                this.end = 0;
            }
        }
        while (this.end < this.hold.length) {
            Object next = this.hold[this.end];
            if (next != null) {
                this.hold[this.end] = null;
                return (T)next;
            }
            ++this.end;
        }
        throw new GeneratorException();
    }

    @Override
    public ShufflingGenerator<T> copy() {
        return new ShufflingGenerator<T>(this);
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        this.source.toString(sb).append(".shuffle(");
        return super.toString(sb).append(')');
    }
}

