/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators.primitives;

import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Distribution;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.api.Factory;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.fluents.FlTemplate;
import org.cthul.fixsure.generators.CopyableGenerator;
import org.cthul.fixsure.generators.GeneratorWithScalar;
import org.cthul.fixsure.generators.primitives.RandomIntegersGenerator;

public abstract class CharactersGenerator
extends GeneratorWithScalar<Character>
implements CopyableGenerator<Character> {
    @Factory
    public static FlTemplate<Character> characters() {
        return () -> new InRange(' ', '~');
    }

    @Factory
    public static FlTemplate<Character> characters(String source) {
        return () -> new FromString(source);
    }

    @Factory
    public static FlTemplate<Character> characters(String source, Distribution distribution) {
        return () -> new FromString(source, distribution);
    }

    @Factory
    public static FlTemplate<Character> characters(char min, char max) {
        return () -> new InRange(min, max);
    }

    @Factory
    public static FlTemplate<Character> characters(char min, char max, Distribution distribution) {
        return () -> new InRange(min, max, distribution);
    }

    public static FlTemplate<Character> characters(DataSource<Integer> range) {
        return () -> new InRange(range.toGenerator());
    }

    public CharactersGenerator(int scalar) {
        super(scalar);
    }

    public CharactersGenerator(DataSource<Integer> scalarGenerator) {
        super(scalarGenerator);
    }

    public CharactersGenerator(int scalar, Distribution distribution, long seed) {
        super(scalar, distribution, seed);
    }

    protected CharactersGenerator(CharactersGenerator src) {
        super(src);
    }

    public abstract char nextValue();

    @Override
    public Character next() {
        return Character.valueOf(this.nextValue());
    }

    @Override
    public Class<Character> getValueType() {
        return Character.class;
    }

    public static class InRange
    extends CharactersGenerator {
        private static final long CLASS_SEED = DistributionRandomizer.toSeed(InRange.class);

        private static long seed(char min, char max) {
            return CLASS_SEED ^ (long)min << 32 ^ (long)max;
        }

        public InRange(char min, char max) {
            super(RandomIntegersGenerator.integers((int)min, max + '\u0001').random(InRange.seed(min, max)));
        }

        public InRange(char min, char max, Distribution distribution) {
            super(RandomIntegersGenerator.integers((int)min, max + '\u0001').random(distribution, InRange.seed(min, max)));
        }

        public InRange(Generator<Integer> range) {
            super(range);
        }

        public InRange(InRange src) {
            super(src);
        }

        @Override
        public char nextValue() {
            return (char)this.nextScalar();
        }

        public InRange copy() {
            return new InRange(this);
        }
    }

    public static class FromString
    extends CharactersGenerator {
        private static final long CLASS_SEED = DistributionRandomizer.toSeed(FromString.class);
        private final String source;

        public FromString(String source) {
            super(source.length());
            this.source = source;
        }

        public FromString(String source, Distribution distribution) {
            super(source.length(), distribution, (long)source.length() ^ CLASS_SEED);
            this.source = source;
        }

        public FromString(FromString src) {
            super(src);
            this.source = src.source;
        }

        @Override
        public char nextValue() {
            return this.source.charAt(this.nextScalar());
        }

        public FromString copy() {
            return new FromString(this);
        }
    }
}

