/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators.primitives;

import org.cthul.fixsure.Distribution;
import org.cthul.fixsure.GeneratorException;
import org.cthul.fixsure.api.Factory;
import org.cthul.fixsure.fluents.FlTemplate;
import org.cthul.fixsure.generators.BoundedSequence;
import org.cthul.fixsure.generators.primitives.RandomIntegersGenerator;

public class ConsecutiveIntegersSequence
extends BoundedSequence<Integer> {
    private final int first;
    private final int step;
    private final int end;

    @Factory
    public static ConsecutiveIntegersSequence consecutiveIntegers() {
        return new ConsecutiveIntegersSequence();
    }

    @Factory
    public static ConsecutiveIntegersSequence consecutiveIntegers(int first) {
        return new ConsecutiveIntegersSequence(first);
    }

    @Factory
    public static ConsecutiveIntegersSequence consecutiveIntegers(int first, int step) {
        return new ConsecutiveIntegersSequence(first, step);
    }

    @Factory
    public static ConsecutiveIntegersSequence consecutiveIntegers(int first, int step, int end) {
        return new ConsecutiveIntegersSequence(first, step, end);
    }

    public ConsecutiveIntegersSequence() {
        this(0, 1, Integer.MAX_VALUE);
    }

    public ConsecutiveIntegersSequence(int first) {
        this(first, 1, Integer.MAX_VALUE);
    }

    public ConsecutiveIntegersSequence(int first, int step) {
        this(first, step, Integer.MAX_VALUE);
    }

    public ConsecutiveIntegersSequence(int first, int step, int end) {
        this.first = first;
        this.step = step;
        this.end = end;
    }

    public ConsecutiveIntegersSequence(ConsecutiveIntegersSequence src) {
        this.first = src.first;
        this.step = src.step;
        this.end = src.end;
    }

    @Override
    public long length() {
        return (this.end - this.first) / this.step;
    }

    @Override
    public Integer value(long n) {
        int v = this.first + (int)n * this.step;
        if (this.step > 0 ? v < this.first || v >= this.end : this.step < 0 && (v > this.first || v <= this.end)) {
            throw new GeneratorException();
        }
        return v;
    }

    public RandomIntegersGenerator.Template random() {
        return RandomIntegersGenerator.integers(this.first, this.end).step(this.step);
    }

    @Override
    public FlTemplate<Integer> random(Distribution distribution, long seed) {
        return this.random().random(distribution, seed);
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append('[').append(this.first).append("..").append(this.end);
        if (this.step != 1) {
            sb.append(';').append(this.step);
        }
        return sb.append(']');
    }
}

