/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators.primitives;

import org.cthul.fixsure.Distribution;
import org.cthul.fixsure.api.Factory;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.fluents.FlTemplate;
import org.cthul.fixsure.generators.CopyableGenerator;
import org.cthul.fixsure.generators.GeneratorWithDistribution;

public class DoublesGenerator
extends GeneratorWithDistribution<Double>
implements CopyableGenerator<Double> {
    private static final long CLASS_SEED = DistributionRandomizer.toSeed(DoublesGenerator.class);
    protected static final double DEFAULT_HIGH = 65536.0;
    protected static final double DEFAULT_LOW = -65536.0;
    private final double base;
    private final double len;

    @Factory
    public static FlTemplate<Double> doubles() {
        return () -> new DoublesGenerator();
    }

    @Factory
    public static FlTemplate<Double> doubles(int high) {
        return () -> new DoublesGenerator((double)high);
    }

    @Factory
    public static FlTemplate<Double> doubles(int high, Distribution distribution) {
        return () -> new DoublesGenerator((double)high, distribution);
    }

    @Factory
    public static FlTemplate<Double> doubles(int low, int high) {
        return () -> new DoublesGenerator((double)low, (double)high);
    }

    @Factory
    public static FlTemplate<Double> doubles(int low, int high, Distribution distribution) {
        return () -> new DoublesGenerator((double)low, high, distribution);
    }

    public DoublesGenerator() {
        this(-65536.0, 65536.0);
    }

    public DoublesGenerator(double high) {
        this(0.0, high);
    }

    public DoublesGenerator(double high, Distribution distribution) {
        this(0.0, high, distribution);
    }

    public DoublesGenerator(double high, Distribution distribution, long seedHint) {
        this(0.0, high, distribution, seedHint);
    }

    public DoublesGenerator(double low, double high) {
        this(low, high, null);
    }

    public DoublesGenerator(double low, double high, Distribution distribution) {
        this(low, high, distribution, CLASS_SEED ^ Double.doubleToLongBits(low) ^ Double.doubleToLongBits(high));
    }

    public DoublesGenerator(double low, double high, Distribution distribution, long seedHint) {
        super(distribution, seedHint);
        if (low == high) {
            throw new IllegalArgumentException("Empty range " + low + " - " + high);
        }
        this.base = low;
        this.len = high - low;
    }

    protected DoublesGenerator(DoublesGenerator src) {
        super(src);
        this.base = src.base;
        this.len = src.len;
    }

    public double nextValue() {
        return this.base + this.len * this.rnd().nextValue();
    }

    @Override
    public Double next() {
        return this.nextValue();
    }

    @Override
    public Class<Double> getValueType() {
        return Double.class;
    }

    public DoublesGenerator copy() {
        return new DoublesGenerator(this);
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append(String.format("{%.2f-%.2f}[", this.base, this.base + this.len));
        return super.toString(sb).append(']');
    }
}

