/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators.primitives;

import org.cthul.fixsure.Distribution;
import org.cthul.fixsure.api.Factory;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.fluents.FlGenerator;
import org.cthul.fixsure.fluents.FlTemplate;
import org.cthul.fixsure.generators.AnonymousTemplate;
import org.cthul.fixsure.generators.CopyableGenerator;
import org.cthul.fixsure.generators.GeneratorWithDistribution;
import org.cthul.fixsure.generators.primitives.ConsecutiveIntegersSequence;

public class RandomIntegersGenerator
extends GeneratorWithDistribution<Integer>
implements CopyableGenerator<Integer> {
    private static final long CLASS_SEED = DistributionRandomizer.toSeed(RandomIntegersGenerator.class);
    protected static final int DEFAULT_LOW = 0;
    protected static final int DEFAULT_HIGH = 131072;
    private static Template TEMPLATE = new Template(null, 0, 131072, 1, null);
    private final int base;
    private final int len;
    private final int mult;

    @Factory
    public static Template integers() {
        return TEMPLATE;
    }

    @Factory
    public static Template integers(int end) {
        return TEMPLATE.lessThan(end);
    }

    @Factory
    public static FlTemplate<Integer> integers(int end, Distribution distribution) {
        return TEMPLATE.lessThan(end).random(distribution);
    }

    @Factory
    public static Template integers(int start, int end) {
        return TEMPLATE.between(start, end);
    }

    @Factory
    public static FlTemplate<Integer> integers(int start, int end, Distribution distribution) {
        return TEMPLATE.between(start, end).random(distribution);
    }

    public RandomIntegersGenerator() {
        this(0, 131072);
    }

    public RandomIntegersGenerator(int end) {
        this(0, end);
    }

    public RandomIntegersGenerator(int end, Distribution distribution) {
        this(0, end, distribution);
    }

    public RandomIntegersGenerator(int end, Distribution distribution, long seedHint) {
        this(0, end, distribution, seedHint);
    }

    public RandomIntegersGenerator(int start, int end) {
        this(start, end, null);
    }

    public RandomIntegersGenerator(int start, int end, Distribution distribution) {
        this(start, end, distribution, CLASS_SEED ^ (long)start ^ (long)end << 32);
    }

    public RandomIntegersGenerator(int start, int end, Distribution distribution, long seedHint) {
        this(start, end, 1, distribution, seedHint);
    }

    public RandomIntegersGenerator(int start, int end, int step, Distribution distribution, long seedHint) {
        super(distribution, seedHint);
        step = Math.abs(step);
        if (start == end) {
            throw new IllegalArgumentException("Empty range " + start + " - " + end);
        }
        if (step == 0) {
            throw new IllegalArgumentException("Step must not be zero");
        }
        if (start < end) {
            this.base = start;
            this.len = (end - start) / step;
            this.mult = step;
        } else {
            this.base = end;
            this.len = (start - end) / step;
            this.mult = -step;
        }
    }

    public RandomIntegersGenerator(RandomIntegersGenerator src) {
        super(src);
        this.base = src.base;
        this.len = src.len;
        this.mult = src.mult;
    }

    public int nextValue() {
        if (this.len == 1) {
            return this.base;
        }
        return this.base + this.mult * this.rnd().nextInt(this.len);
    }

    @Override
    public Integer next() {
        return this.nextValue();
    }

    @Override
    public Class<Integer> getValueType() {
        return Integer.class;
    }

    public RandomIntegersGenerator copy() {
        return new RandomIntegersGenerator(this);
    }

    @Override
    public long randomSeedHint() {
        return CLASS_SEED ^ (long)(this.len * this.mult) ^ (long)this.base << 32;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append('{').append(this.base).append('-').append(this.base + this.len);
        if (Math.abs(this.mult) != 1) {
            sb.append(';').append(Math.abs(this.mult));
        }
        return super.toString(sb.append("}[")).append(']');
    }

    public static class Template
    extends AnonymousTemplate<Integer> {
        private final Distribution distribution;
        private final int start;
        private final int end;
        private final int step;
        private final Long seed;

        public Template(Distribution distribution, int start, int end, int step, Long seed) {
            this.distribution = distribution;
            this.start = start;
            this.end = end;
            this.step = step;
            this.seed = seed;
        }

        @Override
        public Class<Integer> getValueType() {
            return Integer.class;
        }

        @Override
        public FlGenerator<Integer> newGenerator() {
            long s = this.seed != null ? this.seed : CLASS_SEED ^ (long)(this.end * this.step) ^ (long)this.start << 32;
            return new RandomIntegersGenerator(this.start, this.end, this.step, this.distribution, s);
        }

        public Template from(int start) {
            return new Template(this.distribution, start, this.end, this.step, this.seed);
        }

        public Template to(int max) {
            return new Template(this.distribution, this.start, max + 1, this.step, this.seed);
        }

        public Template lessThan(int end) {
            return new Template(this.distribution, this.start, end, this.step, this.seed);
        }

        public Template between(int start, int end) {
            return new Template(this.distribution, start, end, this.step, this.seed);
        }

        public Template step(int step) {
            return new Template(this.distribution, this.start, this.end, step, this.seed);
        }

        public FlTemplate<Integer> random(Distribution distribution) {
            return new Template(distribution, this.start, this.end, this.step, this.seed);
        }

        public FlTemplate<Integer> random(long seed) {
            return new Template(this.distribution, this.start, this.end, this.step, seed);
        }

        public FlTemplate<Integer> random(Distribution distribution, long seed) {
            return new Template(distribution, this.start, this.end, this.step, seed);
        }

        public ConsecutiveIntegersSequence ordered() {
            return new ConsecutiveIntegersSequence(this.start, this.step, this.end);
        }

        @Override
        public FlTemplate<Integer> shuffle() {
            return this.ordered().shuffle();
        }

        @Override
        public FlTemplate<Integer> shuffle(long seed) {
            return this.ordered().shuffle(seed);
        }
    }
}

