/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators.primitives;

import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.api.Factory;
import org.cthul.fixsure.fluents.FlTemplate;
import org.cthul.fixsure.generators.CopyableGenerator;
import org.cthul.fixsure.generators.GeneratorTools;
import org.cthul.fixsure.generators.GeneratorWithScalar;
import org.cthul.fixsure.generators.primitives.CharactersGenerator;

public class StringsGenerator
extends GeneratorWithScalar<String>
implements CopyableGenerator<String> {
    protected static final int DEFAULT_LENGTH = 16;
    private final Generator<Character> characters;

    @Factory
    public static FlTemplate<String> strings() {
        return () -> new StringsGenerator();
    }

    @Factory
    public static FlTemplate<String> strings(int length) {
        return () -> new StringsGenerator(length);
    }

    @Factory
    public static FlTemplate<String> strings(DataSource<Character> characters) {
        return () -> new StringsGenerator(characters);
    }

    @Factory
    public static FlTemplate<String> strings(DataSource<Character> characters, int length) {
        return () -> new StringsGenerator(characters, length);
    }

    @Factory
    public static FlTemplate<String> strings(DataSource<Character> characters, DataSource<Integer> length) {
        return () -> new StringsGenerator(characters, length);
    }

    @Factory
    public static FlTemplate<String> strings(char min, char max) {
        return () -> new StringsGenerator((DataSource<Character>)CharactersGenerator.characters(min, max));
    }

    @Factory
    public static FlTemplate<String> strings(char min, char max, int length) {
        return () -> new StringsGenerator(CharactersGenerator.characters(min, max), length);
    }

    public StringsGenerator(DataSource<Character> characters) {
        this(characters, 16);
    }

    public StringsGenerator(DataSource<Character> characters, int length) {
        super(length != -1 ? length : 16);
        this.characters = characters != null ? characters.toGenerator() : CharactersGenerator.characters().newGenerator();
    }

    public StringsGenerator(DataSource<Character> characters, DataSource<Integer> length) {
        super(length);
        this.characters = characters != null ? characters.toGenerator() : CharactersGenerator.characters().newGenerator();
    }

    public StringsGenerator(int length) {
        this(CharactersGenerator.characters(), length);
    }

    public StringsGenerator() {
        this(null, 16);
    }

    public StringsGenerator(StringsGenerator src) {
        super(src);
        this.characters = GeneratorTools.copyGenerator(src.characters);
    }

    @Override
    public String next() {
        int len = this.nextScalar();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(this.characters.next());
        }
        return sb.toString();
    }

    @Override
    public Class<String> getValueType() {
        return String.class;
    }

    public StringsGenerator copy() {
        return new StringsGenerator(this);
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        super.toString(sb).append(" of ");
        return this.characters.toString(sb);
    }
}

