/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators.primitives;

import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.fluents.FlSequence;
import org.cthul.fixsure.fluents.FlTemplate;
import org.cthul.fixsure.generators.primitives.DoublesGenerator;
import org.cthul.fixsure.generators.primitives.RandomIntegersGenerator;
import org.cthul.fixsure.generators.value.ItemsSequence;

public class TestValues {
    private static final ItemsSequence<Integer> DEFAULT_INTS = ItemsSequence.sequence(0, 1, -1, 2, -2, 255, -256, 65536, -65536, Integer.MAX_VALUE, Integer.MIN_VALUE);
    private static final ItemsSequence<Double> DEFAULT_DOUBLES = ItemsSequence.sequence(0.0, 0.9, -0.9, 1.0, -1.0, 1.5, -1.5, 2.0, -2.0, Math.PI, -Math.PI, 255.0, -256.0, 65536.0, -65536.0);
    private static final ItemsSequence<Double> SPECIAL_DOUBLES = ItemsSequence.sequence(Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    private static final FlTemplate<Integer> TEST_INTS = TestValues.defaultIntegers().then(new DataSource[]{RandomIntegersGenerator.integers()});
    private static final FlTemplate<Double> TEST_DOUBLES = TestValues.defaultDoubles().then(new DataSource[]{DoublesGenerator.doubles()});
    private static final FlTemplate<Double> TEST_SPECIAL_DOUBLES = TestValues.defaultDoubles().then(new DataSource[]{TestValues.specialDoubles(), DoublesGenerator.doubles()});

    private TestValues() {
    }

    public static ItemsSequence<Integer> defaultIntegers() {
        return DEFAULT_INTS;
    }

    public static FlTemplate<Integer> testIntegers() {
        return TEST_INTS;
    }

    public static FlSequence<Double> defaultDoubles() {
        return DEFAULT_DOUBLES;
    }

    public static FlTemplate<Double> testDoubles() {
        return TEST_DOUBLES;
    }

    public static FlSequence<Double> specialDoubles() {
        return SPECIAL_DOUBLES;
    }

    public static FlTemplate<Double> specialTestDoubles() {
        return TEST_SPECIAL_DOUBLES;
    }
}

