/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators.value;

import java.util.function.Supplier;
import org.cthul.fixsure.Distribution;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.api.AbstractStringify;
import org.cthul.fixsure.api.Factory;
import org.cthul.fixsure.api.Stringify;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.fluents.FlGenerator;
import org.cthul.fixsure.fluents.FlSequence;
import org.cthul.fixsure.fluents.FlTemplate;

public class ConstantValue<T>
extends AbstractStringify
implements FlSequence<T> {
    private static final ConstantValue NULLS = new ConstantValue<Object>(null);
    private final T value;

    @Factory
    public static <T> ConstantValue<T> constant(T value) {
        return new ConstantValue<T>(value);
    }

    @Factory
    public static <T> FlTemplate<T> constant(Supplier<? extends T> valueSupplier) {
        return () -> ConstantValue.constant(valueSupplier.get()).newGenerator();
    }

    @Factory
    public static <T> ConstantValue<T> nullValues() {
        return NULLS;
    }

    public ConstantValue(T value) {
        this.value = value;
    }

    @Override
    public Class<T> getValueType() {
        if (this.value == null) {
            return null;
        }
        return this.value.getClass();
    }

    @Override
    public T value(long n) {
        return this.value;
    }

    @Override
    public long length() {
        return -2L;
    }

    @Override
    public FlGenerator<T> newGenerator() {
        return Generator.generate(this.getValueType(), () -> this.value);
    }

    @Override
    public FlTemplate<T> random(Distribution distribution, long seed) {
        return this;
    }

    @Override
    public FlTemplate<T> shuffle(long seed) {
        return this;
    }

    @Override
    public FlTemplate<T> shuffle() {
        return this;
    }

    @Override
    public long randomSeedHint() {
        return DistributionRandomizer.toSeed(this.getClass());
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        return Stringify.toString(this.value, sb.append("Repeat(")).append(')');
    }
}

