/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators.value;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import org.cthul.fixsure.api.Factory;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.fluents.FlGenerator;
import org.cthul.fixsure.generators.BoundedSequence;
import org.cthul.fixsure.generators.GeneratorTools;

public abstract class ItemsSequence<T>
extends BoundedSequence<T> {
    @Factory
    public static <T> ItemsSequence<T> sequence(T ... data) {
        return new FromArray<T>(data);
    }

    @Factory
    public static <T> ItemsSequence<T> sequence(Collection<T> data) {
        Class vt = GeneratorTools.typeOf(data);
        return ItemsSequence.sequence(vt, data);
    }

    @Factory
    public static <T> ItemsSequence<T> sequence(Class<T> valueType, Collection<T> data) {
        if (data instanceof List && data instanceof RandomAccess) {
            return new FromRAList<T>(valueType, (List)data);
        }
        return new FromCollection<T>(valueType, data);
    }

    @Override
    public long randomSeedHint() {
        return this.length() ^ DistributionRandomizer.toSeed(this.getClass());
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        return GeneratorTools.printList(this.dataForPrinting(), sb.append('{')).append('}');
    }

    protected abstract Collection<?> dataForPrinting();

    public static class FromCollection<T>
    extends ItemsSequence<T> {
        private final Collection<T> data;
        private final Class<T> valueType;
        private Iterator<? extends T> it;
        private long position;

        public FromCollection(Class<T> valueType, Collection<T> data) {
            this.valueType = valueType;
            this.data = data;
            this.it = data.iterator();
            this.position = 0L;
        }

        private void gotoIndex(long index) {
            if (this.position > index) {
                this.position = 0L;
                this.it = this.data.iterator();
            }
            while (this.position < index) {
                this.it.next();
                ++this.position;
            }
        }

        private FlGenerator<T> superNewGenerator() {
            return super.newGenerator();
        }

        @Override
        public FlGenerator<T> newGenerator() {
            return super.superNewGenerator();
        }

        @Override
        public T value(long n) {
            this.gotoIndex(n);
            ++this.position;
            return this.it.next();
        }

        @Override
        public long length() {
            return this.data.size();
        }

        @Override
        protected Collection<?> dataForPrinting() {
            return this.data;
        }
    }

    public static class FromRAList<T>
    extends ItemsSequence<T> {
        private final List<? extends T> data;
        private final Class<T> valueType;

        public FromRAList(List<? extends T> data) {
            this(null, data);
        }

        public FromRAList(Class<T> valueType, List<? extends T> data) {
            this.valueType = valueType;
            this.data = data;
        }

        @Override
        public Class<T> getValueType() {
            if (this.valueType != null) {
                return this.valueType;
            }
            return super.getValueType();
        }

        @Override
        public T value(long n) {
            return this.data.get((int)n);
        }

        @Override
        public long length() {
            return this.data.size();
        }

        @Override
        protected Collection<?> dataForPrinting() {
            return this.data;
        }
    }

    public static class FromArray<T>
    extends ItemsSequence<T> {
        private final T[] data;

        public FromArray(T[] data) {
            this.data = data;
        }

        @Override
        public Class<T> getValueType() {
            return this.data.getClass().getComponentType();
        }

        @Override
        public T value(long n) {
            return this.data[(int)n];
        }

        @Override
        public long length() {
            return this.data.length;
        }

        @Override
        protected Collection<?> dataForPrinting() {
            return Arrays.asList(this.data);
        }
    }
}

