/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.generators.value;

import java.util.Arrays;
import org.cthul.fixsure.GeneratorException;
import org.cthul.fixsure.api.AbstractStringify;
import org.cthul.fixsure.api.Factory;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.fluents.FlTemplate;
import org.cthul.fixsure.generators.CopyableGenerator;
import org.cthul.fixsure.generators.GeneratorTools;

public class PermutationsGenerator<T>
extends AbstractStringify
implements CopyableGenerator<T[]> {
    private static final int DIRECTION_MASK = 3;
    private static final int LEFT = -1;
    private static final int STOP = 0;
    private static final int RIGHT = 1;
    private final T[] array;
    private final int[] directions;
    private boolean beforeFirst = true;

    @Factory
    public static <T> FlTemplate<T[]> permutations(T ... array) {
        Object[] clone = (Object[])array.clone();
        return () -> new PermutationsGenerator<Object>(clone);
    }

    public PermutationsGenerator(T[] array) {
        this.array = (Object[])array.clone();
        this.directions = new int[array.length];
        this.initDirections();
    }

    protected PermutationsGenerator(PermutationsGenerator<T> src) {
        this.array = (Object[])src.array.clone();
        this.directions = (int[])src.directions.clone();
        this.beforeFirst = src.beforeFirst;
    }

    @Override
    public PermutationsGenerator<T> copy() {
        return new PermutationsGenerator<T>(this);
    }

    @Override
    public Class<T[]> getValueType() {
        return this.array.getClass();
    }

    private void initDirections() {
        if (this.directions.length > 0) {
            this.directions[0] = this.setDirection(0, 0);
            for (int i = 1; i < this.directions.length; ++i) {
                this.directions[i] = this.setDirection(i << 2, -1);
            }
        }
    }

    private int getDirection(int value) {
        int d = value & 3;
        return d == 3 ? -1 : d;
    }

    private int setDirection(int value, int direction) {
        return value & 0xFFFFFFFC | direction & 3;
    }

    private void swap(int a, int b) {
        int d = this.directions[a];
        this.directions[a] = this.directions[b];
        this.directions[b] = d;
        T t = this.array[a];
        this.array[a] = this.array[b];
        this.array[b] = t;
    }

    @Override
    public T[] next() {
        if (this.beforeFirst) {
            this.beforeFirst = false;
        } else {
            this.nextPermutation();
        }
        return (Object[])this.array.clone();
    }

    protected void nextPermutation() {
        int v;
        int i;
        int index = -1;
        int value = -1;
        int dir = 0;
        for (int i2 = 0; i2 < this.directions.length; ++i2) {
            int d;
            int v2 = this.directions[i2];
            if (v2 <= value || (d = this.getDirection(v2)) == 0) continue;
            index = i2;
            value = v2;
            dir = d;
        }
        if (index < 0) {
            throw new GeneratorException("No more permutations");
        }
        int newIndex = index + dir;
        this.swap(index, newIndex);
        if (newIndex == 0 || newIndex + 1 == this.directions.length || this.directions[newIndex + dir] > value) {
            this.directions[newIndex] = this.setDirection(value, 0);
        }
        for (i = 0; i < newIndex; ++i) {
            v = this.directions[i];
            if (v <= value) continue;
            this.directions[i] = this.setDirection(v, 1);
        }
        for (i = newIndex + 1; i < this.directions.length; ++i) {
            v = this.directions[i];
            if (v <= value) continue;
            this.directions[i] = this.setDirection(v, -1);
        }
    }

    @Override
    public long randomSeedHint() {
        return (long)this.array.length ^ DistributionRandomizer.toSeed(this.getClass());
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        return GeneratorTools.printList(Arrays.asList(this.array), sb.append('{')).append("}.permutations()");
    }
}

