/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.values;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.GeneratorException;
import org.cthul.fixsure.fluents.FlValues;
import org.cthul.fixsure.generators.GeneratorTools;
import org.cthul.fixsure.values.AbstractValues;
import org.cthul.fixsure.values.LazyValues;

public class EagerValues<T>
extends AbstractValues<T> {
    private final List<T> values;

    public static <T> EagerValues<T> first(int n, DataSource<T> values) {
        return new EagerValues<T>(values, n);
    }

    public static <T> EagerValues<T> first(Generator<Integer> n, DataSource<T> values) {
        return new EagerValues<T>(values, n.next());
    }

    public static <T> EagerValues<T> firstOf(DataSource<T> values) {
        return new EagerValues<T>(values, 1);
    }

    public static <T> EagerValues<T> next(int n, DataSource<T> values) {
        return new EagerValues<T>(values, n);
    }

    public static <T> EagerValues<T> next(Generator<Integer> n, DataSource<T> values) {
        return new EagerValues<T>(values, n.next());
    }

    public static <T> EagerValues<T> all(DataSource<T> values) {
        return new EagerValues<T>(values, -1);
    }

    public EagerValues(DataSource<? extends T> values, int length) {
        super(GeneratorTools.typeOf(values));
        Generator<T> gen = values.toGenerator();
        if (length < 0) {
            this.values = new ArrayList<T>();
            try {
                while (true) {
                    this.values.add(gen.next());
                }
            }
            catch (GeneratorException generatorException) {}
        } else {
            this.values = new ArrayList<T>(length);
            for (int i = 0; i < length; ++i) {
                this.values.add(gen.next());
            }
        }
    }

    protected EagerValues(Class<T> valueType, Collection<T> initial, DataSource<? extends T> values, int length) {
        super(valueType);
        this.values = new ArrayList<T>(initial.size() + length);
        this.values.addAll(initial);
        Generator<T> gen = values.toGenerator();
        for (int i = 0; i < length; ++i) {
            this.values.add(gen.next());
        }
    }

    protected EagerValues(Class<T> valueType, Collection<T> values, Collection<? extends T> moreValues) {
        super(valueType);
        this.values = new ArrayList<T>(values.size() + moreValues.size());
        this.values.addAll(values);
        this.values.addAll(moreValues);
    }

    protected void _add(T value) {
        this.values.add(value);
    }

    protected void _add(DataSource<? extends T> values, int length) {
        Generator<T> gen = values.toGenerator();
        for (int i = 0; i < length; ++i) {
            this.values.add(gen.next());
        }
    }

    protected void _addAll(Collection<T> values) {
        values.addAll(values);
    }

    @Override
    public T get(int index) {
        return this.values.get(index);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public LazyValues<T> then(DataSource<? extends T> moreValues) {
        return new LazyValues<T>(this.values, moreValues);
    }

    @Override
    public EagerValues<T> then(int n, DataSource<? extends T> moreValues) {
        return new EagerValues<T>(this.getValueType(), this.values, moreValues, n);
    }

    @Override
    public FlValues<T> then(Collection<? extends T> moreValues) {
        if (moreValues.size() < 256) {
            return new EagerValues<T>(this.getValueType(), this.values, moreValues);
        }
        return new LazyValues<T>(this.getValueType(), this.values, moreValues);
    }
}

