/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.values;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.GeneratorException;
import org.cthul.fixsure.generators.GeneratorTools;
import org.cthul.fixsure.values.AbstractValues;

public class LazyValues<T>
extends AbstractValues<T> {
    private Fetch<T> values;
    private final List<T> cache;
    private int totalSize;
    private Queue<Fetch<T>> moreValues = null;

    public static <T> LazyValues<T> any(int n, DataSource<? extends T> values) {
        return new LazyValues<T>(values, n);
    }

    public static <T> LazyValues<T> any(Generator<Integer> n, DataSource<? extends T> values) {
        return new LazyValues<T>(values, n.next());
    }

    public static <T> LazyValues<T> unbound(DataSource<? extends T> values) {
        return new LazyValues<T>(values);
    }

    public LazyValues(DataSource<? extends T> values, int n) {
        this(null, values, n);
    }

    public LazyValues(Collection<? extends T> initial, DataSource<? extends T> values, int n) {
        this(initial, values, null, n);
    }

    public LazyValues(DataSource<? extends T> values) {
        this(null, values, -1);
    }

    public LazyValues(Collection<? extends T> initial, DataSource<? extends T> values) {
        this(initial, values, null, -1);
    }

    protected LazyValues(Class<T> valueType, Collection<? extends T> values, Collection<? extends T> moreValues) {
        super(valueType);
        this.values = new FetchCollection<T>(moreValues);
        long total = (long)values.size() + (long)moreValues.size();
        if (total >= Integer.MAX_VALUE) {
            total = -1L;
        }
        this.totalSize = (int)total;
        this.cache = new ArrayList<T>(values);
    }

    protected LazyValues(Collection<? extends T> initial, DataSource<? extends T> values, Collection<? extends Fetch<T>> moreValues, int n) {
        super(GeneratorTools.typeOf(values));
        this.values = n < 0 ? new FetchAll<T>(values) : new FetchFixed<T>(values, n);
        this.totalSize = n;
        this.cache = initial != null ? new ArrayList<T>(initial) : new ArrayList<T>();
        if (moreValues != null) {
            this.moreValues = new LinkedList<Fetch<T>>();
            this.copyAll(moreValues, this.moreValues);
        }
    }

    protected LazyValues(LazyValues<T> src) {
        super(src.getValueType());
        this.values = src.values.copy();
        this.totalSize = src.totalSize;
        this.cache = new ArrayList<T>(src.cache);
        if (src.moreValues != null) {
            this.moreValues = new LinkedList<Fetch<T>>();
            this.copyAll(this.moreValues, this.moreValues);
        }
    }

    private void copyAll(Collection<? extends Fetch<T>> src, Collection<Fetch<T>> target) {
        for (Fetch<T> f : src) {
            target.add(f.copy());
        }
    }

    protected void _add(DataSource<? extends T> value) {
        if (this.moreValues == null) {
            this.moreValues = new LinkedList<Fetch<T>>();
        }
        this.moreValues.add(new FetchAll<T>(value));
        this.totalSize = -1;
    }

    protected void _add(DataSource<? extends T> value, int n) {
        if (this.moreValues == null) {
            this.moreValues = new LinkedList<Fetch<T>>();
        }
        this.moreValues.add(new FetchFixed<T>(value, n));
        if (this.totalSize >= 0) {
            this.totalSize += n;
        }
    }

    protected void _add(Collection<? extends T> value) {
        if (this.moreValues == null) {
            this.moreValues = new LinkedList<Fetch<T>>();
        }
        this.moreValues.add(new FetchCollection<T>(value));
        this.totalSize = -1;
    }

    @Override
    public T get(int index) {
        if (this.cache.size() <= index) {
            this.fetchValues(index - this.cache.size() + 1);
        }
        return this.cache.get(index);
    }

    @Override
    public int size() {
        if (this.totalSize < 0) {
            return Integer.MAX_VALUE;
        }
        return this.totalSize;
    }

    private void fetchValues(int i) {
        if (this.totalSize >= 0 && this.cache.size() + i > this.totalSize) {
            i = this.totalSize - this.cache.size();
        }
        while (i > 0) {
            try {
                i -= this.values.fetch(this.cache, i);
            }
            catch (GeneratorException e) {
                if (!this.values.expectException()) {
                    throw e;
                }
                if (this.moreValues == null || this.moreValues.isEmpty()) {
                    throw e;
                }
                this.values = this.moreValues.remove();
                ++i;
            }
        }
    }

    @Override
    public LazyValues<T> then(DataSource<? extends T> moreValues) {
        LazyValues<? extends T> r = new LazyValues<T>(this);
        r._add(moreValues);
        return r;
    }

    @Override
    public LazyValues<T> then(int n, DataSource<? extends T> moreValues) {
        LazyValues<? extends T> r = new LazyValues<T>(this);
        r._add(moreValues, n);
        return r;
    }

    @Override
    public LazyValues<T> then(Collection<? extends T> moreValues) {
        LazyValues<? extends T> r = new LazyValues<T>(this);
        r._add(moreValues);
        return r;
    }

    private static class FetchCollection<T>
    extends Fetch<T> {
        private final Iterator<? extends T> values;

        public FetchCollection(Iterator<? extends T> values) {
            this.values = values;
        }

        public FetchCollection(Collection<? extends T> values) {
            this.values = values.iterator();
        }

        @Override
        public int fetch(List<T> target, int n) {
            for (int i = 0; i < n; ++i) {
                target.add(this.values.next());
            }
            return n;
        }

        @Override
        public boolean expectException() {
            return true;
        }

        @Override
        public Fetch<T> copy() {
            return new FetchCollection<T>(this.values);
        }
    }

    private static class FetchAll<T>
    extends Fetch<T> {
        private final Generator<? extends T> values;

        public FetchAll(DataSource<? extends T> values) {
            this.values = values.toGenerator();
        }

        @Override
        public int fetch(List<T> target, int n) {
            for (int i = 0; i < n; ++i) {
                target.add(this.values.next());
            }
            return n;
        }

        @Override
        public boolean expectException() {
            return true;
        }

        @Override
        public Fetch<T> copy() {
            return new FetchAll<T>(this.values);
        }
    }

    private static class FetchFixed<T>
    extends Fetch<T> {
        private final Generator<? extends T> values;
        private int rem;

        public FetchFixed(DataSource<? extends T> values, int size) {
            this.values = values.toGenerator();
            this.rem = size;
        }

        @Override
        public int fetch(List<T> target, int n) {
            if (n > this.rem) {
                n = this.rem;
            }
            for (int i = 0; i < n; ++i) {
                target.add(this.values.next());
            }
            this.rem -= n;
            return n;
        }

        @Override
        public boolean expectException() {
            return false;
        }

        @Override
        public Fetch<T> copy() {
            return new FetchFixed<T>(this.values, this.rem);
        }
    }

    protected static abstract class Fetch<T> {
        protected Fetch() {
        }

        public abstract int fetch(List<T> var1, int var2);

        public abstract boolean expectException();

        public abstract Fetch<T> copy();
    }
}

