// generated code
package org.cthul.fixsure.data;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.cthul.fixsure.Sequence;
import org.cthul.fixsure.fluents.FlSequence;
import org.cthul.fixsure.fluents.BiSequence;
import static org.cthul.fixsure.Fixsure.*;


/**
 *
 */
public class English {

    /**
     * Returns a {@link Sequence} of popular first names.
     * @return sequence of names
     */
    public static FlSequence<String> firstNames() {
        if (SEQ_firstNames == null) {
            SEQ_firstNames = sequence(Arrays.stream(DataLoader.readLines(English.class, "en/FirstNames.txt"))
                    .filter(s -> true)
                    .map(s -> s.substring(2))
                    .collect(Collectors.toList())
                    .toArray(new String[0]));
        }
        return SEQ_firstNames;
    }
    private static FlSequence<String> SEQ_firstNames = null;

    /**
     * Returns a sorted {@link Sequence} of popular first names.
     * @return sequence of names
     */
    public static FlSequence<String> sortedFirstNames() {
        if (SEQ_sortedFirstNames == null) {
            SEQ_sortedFirstNames = sequence(sorted(firstNames()));
        }
        return SEQ_sortedFirstNames;
    }
    private static FlSequence<String> SEQ_sortedFirstNames = null;

    /**
     * Returns a {@link Sequence} of popular male first names.
     * @return sequence of names
     */
    public static FlSequence<String> maleFirstNames() {
        if (SEQ_maleFirstNames == null) {
            SEQ_maleFirstNames = sequence(Arrays.stream(DataLoader.readLines(English.class, "en/FirstNames.txt"))
                    .filter(s -> s.startsWith("M;"))
                    .map(s -> s.substring(2))
                    .collect(Collectors.toList())
                    .toArray(new String[0]));
        }
        return SEQ_maleFirstNames;
    }
    private static FlSequence<String> SEQ_maleFirstNames = null;

    /**
     * Returns a sorted {@link Sequence} of popular male first names.
     * @return sequence of names
     */
    public static FlSequence<String> sortedMaleFirstNames() {
        if (SEQ_sortedMaleFirstNames == null) {
            SEQ_sortedMaleFirstNames = sequence(sorted(maleFirstNames()));
        }
        return SEQ_sortedMaleFirstNames;
    }
    private static FlSequence<String> SEQ_sortedMaleFirstNames = null;

    /**
     * Returns a {@link Sequence} of popular female first names.
     * @return sequence of names
     */
    public static FlSequence<String> femaleFirstNames() {
        if (SEQ_femaleFirstNames == null) {
            SEQ_femaleFirstNames = sequence(Arrays.stream(DataLoader.readLines(English.class, "en/FirstNames.txt"))
                    .filter(s -> s.startsWith("F;"))
                    .map(s -> s.substring(2))
                    .collect(Collectors.toList())
                    .toArray(new String[0]));
        }
        return SEQ_femaleFirstNames;
    }
    private static FlSequence<String> SEQ_femaleFirstNames = null;

    /**
     * Returns a sorted {@link Sequence} of popular female first names.
     * @return sequence of names
     */
    public static FlSequence<String> sortedFemaleFirstNames() {
        if (SEQ_sortedFemaleFirstNames == null) {
            SEQ_sortedFemaleFirstNames = sequence(sorted(femaleFirstNames()));
        }
        return SEQ_sortedFemaleFirstNames;
    }
    private static FlSequence<String> SEQ_sortedFemaleFirstNames = null;

    /**
     * Returns a {@link Sequence} of popular last names.
     * @return sequence of names
     */
    public static FlSequence<String> lastNames() {
        if (SEQ_lastNames == null) {
            SEQ_lastNames = sequence(DataLoader.readLines(English.class, "en/LastNames.txt"));
        }
        return SEQ_lastNames;
    }
    private static FlSequence<String> SEQ_lastNames = null;

    /**
     * Returns a sorted {@link Sequence} of popular last names.
     * @return sequence of names
     */
    public static FlSequence<String> sortedLastNames() {
        if (SEQ_sortedLastNames == null) {
            SEQ_sortedLastNames = sequence(sorted(lastNames()));
        }
        return SEQ_sortedLastNames;
    }
    private static FlSequence<String> SEQ_sortedLastNames = null;

    /**
     * Returns a {@link BiSequence} of popular first names,
     * with a character signifying the gender ('M' or 'F').
     * @return sequence of names and gender
     */
    public static BiSequence<String, Character> firstNamesWithGender() {
        if (SEQ_firstNamesWithGender == null) {
            Character[] genders = Arrays.stream(DataLoader.readLines(English.class, "en/FirstNames.txt"))
                    .map(s -> s.charAt(0))
                    .collect(Collectors.toList())
                    .toArray(new Character[0]);
            SEQ_firstNamesWithGender = firstNames().with(sequence(genders));
        }
        return SEQ_firstNamesWithGender;
    }
    private static BiSequence<String, Character> SEQ_firstNamesWithGender;

    /**
     * Returns a {@link Sequence} of first names with initial letters from A to Z.
     * @return sequence of names
     */
    public static FlSequence<String> aliceBob() {
        if (SEQ_aliceBob == null) {
            SEQ_aliceBob = sequence(DataLoader.readLines(English.class, "en/AliceBob.txt"));
        }
        return SEQ_aliceBob;
    }
    private static FlSequence<String> SEQ_aliceBob = null;

    /**
     * Returns a {@link Sequence} of first names with initial letters from A to Z,
     * with a character signifying the gender ('M' or 'F').
     * @return sequence of names and gender
     */    
    public static BiSequence<String, Character> aliceBobWithGender() {
        if (SEQ_aliceBobWithGender == null) {
            SEQ_aliceBobWithGender = aliceBob()
                    .with(Sequence.sequence(n -> (n < 12) ^ (n % 2 == 0) ? 'M' : 'F'));
        }
        return SEQ_aliceBobWithGender;
    }
    private static BiSequence<String, Character> SEQ_aliceBobWithGender;

    /**
     * Returns a {@link Sequence} of fruits with initial letters from A to Z.
     * @return sequence of names
     */
    public static FlSequence<String> fruits() {
        if (SEQ_fruits == null) {
            SEQ_fruits = sequence(DataLoader.readLines(English.class, "en/FruitsA2Z.txt"));
        }
        return SEQ_fruits;
    }
    private static FlSequence<String> SEQ_fruits = null;

    /**
     * Returns a {@link Sequence} of vegetables with initial letters from A to Z.
     * @return sequence of names
     */
    public static FlSequence<String> vegetables() {
        if (SEQ_vegetables == null) {
            SEQ_vegetables = sequence(DataLoader.readLines(English.class, "en/VegetablesA2Z.txt"));
        }
        return SEQ_vegetables;
    }
    private static FlSequence<String> SEQ_vegetables = null;

    /**
     * Returns a {@link Sequence} of the NATO phonetic alphabet.
     * @return sequence of letter names
     */
    public static FlSequence<String> phoneticAlphabet() {
        if (SEQ_phoneticAlphabet == null) {
            SEQ_phoneticAlphabet = sequence(DataLoader.readLines(English.class, "en/PhoneticAlphabet.txt"));
        }
        return SEQ_phoneticAlphabet;
    }
    private static FlSequence<String> SEQ_phoneticAlphabet = null;


    protected static String[] sorted(FlSequence<String> a1) {
        String[] result = a1.all().toArray();
        Arrays.sort(result);
        return result;
    }

    private static final String BLIND_TEXT = "This is a blind text.";
    private static final String[] BLIND_TEXT_WORDS = BLIND_TEXT.split(" ");

    /**
     * Returns a {@link Sequence} of words that form an english blind text.
     * @return sequence of words
     */
    public static FlSequence<String> blindTextWords() {
        if (SEQ_blindTextWords == null) {
            SEQ_blindTextWords = sequence(BLIND_TEXT_WORDS);
        }
        return SEQ_blindTextWords;
    }
    private static FlSequence<String> SEQ_blindTextWords = null;
    
}
