/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.data;

import java.util.Locale;
import java.util.function.Function;
import org.cthul.fixsure.factory.ValueGenerator;
import org.cthul.strings.Formatter;
import org.cthul.strings.format.FormatArgs;
import org.cthul.strings.format.FormatterConfiguration;

public class StringFormatter {
    private static final StringFormatter INSTANCE = new StringFormatter(FormatterConfiguration.getDefault().forLocale(Locale.ENGLISH));
    private final FormatterConfiguration config;

    public static FormatterConfiguration getConfiguration() {
        return StringFormatter.INSTANCE.config;
    }

    public static StringFormatter getInstance() {
        return INSTANCE;
    }

    public static Function<ValueGenerator.ValueMap, String> formatString(String formatString) {
        return StringFormatter.getInstance().format(formatString);
    }

    public static Function<ValueGenerator.ValueMap, String> formatString(String formatString, Object ... args) {
        return StringFormatter.getInstance().format(formatString, args);
    }

    public StringFormatter(FormatterConfiguration config) {
        this.config = config;
    }

    public Function<ValueGenerator.ValueMap, String> format(String formatString) {
        return this.format(formatString, null);
    }

    public Function<ValueGenerator.ValueMap, String> format(final String formatString, final Object ... args) {
        return new Function<ValueGenerator.ValueMap, String>(){

            @Override
            public String apply(ValueGenerator.ValueMap valueMap) {
                return new Formatter(StringFormatter.this.config).format((Object)formatString, (FormatArgs)new Args(args, valueMap)).toString();
            }

            public String toString() {
                return formatString;
            }
        };
    }

    protected static class Args
    implements FormatArgs {
        private final Object[] args;
        private final ValueGenerator.ValueMap values;

        public Args(Object[] args, ValueGenerator.ValueMap values) {
            this.args = args;
            this.values = values;
        }

        public Object get(int i) {
            if (this.args == null || i < 0 || this.args.length < i) {
                throw new IndexOutOfBoundsException("" + i);
            }
            return this.args[i];
        }

        public Object get(char c) {
            throw new IllegalArgumentException("" + c);
        }

        public Object get(String s) {
            return this.values.get(s);
        }
    }
}

