/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.fixsure.data;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.function.LongFunction;
import org.cthul.fixsure.DataSource;
import org.cthul.fixsure.Distribution;
import org.cthul.fixsure.Fixsure;
import org.cthul.fixsure.Generator;
import org.cthul.fixsure.Sequence;
import org.cthul.fixsure.data.English;
import org.cthul.fixsure.data.Web;
import org.cthul.fixsure.distributions.DistributionRandomizer;
import org.cthul.fixsure.fluents.FlDataSource;
import org.cthul.fixsure.fluents.FlGenerator;
import org.cthul.fixsure.fluents.FlSequence;
import org.cthul.fixsure.fluents.FlTemplate;
import org.cthul.fixsure.generators.AnonymousGenerator;
import org.cthul.fixsure.generators.AnonymousTemplate;
import org.cthul.fixsure.generators.primitives.RandomIntegersGenerator;

public class UrlGenerator
extends AnonymousGenerator<String> {
    private static final Template TEMPLATE = new Template();
    private final Generator<String> protocols;
    private final Generator<Boolean> hasProtocol;
    private final Generator<String> hosts;
    private final Generator<Boolean> hasAuthority;
    private final Generator<Boolean> isAbsolute;
    private final Generator<Integer> ports;
    private final Generator<Boolean> hasPort;
    private final Generator<String> paths;
    private final Generator<Boolean> hasPath;

    public static Template urls() {
        return TEMPLATE;
    }

    public UrlGenerator(DataSource<String> protocols, DataSource<Boolean> hasProtocol, DataSource<String> hosts, DataSource<Boolean> hasAuthority, DataSource<Boolean> isAbsolute, DataSource<Integer> ports, DataSource<Boolean> hasPort, DataSource<String> paths, DataSource<Boolean> hasPath) {
        if (hasProtocol != null) {
            Objects.requireNonNull(protocols, "protocol generator");
        }
        if (hasAuthority != null) {
            Objects.requireNonNull(hosts, "host generator");
        }
        Objects.requireNonNull(isAbsolute, "absolute toggle");
        if (hasPort != null) {
            Objects.requireNonNull(ports, "port generator");
        }
        if (hasPath != null) {
            Objects.requireNonNull(paths);
        }
        this.protocols = UrlGenerator.toGenerator(protocols);
        this.hasProtocol = UrlGenerator.toGenerator(hasProtocol);
        this.hosts = UrlGenerator.toGenerator(hosts);
        this.hasAuthority = UrlGenerator.toGenerator(hasAuthority);
        this.isAbsolute = UrlGenerator.toGenerator(isAbsolute);
        this.ports = UrlGenerator.toGenerator(ports);
        this.hasPort = UrlGenerator.toGenerator(hasPort);
        this.paths = UrlGenerator.toGenerator(paths);
        this.hasPath = UrlGenerator.toGenerator(hasPath);
    }

    private static <T> Generator<T> toGenerator(DataSource<T> dataSource) {
        return dataSource == null ? null : dataSource.toGenerator();
    }

    private boolean nextHasAuthority() {
        return this.hosts != null && (this.hasAuthority == null || (Boolean)this.hasAuthority.next() != false);
    }

    private boolean nextIsAbsolute() {
        return (Boolean)this.isAbsolute.next();
    }

    private boolean nextHasProtocol() {
        return this.protocols != null && (this.hasProtocol == null || (Boolean)this.hasProtocol.next() != false);
    }

    private boolean nextHasPort() {
        return this.ports != null && (this.hasPort == null || (Boolean)this.hasPort.next() != false);
    }

    private boolean nextHasPath() {
        return this.paths != null && (this.hasPath == null || (Boolean)this.hasPath.next() != false);
    }

    public String next() {
        StringBuilder sb = new StringBuilder();
        if (this.nextIsAbsolute()) {
            if (this.nextHasAuthority()) {
                if (this.nextHasProtocol()) {
                    sb.append((String)this.protocols.next()).append(":");
                }
                sb.append("//").append((String)this.hosts.next());
                if (this.nextHasPort()) {
                    sb.append(":").append(this.ports.next());
                }
            }
            sb.append("/");
        }
        if (this.nextHasPath()) {
            sb.append((String)this.paths.next());
        }
        return sb.toString();
    }

    public static class Template
    extends AnonymousTemplate<String> {
        private static final DataSource<Boolean> ALWAYS_FALSE = Fixsure.constant((Object)false);
        private static final DataSource<Boolean> ALWAYS_TRUE = Fixsure.constant((Object)true);
        private static final LongFunction<DataSource<Boolean>> OFF = seed -> ALWAYS_FALSE;
        private static final LongFunction<DataSource<Boolean>> ON = seed -> ALWAYS_TRUE;
        private static final FlSequence<String> DEFAULT_PROTOCOLS_SRC = Fixsure.sequence((Object[])new String[]{"http", "https"});
        private static final LongFunction<DataSource<String>> DEFAULT_PROTOCOLS = arg_0 -> DEFAULT_PROTOCOLS_SRC.random(arg_0);
        private static final LongFunction<DataSource<String>> DEFAULT_HOSTS = arg_0 -> Web.domains().random(arg_0);
        private static final LongFunction<DataSource<Integer>> DEFAULT_PORTS = arg_0 -> ((RandomIntegersGenerator.Template)Fixsure.integers((int)1024, (int)65536)).random(arg_0);
        private static final FlSequence<String> DEFAULT_SEGMENTS_SRC = Fixsure.integers((int)0, (int)65536).ordered().map(Object::toString).alternateWith(new Sequence[]{English.vegetables().repeat().map(String::toLowerCase), Fixsure.integers((int)0, (int)65536).ordered().map(Integer::toHexString)});
        private static final FlSequence<String> DEFAULT_SEGMENT_EXT_SRC = Fixsure.sequence((Object[])new String[]{"", "/", ".html", ".html", ".png", ".mp4"});
        private static final LongFunction<DataSource<String>> DEFAULT_SEGMENTS = arg_0 -> DEFAULT_SEGMENTS_SRC.random(arg_0);
        private static final LongFunction<DataSource<String>> DEFAULT_SEGMENT_EXT = arg_0 -> DEFAULT_SEGMENT_EXT_SRC.random(arg_0);
        private static final LongFunction<DataSource<Integer>> DEFAULT_PATH_LENGTH = arg_0 -> ((RandomIntegersGenerator.Template)Fixsure.integers((int)1, (int)5)).random(arg_0);
        private static final long DEFAULT_SEED = DistributionRandomizer.toSeed(UrlGenerator.class);
        private static final long SEED_PROTOCOLS = DistributionRandomizer.toSeed((String)"URL", (String)"protocols");
        private static final long SEED_HOSTS = DistributionRandomizer.toSeed((String)"URL", (String)"hosts");
        private static final long SEED_PORTS = DistributionRandomizer.toSeed((String)"URL", (String)"ports");
        private static final long SEED_PATHS = DistributionRandomizer.toSeed((String)"URL", (String)"paths");
        private static final long SEED_SEGMENTS = DistributionRandomizer.toSeed((String)"URL", (String)"segments");
        private static final long SEED_SEGMENT_EXTS = DistributionRandomizer.toSeed((String)"URL", (String)"segmentExts");
        private static final long SEED_TOGGLE = DistributionRandomizer.toSeed((String)"URL", (String)"toggle");
        private final LongFunction<DataSource<String>> protocols;
        private final LongFunction<DataSource<Boolean>> hasProtocol;
        private final LongFunction<DataSource<String>> hosts;
        private final LongFunction<DataSource<Boolean>> hasAuthority;
        private final LongFunction<DataSource<Boolean>> isAbsolute;
        private final LongFunction<DataSource<Integer>> ports;
        private final LongFunction<DataSource<Boolean>> hasPort;
        private final LongFunction<DataSource<String>> paths;
        private final LongFunction<DataSource<String>> segments;
        private final LongFunction<DataSource<String>> segmentExtensions;
        private final LongFunction<DataSource<Integer>> segmentCount;
        private final LongFunction<DataSource<Boolean>> hasPath;
        private final long seed;

        public Template() {
            this.protocols = DEFAULT_PROTOCOLS;
            this.hasProtocol = ON;
            this.hosts = DEFAULT_HOSTS;
            this.hasAuthority = ON;
            this.isAbsolute = ON;
            this.ports = DEFAULT_PORTS;
            this.hasPort = ON;
            this.paths = null;
            this.segments = DEFAULT_SEGMENTS;
            this.segmentExtensions = DEFAULT_SEGMENT_EXT;
            this.segmentCount = DEFAULT_PATH_LENGTH;
            this.hasPath = ON;
            this.seed = DEFAULT_SEED;
        }

        public Template(LongFunction<DataSource<String>> protocols, LongFunction<DataSource<Boolean>> hasProtocol, LongFunction<DataSource<String>> hosts, LongFunction<DataSource<Boolean>> hasAuthority, LongFunction<DataSource<Boolean>> isAbsolute, LongFunction<DataSource<Integer>> ports, LongFunction<DataSource<Boolean>> hasPort, LongFunction<DataSource<String>> paths, LongFunction<DataSource<String>> segments, LongFunction<DataSource<String>> segmentExtensions, LongFunction<DataSource<Integer>> segmentCount, LongFunction<DataSource<Boolean>> hasPath, long seed) {
            this.protocols = protocols;
            this.hasProtocol = hasProtocol;
            this.hosts = hosts;
            this.hasAuthority = hasAuthority;
            this.isAbsolute = isAbsolute;
            this.ports = ports;
            this.hasPort = hasPort;
            this.paths = paths;
            this.segments = segments;
            this.segmentExtensions = segmentExtensions;
            this.segmentCount = segmentCount;
            this.hasPath = hasPath;
            this.seed = seed;
        }

        public Template protocols(LongFunction<DataSource<String>> protocols) {
            LongFunction<DataSource<Boolean>> newHasProtocol = this.hasProtocol;
            if (newHasProtocol == OFF) {
                newHasProtocol = ON;
            }
            return new Template(protocols, newHasProtocol, this.hosts, this.hasAuthority, this.isAbsolute, this.ports, this.hasPort, this.paths, this.segments, this.segmentExtensions, this.segmentCount, this.hasPath, this.seed);
        }

        public Template protocols(DataSource<String> protocols) {
            return this.protocols((long s) -> protocols);
        }

        public Template protocols(String ... protocols) {
            return this.protocols((long s) -> Fixsure.sequence((Object[])protocols).random(s));
        }

        public Template protocol(String protocol) {
            return this.protocols((long s) -> Fixsure.constant((Object)protocol));
        }

        public Template hasProtocol(LongFunction<DataSource<Boolean>> hasProtocol) {
            return new Template(this.protocols, hasProtocol, this.hosts, this.hasAuthority, this.isAbsolute, this.ports, this.hasPort, this.paths, this.segments, this.segmentExtensions, this.segmentCount, this.hasPath, this.seed);
        }

        public Template hasProtocol(DataSource<Boolean> hasProtocol) {
            return this.hasProtocol((long s) -> hasProtocol);
        }

        public Template hasProtocol(double protocolRatio) {
            return this.hasProtocol(this.ratioToToggle(protocolRatio));
        }

        public Template hasProtocol(boolean hasProtocol) {
            return this.hasProtocol(hasProtocol ? ON : OFF);
        }

        public Template hosts(LongFunction<DataSource<String>> hosts) {
            LongFunction<DataSource<Boolean>> newHasAuthority;
            LongFunction<DataSource<Boolean>> newIsAbsolute = this.isAbsolute;
            if (newIsAbsolute == OFF) {
                newIsAbsolute = ON;
            }
            if ((newHasAuthority = this.hasAuthority) == OFF) {
                newHasAuthority = ON;
            }
            return new Template(this.protocols, this.hasProtocol, hosts, newHasAuthority, newIsAbsolute, this.ports, this.hasPort, this.paths, this.segments, this.segmentExtensions, this.segmentCount, this.hasPath, this.seed);
        }

        public Template hosts(DataSource<String> hosts) {
            return this.hosts((long s) -> hosts);
        }

        public Template hosts(String ... hosts) {
            return this.hosts((long s) -> Fixsure.sequence((Object[])hosts).random(s));
        }

        public Template host(String host) {
            return this.hosts((long s) -> Fixsure.constant((Object)host));
        }

        public Template hasAuthority(LongFunction<DataSource<Boolean>> hasAuthority) {
            LongFunction<DataSource<Boolean>> newIsAbsolute = this.isAbsolute;
            if (newIsAbsolute == OFF) {
                newIsAbsolute = ON;
            }
            return new Template(this.protocols, this.hasProtocol, this.hosts, hasAuthority, newIsAbsolute, this.ports, this.hasPort, this.paths, this.segments, this.segmentExtensions, this.segmentCount, this.hasPath, this.seed);
        }

        public Template hasAuthority(DataSource<Boolean> hasAuthority) {
            return this.hasAuthority((long s) -> hasAuthority);
        }

        public Template hasAuthority(double hostRatio) {
            return this.hasAuthority(this.ratioToToggle(hostRatio));
        }

        public Template hasAuthority(boolean hasAuthority) {
            return this.hasAuthority(hasAuthority ? ON : OFF);
        }

        public Template isAbsolute(LongFunction<DataSource<Boolean>> isAbsolute) {
            return new Template(this.protocols, this.hasProtocol, this.hosts, this.hasAuthority, isAbsolute, this.ports, this.hasPort, this.paths, this.segments, this.segmentExtensions, this.segmentCount, this.hasPath, this.seed);
        }

        public Template isAbsolute(DataSource<Boolean> isAbsolute) {
            return this.isAbsolute((long s) -> isAbsolute);
        }

        public Template isAbsolute(double hostRatio) {
            return this.isAbsolute(this.ratioToToggle(hostRatio));
        }

        public Template isAbsolute(boolean isAbsolute) {
            return this.isAbsolute(isAbsolute ? ON : OFF);
        }

        public Template ports(LongFunction<DataSource<Integer>> ports) {
            LongFunction<DataSource<Boolean>> newHasPort = this.hasPort;
            if (newHasPort == OFF) {
                newHasPort = ON;
            }
            return new Template(this.protocols, this.hasProtocol, this.hosts, this.hasAuthority, this.isAbsolute, ports, newHasPort, this.paths, this.segments, this.segmentExtensions, this.segmentCount, this.hasPath, this.seed);
        }

        public Template ports(DataSource<Integer> ports) {
            return this.ports((long s) -> ports);
        }

        public Template ports(Integer ... ports) {
            return this.ports((long s) -> Fixsure.sequence((Object[])ports).random(s));
        }

        public Template port(int port) {
            return this.ports((long s) -> Fixsure.constant((Object)port));
        }

        public Template hasPort(LongFunction<DataSource<Boolean>> hasPort) {
            return new Template(this.protocols, this.hasProtocol, this.hosts, this.hasAuthority, this.isAbsolute, this.ports, hasPort, this.paths, this.segments, this.segmentExtensions, this.segmentCount, this.hasPath, this.seed);
        }

        public Template hasPort(DataSource<Boolean> hasPort) {
            return this.hasPort((long s) -> hasPort);
        }

        public Template hasPort(double portRatio) {
            return this.hasPort(this.ratioToToggle(portRatio));
        }

        public Template hasPort(boolean hasPort) {
            return this.hasPort(hasPort ? ON : OFF);
        }

        public Template paths(LongFunction<DataSource<String>> paths) {
            LongFunction<DataSource<Boolean>> newHasPath = this.hasPath;
            if (newHasPath == OFF) {
                newHasPath = ON;
            }
            return new Template(this.protocols, this.hasPath, this.hosts, this.hasAuthority, this.isAbsolute, this.ports, this.hasPort, paths, this.segments, this.segmentExtensions, this.segmentCount, newHasPath, this.seed);
        }

        public Template paths(DataSource<String> paths) {
            return this.paths((long s) -> paths);
        }

        public Template paths(String ... paths) {
            return this.paths((long s) -> Fixsure.sequence((Object[])paths).random(s));
        }

        public Template path(String path) {
            return this.paths((long s) -> Fixsure.constant((Object)path));
        }

        public Template hasPath(LongFunction<DataSource<Boolean>> hasPath) {
            return new Template(this.protocols, this.hasProtocol, this.hosts, this.hasAuthority, this.isAbsolute, this.ports, this.hasPort, this.paths, this.segments, this.segmentExtensions, this.segmentCount, hasPath, this.seed);
        }

        public Template hasPath(DataSource<Boolean> hasPath) {
            return this.hasPath((long s) -> hasPath);
        }

        public Template hasPath(double pathRatio) {
            return this.hasPath(this.ratioToToggle(pathRatio));
        }

        public Template hasPath(boolean hasPath) {
            return this.hasPath(hasPath ? ON : OFF);
        }

        public Template segments(LongFunction<DataSource<String>> segments) {
            LongFunction<DataSource<Boolean>> newHasPath = this.hasPath;
            if (newHasPath == OFF) {
                newHasPath = ON;
            }
            return new Template(this.protocols, this.hasProtocol, this.hosts, this.hasAuthority, this.isAbsolute, this.ports, this.hasPort, null, segments, this.segmentExtensions, this.segmentCount, newHasPath, this.seed);
        }

        public Template segments(DataSource<String> segments) {
            return this.segments((long s) -> segments);
        }

        public Template segments(String ... segments) {
            return this.segments((long s) -> Fixsure.sequence((Object[])segments).random(s));
        }

        public Template segmentCount(LongFunction<DataSource<Integer>> segmentCount) {
            LongFunction<DataSource<Boolean>> newHasPath = this.hasPath;
            if (newHasPath == OFF) {
                newHasPath = ON;
            }
            return new Template(this.protocols, this.hasProtocol, this.hosts, this.hasAuthority, this.isAbsolute, this.ports, this.hasPort, null, this.segments, this.segmentExtensions, segmentCount, newHasPath, this.seed);
        }

        public Template segmentCount(DataSource<Integer> segmentCount) {
            return this.segmentCount((long s) -> segmentCount);
        }

        public Template segmentCount(Integer ... segmentCount) {
            return this.segmentCount((long s) -> Fixsure.sequence((Object[])segmentCount).random(s));
        }

        public Template segmentCount(int segmentCount) {
            return this.segmentCount((long s) -> Fixsure.constant((Object)segmentCount));
        }

        public Template segmentExts(LongFunction<DataSource<String>> segmentExts) {
            LongFunction<DataSource<Boolean>> newHasPath = this.hasPath;
            if (newHasPath == OFF) {
                newHasPath = ON;
            }
            return new Template(this.protocols, this.hasProtocol, this.hosts, this.hasAuthority, this.isAbsolute, this.ports, this.hasPort, null, this.segments, segmentExts, this.segmentCount, newHasPath, this.seed);
        }

        public Template segmentExts(DataSource<String> segmentExts) {
            return this.segmentExts((long s) -> segmentExts);
        }

        public Template segmentExts(String ... segmentExts) {
            return this.segmentExts((long s) -> Fixsure.sequence((Object[])segmentExts).random(s));
        }

        public Template seed(long seed) {
            return new Template(this.protocols, this.hasProtocol, this.hosts, this.hasAuthority, this.isAbsolute, this.ports, this.hasPort, this.paths, this.segments, this.segmentExtensions, this.segmentCount, this.hasPath, seed);
        }

        public Template segmentExt(String segmentExt) {
            return this.segmentExts((long s) -> Fixsure.constant((Object)segmentExt));
        }

        private LongFunction<DataSource<Boolean>> ratioToToggle(double ratio) {
            if (ratio <= 0.0) {
                return OFF;
            }
            if (ratio >= 1.0) {
                return ON;
            }
            return s -> Fixsure.booleans((double)ratio, (Distribution)Fixsure.uniform(), (long)s);
        }

        public FlGenerator<String> newGenerator() {
            DataSource<Boolean> hasPathSrc;
            Object pathsSrc;
            DataSource<Boolean> hasPortSrc;
            DataSource<Integer> portsSrc;
            DataSource<Boolean> hasAuthoritySrc;
            DataSource<String> hostsSrc;
            DataSource<Boolean> hasProtocolSrc;
            DataSource<String> protocolsSrc;
            DataSource<Boolean> isAbsoluteSrc = this.isAbsolute.apply(this.seed ^ SEED_TOGGLE);
            if (this.hasAuthority == OFF || this.isAbsolute == OFF) {
                protocolsSrc = null;
                hasProtocolSrc = null;
                hostsSrc = null;
                hasAuthoritySrc = null;
                portsSrc = null;
                hasPortSrc = null;
            } else {
                if (this.hasProtocol == OFF) {
                    protocolsSrc = null;
                    hasProtocolSrc = null;
                } else {
                    protocolsSrc = this.protocols.apply(this.seed ^ SEED_PROTOCOLS);
                    hasProtocolSrc = this.newToggleSrc(this.hasProtocol, SEED_PROTOCOLS);
                }
                hostsSrc = this.hosts.apply(this.seed ^ SEED_HOSTS);
                hasAuthoritySrc = this.newToggleSrc(this.hasAuthority, SEED_HOSTS);
                if (this.hasPort == OFF) {
                    portsSrc = null;
                    hasPortSrc = null;
                } else {
                    portsSrc = this.ports.apply(this.seed ^ SEED_PORTS);
                    hasPortSrc = this.newToggleSrc(this.hasPort, SEED_PORTS);
                }
            }
            if (this.hasPath == OFF) {
                pathsSrc = null;
                hasPathSrc = null;
            } else {
                pathsSrc = this.paths != null ? this.paths.apply(this.seed ^ SEED_PATHS) : this.buildPathsSrc();
                hasPathSrc = this.newToggleSrc(this.hasPath, SEED_PATHS);
            }
            return new UrlGenerator(protocolsSrc, hasProtocolSrc, hostsSrc, hasAuthoritySrc, isAbsoluteSrc, portsSrc, hasPortSrc, (DataSource<String>)pathsSrc, hasPathSrc);
        }

        private DataSource<Boolean> newToggleSrc(LongFunction<DataSource<Boolean>> toggle, long seedFlag) {
            if (toggle == ON) {
                return null;
            }
            return toggle.apply(this.seed ^ seedFlag ^ SEED_TOGGLE);
        }

        private FlDataSource<String> buildPathsSrc() {
            FlDataSource segmentSrc = this.segments.apply(this.seed ^ SEED_SEGMENTS).fluentData();
            DataSource<Integer> lengthSrc = this.segmentCount.apply(this.seed ^ SEED_SEGMENTS ^ SEED_TOGGLE);
            DataSource<String> extSrc = this.segmentExtensions.apply(this.seed ^ SEED_SEGMENT_EXTS);
            return segmentSrc.aggregate(lengthSrc).map(v -> String.join((CharSequence)"/", (Iterable<? extends CharSequence>)v)).map(extSrc, (p, e) -> p + e);
        }

        public FlTemplate<URL> toURLs() {
            return this.toURLs(null);
        }

        public FlTemplate<URL> toURLs(URL context) {
            return this.map(url -> {
                try {
                    return new URL(context, (String)url);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException((String)url, e);
                }
            });
        }

        public FlTemplate<URI> toURIs() {
            return this.map(url -> {
                try {
                    return new URI((String)url);
                }
                catch (URISyntaxException ex) {
                    throw new RuntimeException((String)url, ex);
                }
            });
        }

        public FlTemplate<Path> toPaths() {
            return this.map(url -> {
                try {
                    return Paths.get(new URI((String)url));
                }
                catch (URISyntaxException ex) {
                    throw new RuntimeException((String)url, ex);
                }
            });
        }
    }
}

