/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.fluent.gen;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotatedElement;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMember;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaModel;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaParameterizedType;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.JavaTypeVariable;
import com.thoughtworks.qdox.model.JavaWildcardType;
import com.thoughtworks.qdox.model.impl.AbstractBaseMethod;
import com.thoughtworks.qdox.model.impl.DefaultDocletTag;
import com.thoughtworks.qdox.model.impl.DefaultJavaClass;
import com.thoughtworks.qdox.model.impl.DefaultJavaField;
import com.thoughtworks.qdox.model.impl.DefaultJavaMethod;
import com.thoughtworks.qdox.model.impl.DefaultJavaParameter;
import com.thoughtworks.qdox.model.impl.DefaultJavaParameterizedType;
import com.thoughtworks.qdox.model.impl.DefaultJavaType;
import com.thoughtworks.qdox.model.impl.DefaultJavaTypeVariable;
import com.thoughtworks.qdox.model.impl.DefaultJavaWildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cthul.api4j.Api4JConfiguration;
import org.cthul.api4j.api.Template;
import org.cthul.api4j.api1.Api1;
import org.cthul.api4j.api1.GeneralTools;
import org.cthul.api4j.api1.QdoxTools;
import org.cthul.api4j.gen.GeneratedClass;
import org.cthul.api4j.gen.GeneratedConstructor;
import org.cthul.api4j.gen.GeneratedMethod;
import org.cthul.strings.JavaNames;

public class FluentsGenerator {
    private final List<FluentConfig> fluents;
    private final List<AssertConfig> asserts;
    private Exception suppressed = null;
    private Map<JavaType, FluentConfig> fluentTypeMap = null;
    private JavaClass matcherClass = null;
    private JavaClass adapterClass = null;
    private JavaClass valueClass = null;
    private Template staticCall = null;

    public FluentsGenerator(List<FluentConfig> fluents, List<AssertConfig> asserts) {
        this.fluents = fluents;
        this.asserts = asserts;
    }

    private boolean isMatcherFactory(JavaMethod jm) {
        try {
            JavaClass ret = jm.getReturns();
            return ret.isA(this.matcherClass);
        }
        catch (Exception e) {
            this.suppressed = e;
            return false;
        }
    }

    private boolean isAdapterFactory(JavaMethod jm) {
        try {
            JavaClass ret = jm.getReturns();
            return ret.isA(this.adapterClass);
        }
        catch (Exception e) {
            this.suppressed = e;
            return false;
        }
    }

    private boolean isValueFactory(JavaMethod jm) {
        try {
            JavaClass ret = jm.getReturns();
            return ret.isA(this.valueClass);
        }
        catch (Exception e) {
            this.suppressed = e;
            return false;
        }
    }

    public void generate(Api4JConfiguration cfg, String path) {
        new Api1(cfg.getContext(path)).run(this::generate);
    }

    private void generate(Api1 api) {
        this.matcherClass = QdoxTools.asClass((String)"org.hamcrest.Matcher");
        this.adapterClass = QdoxTools.asClass((String)"org.cthul.matchers.fluent.value.MatchValueAdapter");
        this.valueClass = QdoxTools.asClass((String)"org.cthul.matchers.fluent.value.MatchValue");
        this.staticCall = api.getTemplate("staticCall");
        this.initFluentTypeMap();
        this.fluents.forEach(fc -> this.generateFluent((FluentConfig)fc, api));
        this.asserts.forEach(ac -> this.generateAssert((AssertConfig)ac, api));
    }

    private void initFluentTypeMap() {
        this.fluentTypeMap = new HashMap<JavaType, FluentConfig>();
        this.fluents.forEach(fc -> this.fluentTypeMap.put((JavaType)fc.getValueClass(), (FluentConfig)fc));
    }

    private void generateFluent(FluentConfig fc, Api1 api) {
        if (fc.isImplemented()) {
            return;
        }
        GeneratedClass iBase = fc.getName() == null ? QdoxTools.generatedInterface((Api1)api) : QdoxTools.generatedInterface((Api1)api, (String)fc.getName());
        GeneratedClass iOrChain = QdoxTools.nestedInterface((DefaultJavaClass)iBase, (String)"OrChain");
        GeneratedClass iAndChain = QdoxTools.nestedInterface((DefaultJavaClass)iBase, (String)"AndChain");
        GeneratedClass cStep = QdoxTools.nestedClass((DefaultJavaClass)iBase, (String)"Step");
        GeneratedClass cAssert = QdoxTools.nestedClass((DefaultJavaClass)iBase, (String)"Assert");
        ArrayList<String> typeArguments = new ArrayList<String>();
        ArrayList<String> typeParameters = new ArrayList<String>();
        this.configureTypeParameters(fc, iBase, iOrChain, iAndChain, cStep, cAssert, typeArguments, typeParameters);
        List assertArgs = GeneralTools.parametersToArgs(fc.getExtraParams());
        assertArgs.add("Value");
        String cAssertWithArgs = "Assert" + this.toGenericSig(assertArgs);
        this.configureSuperClasses(iBase, iOrChain, iAndChain, cStep, cAssert, typeArguments, cAssertWithArgs);
        fc.getExtends().forEach(extendz -> this.configureAdditionalSuperClass((String)extendz, iBase, iOrChain, iAndChain));
        this.generateImplementationConstructors(cStep, cAssert);
        fc.getFactories().forEach(factoryConfig -> {
            Renamer renamer = factoryConfig.getRenamer();
            factoryConfig.factoryMethods().forEach(factory -> {
                this.suppressed = null;
                GeneratedMethod flMethod = QdoxTools.method((JavaClass)iBase, (JavaMethod)factory);
                renamer.applyToName(flMethod);
                if (this.isMatcherFactory((JavaMethod)factory)) {
                    this.configureMatcherFluent(flMethod, (JavaMethod)factory, (FactoryConfig)factoryConfig, (List<String>)typeArguments);
                } else if (this.isAdapterFactory((JavaMethod)factory)) {
                    this.configureAdapterFluent(flMethod, (JavaMethod)factory, (FactoryConfig)factoryConfig, (List<String>)typeParameters);
                } else if (this.isValueFactory((JavaMethod)factory)) {
                    iBase.getMethods().remove(flMethod);
                } else {
                    this.invalidFactoryMethod((JavaMethod)factory);
                }
            });
        });
        this.addChainMethods(iBase, iOrChain, typeArguments, "either", "or");
        this.addChainImplementation((JavaClass)iBase, cStep, typeArguments, "TheFluent", "Value", "OrChain", "either");
        this.addChainImplementation((JavaClass)iBase, cAssert, typeArguments, cAssertWithArgs, "Value", "OrChain", "either");
        this.addChainMethods(iBase, iAndChain, typeArguments, "both", "and");
        this.addChainImplementation((JavaClass)iBase, cStep, typeArguments, "TheFluent", "Value", "AndChain", "both");
        this.addChainImplementation((JavaClass)iBase, cAssert, typeArguments, cAssertWithArgs, "Value", "AndChain", "both");
        this.addChainMethods(iBase, iAndChain, typeArguments, "all");
        this.addChainImplementation((JavaClass)iBase, cStep, typeArguments, "TheFluent", "AndChain", "all");
        this.addChainImplementation((JavaClass)iBase, cAssert, typeArguments, cAssertWithArgs, "AndChain", "all");
        HashSet<String> castingMethods = new HashSet<String>();
        for (FluentConfig subFc : this.fluents) {
            if (!subFc.isValueSubclass(fc)) continue;
            String name = "as";
            if (subFc.isImplemented()) {
                String type = subFc.getType();
                if (type.contains("<")) {
                    type = type.substring(0, type.indexOf(60));
                }
                if (type.contains(".")) {
                    type = type.substring(type.lastIndexOf(46) + 1);
                }
                name = name + type;
            } else {
                name = name + subFc.getCastMethodName();
            }
            if (!castingMethods.add(name)) continue;
            String stepType = this.getFluentStepType(subFc, subFc.getType());
            int iGeneric = stepType.indexOf(60);
            String subFcClass = iGeneric < 0 ? stepType : stepType.substring(0, iGeneric);
            GeneratedMethod mCastStep = QdoxTools.method((JavaClass)cStep, (Object[])new Object[]{name});
            mCastStep.getTypeParameters().addAll(subFc.getExtraParams());
            QdoxTools.setReturns((DefaultJavaMethod)mCastStep, (Object)stepType);
            QdoxTools.setModifiers((JavaModel)mCastStep, (String)"public");
            QdoxTools.setBody((AbstractBaseMethod)mCastStep, (Object)("return as(" + subFcClass + ".adapter());"));
            mCastStep.setComment("Converts this fluent into a " + subFcClass);
            mCastStep.getTags().add("return " + JavaNames.under_score((String)subFcClass).replace('_', ' ') + " step");
            String assertType = this.getFluentAssertType(subFc, subFc.getType());
            GeneratedMethod mAssertStep = QdoxTools.method((JavaClass)cAssert, (Object[])new Object[]{name});
            mAssertStep.getTypeParameters().addAll(subFc.getExtraParams());
            QdoxTools.setReturns((DefaultJavaMethod)mAssertStep, (Object)assertType);
            QdoxTools.setModifiers((JavaModel)mAssertStep, (String)"public");
            QdoxTools.setBody((AbstractBaseMethod)mAssertStep, (Object)("return as(" + subFcClass + ".adapter());"));
            mAssertStep.setComment("Converts this fluent into a " + subFcClass);
            mAssertStep.getTags().add("return " + JavaNames.under_score((String)subFcClass).replace('_', ' ') + " fluent");
        }
        DefaultJavaField fXAdapter = QdoxTools.field((JavaClass)cStep, (String)"private static final org.cthul.matchers.fluent.ext.ExtensionFactory X_ADAPTER");
        fXAdapter.setInitializationExpression("org.cthul.matchers.fluent.ext.Extensions.typecastFactory(" + fc.getAdapterTypeName() + ".class, " + "Step::new, Assert::new)");
        GeneratedMethod mAdapter = QdoxTools.method((JavaClass)cStep, (Object[])new Object[]{"adapter"});
        mAdapter.getModifiers().add((Object)"public static");
        mAdapter.getTypeParameters().addAll(fc.getExtraParams());
        mAdapter.getTypeParameters().add("Value extends " + fc.getType());
        mAdapter.getTypeParameters().add("TheFluent");
        mAdapter.setReturns(this.getAdapterType((JavaClass)cStep, (JavaClass)cAssert));
        mAdapter.setSourceCode("return X_ADAPTER;");
    }

    private void configureAdditionalSuperClass(String sup, GeneratedClass iBase, GeneratedClass iOrChain, GeneratedClass iAndChain) {
        if (!(sup = sup.replace("...", "Value, BaseFluent, TheFluent, This")).contains("<")) {
            sup = sup + "<Value, BaseFluent, TheFluent, This>";
        }
        QdoxTools.add((List)iBase.getInterfaces(), (String)sup);
        int iGen = sup.indexOf(60);
        String supName = sup.substring(0, iGen);
        String genSig = sup.substring(iGen).replace("BaseFluent, ", "");
        String supOr = supName + ".OrChain" + genSig;
        QdoxTools.add((List)iOrChain.getInterfaces(), (String)supOr);
        String supAnd = supName + ".AndChain" + genSig;
        QdoxTools.add((List)iAndChain.getInterfaces(), (String)supAnd);
    }

    private void generateImplementationConstructors(GeneratedClass cStep, GeneratedClass cAssert) {
        GeneratedConstructor newStep = QdoxTools.constructor((JavaClass)cStep, (Object[])new Object[]{"public (org.cthul.matchers.fluent.builder.Matchable<? extends Value, TheFluent> matchable)"});
        newStep.setSourceCode("super(matchable);");
        GeneratedConstructor newAssertPublic = QdoxTools.constructor((JavaClass)cAssert);
        QdoxTools.setSignature((AbstractBaseMethod)newAssertPublic, (String)("org.cthul.matchers.fluent.builder.FailureHandler handler, " + QdoxTools.withArgs((JavaClass)this.valueClass, (Object[])new Object[]{"Value"}).getGenericFullyQualifiedName() + " value"));
        newAssertPublic.setSourceCode("super(handler, value);");
        GeneratedConstructor newAssertPrivate = QdoxTools.constructor((JavaClass)cAssert, (Object[])new Object[]{"protected"});
        QdoxTools.setSignature((AbstractBaseMethod)newAssertPrivate, (String)"org.cthul.matchers.fluent.builder.Matchable<? extends Value, ?> value");
        newAssertPrivate.setSourceCode("super(value);");
    }

    private void configureSuperClasses(GeneratedClass iBase, GeneratedClass iOrChain, GeneratedClass iAndChain, GeneratedClass cStep, GeneratedClass cAssert, List<String> typeArguments, String cAssertWithArgs) {
        iBase.getInterfaces().add("org.cthul.matchers.fluent.ext.ExtensibleFluentStep<Value, BaseFluent, TheFluent, This>");
        iOrChain.getInterfaces().add("org.cthul.matchers.fluent.ext.ExtensibleFluentStep.OrChain<Value, TheFluent, This>");
        iOrChain.getInterfaces().add((Object)this.asTheFluent((JavaClass)iBase, typeArguments));
        iAndChain.getInterfaces().add("org.cthul.matchers.fluent.ext.ExtensibleFluentStep.AndChain<Value, TheFluent, This>");
        iAndChain.getInterfaces().add((Object)this.asTheFluent((JavaClass)iBase, typeArguments));
        cStep.getInterfaces().add((Object)this.asStepFluent((JavaClass)iBase, typeArguments));
        cStep.setSuperClass(QdoxTools.withArgs((JavaClass)QdoxTools.asClass((String)"org.cthul.matchers.fluent.builder.FluentStepBuilder"), (Object[])new Object[]{"Value", "TheFluent", "This"}));
        cAssert.getInterfaces().add((Object)this.asTheFluent((JavaClass)iBase, typeArguments, cAssertWithArgs));
        cAssert.setSuperClass(QdoxTools.withArgs((JavaClass)QdoxTools.asClass((String)"org.cthul.matchers.fluent.builder.FluentAssertBuilder"), (Object[])new Object[]{"Value", cAssertWithArgs}));
    }

    private void configureTypeParameters(FluentConfig fc, GeneratedClass iBase, GeneratedClass iOrChain, GeneratedClass iAndChain, GeneratedClass cStep, GeneratedClass cAssert, List<String> typeArguments, List<String> typeParameters) {
        this.configureTypeParameters(fc, iBase, typeArguments, typeParameters);
        this.setChainTypeParamters(iOrChain, typeArguments, typeParameters);
        this.setChainTypeParamters(iAndChain, typeArguments, typeParameters);
        this.setStepTypeParamters(cStep, typeArguments, typeParameters);
        this.setAssertTypeParameters(cAssert, fc);
    }

    private void setAssertTypeParameters(GeneratedClass cAssert, FluentConfig fc) {
        cAssert.getTypeParameters().addAll(fc.getExtraParams());
        cAssert.getTypeParameters().add("Value extends " + fc.getType());
    }

    private void configureTypeParameters(FluentConfig fc, GeneratedClass cg, List<String> typeArguments, List<String> typeParameters) {
        ArrayList<String> afterValue = null;
        Pattern pValue = Pattern.compile("\\bValue\\b");
        for (String extra : fc.getExtraParams()) {
            if (pValue.matcher(extra).find()) {
                afterValue = new ArrayList<String>();
            }
            if (afterValue == null) {
                typeParameters.add(extra);
                continue;
            }
            afterValue.add(extra);
        }
        typeParameters.add(fc.getType() == null ? "Value" : "Value extends " + fc.getType());
        if (afterValue != null) {
            typeParameters.addAll(afterValue);
        }
        typeParameters.add("BaseFluent");
        typeParameters.add("TheFluent extends BaseFluent");
        typeArguments.addAll(GeneralTools.parametersToArgs(typeParameters));
        typeArguments.add("This");
        typeParameters.add("This extends " + cg.getName() + this.toGenericSig(typeArguments));
        cg.getTypeParameters().addAll(typeParameters);
    }

    private String toGenericSig(List<String> params) {
        if (params.isEmpty()) {
            throw new IllegalArgumentException("No generic arguments");
        }
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        params.forEach(s -> sb.append((String)s).append(','));
        sb.setCharAt(sb.length() - 1, '>');
        return sb.toString();
    }

    private void setStepTypeParamters(GeneratedClass cStep, List<String> typeArgs, List<String> typeParams) {
        int i = typeArgs.indexOf("BaseFluent");
        ArrayList<String> a = new ArrayList<String>(typeArgs);
        a.remove(i);
        ArrayList<String> p = new ArrayList<String>(typeParams);
        p.remove(i);
        p.set(i, "TheFluent");
        p.set(p.size() - 1, "This extends " + cStep.getName() + this.toGenericSig(a));
        cStep.getTypeParameters().addAll(p);
    }

    private void setChainTypeParamters(GeneratedClass cChain, List<String> typeArgs, List<String> typeParams) {
        this.setStepTypeParamters(cChain, typeArgs, typeParams);
    }

    private JavaClass asTheFluent(JavaClass clazz, List<String> typeArgs) {
        return this.asTheFluent(clazz, typeArgs, "This");
    }

    private JavaClass asTheFluent(JavaClass clazz, List<String> typeArgs, String thisArg) {
        int i = typeArgs.indexOf("BaseFluent");
        ArrayList<String> a = new ArrayList<String>(typeArgs);
        a.set(i, "org.cthul.matchers.fluent.Fluent<Value>");
        a.set(i + 1, thisArg);
        a.set(i + 2, thisArg);
        return (JavaClass)QdoxTools.withArgs((JavaClass)clazz, a);
    }

    private JavaClass asStepFluent(JavaClass clazz, List<String> typeArgs) {
        int i = typeArgs.indexOf("BaseFluent");
        ArrayList<String> a = new ArrayList<String>(typeArgs);
        a.set(i, "TheFluent");
        a.set(i + 1, "TheFluent");
        return (JavaClass)QdoxTools.withArgs((JavaClass)clazz, a);
    }

    private JavaClass asChainFluent(JavaClass clazz, List<String> typeArgs, String theFluentArg) {
        int i = typeArgs.indexOf("BaseFluent");
        ArrayList<String> a = new ArrayList<String>(typeArgs);
        a.remove(i);
        a.set(i, theFluentArg);
        a.set(a.size() - 1, "?");
        return (JavaClass)QdoxTools.withArgs((JavaClass)clazz, a);
    }

    private JavaClass asChainTerminal(JavaClass clazz, List<String> typeArgs) {
        int i = typeArgs.indexOf("BaseFluent");
        ArrayList<String> a = new ArrayList<String>(typeArgs);
        a.set(i, "TheFluent");
        a.set(i + 1, "TheFluent");
        a.set(a.size() - 1, "?");
        return (JavaClass)QdoxTools.withArgs((JavaClass)clazz, a);
    }

    private void mapTypeParameters(FactoryConfig fac, GeneratedMethod flMethod, List<String> typeParameters) {
        this.fixTypeParameters(flMethod, typeParameters, fac.getTypeParameterMapping((JavaMethod)flMethod));
    }

    private void fixTypeParameters(GeneratedMethod flMethod, List<String> typeParameters, Map<String, String> map) {
        Object tParams = flMethod.getTypeParameters();
        if ((tParams = this.replaceTypeParameterList((List)tParams, map)) == null) {
            this.removeParameters((List<JavaTypeVariable<JavaMethod>>)flMethod.getTypeParameters(), typeParameters);
        } else {
            this.removeParameters((List<JavaTypeVariable<JavaMethod>>)tParams, typeParameters);
            flMethod.getTypeParameters().clear();
            HashSet<String> paramNames = new HashSet<String>();
            Iterator iterator = tParams.iterator();
            while (iterator.hasNext()) {
                JavaTypeVariable v = (JavaTypeVariable)iterator.next();
                if (!paramNames.add(v.getName())) continue;
                flMethod.getTypeParameters().add((Object)v);
            }
            for (int i = 0; i < flMethod.getParameters().size(); ++i) {
                JavaParameter p = (JavaParameter)flMethod.getParameters().get(i);
                JavaClass newType = this.replaceTypeParameter(p.getType(), map);
                if (newType == null) continue;
                p = new DefaultJavaParameter(newType, p.getName(), p.isVarArgs());
                flMethod.getParameters().set(i, p);
            }
        }
        for (DocletTag tag : flMethod.getTagsByName("param")) {
            String paramName;
            String mappedName;
            String tagValue = tag.getValue();
            if (tagValue == null || tagValue.isEmpty()) continue;
            int iOpen = tagValue.indexOf(60);
            int iClose = tagValue.indexOf(62);
            if (iOpen < 0 || iClose < 0 || iClose < iOpen || (mappedName = map.get(paramName = tagValue.substring(iOpen + 1, iClose))) == null) continue;
            if (typeParameters.contains(mappedName)) {
                flMethod.getTags().remove((Object)tag);
                continue;
            }
            tagValue = tagValue.substring(0, iOpen + 1) + mappedName + tagValue.substring(iClose);
            int tagIndex = flMethod.getTags().indexOf((Object)tag);
            tag = new DefaultDocletTag("param", tagValue);
            flMethod.getTags().set(tagIndex, (Object)tag);
        }
    }

    private void removeParameters(List<JavaTypeVariable<JavaMethod>> params, List<String> exclude) {
        params.removeIf(p -> exclude.stream().anyMatch(c -> c.equals(p.getName()) || c.startsWith(p.getName() + " ")));
    }

    private JavaClass replaceTypeParameter(JavaType type, Map<String, String> map) {
        JavaTypeVariable jtv;
        List types;
        final String replacement = map.get(type.getCanonicalName());
        if (type instanceof JavaWildcardType) {
            String n;
            String n2 = n = type.getGenericFullyQualifiedName();
            for (Map.Entry<String, String> e : map.entrySet()) {
                n2 = n.replaceAll("\\b" + e.getKey() + "\\b", e.getValue());
            }
            if (!n.equals(n2)) {
                DefaultJavaWildcardType.BoundType bt;
                int iExt = n2.indexOf(" extends ");
                if (iExt < 0) {
                    bt = DefaultJavaWildcardType.BoundType.SUPER;
                    iExt = n2.indexOf(" super ") + " super ".length();
                } else {
                    bt = DefaultJavaWildcardType.BoundType.EXTENDS;
                    iExt += " extends ".length();
                }
                type = QdoxTools.asClass((String)n2.substring(iExt));
                DefaultJavaWildcardType fixed = new DefaultJavaWildcardType(type, bt);
                return fixed;
            }
        }
        if (type instanceof JavaTypeVariable && ((types = this.replaceTypeParameterList((jtv = (JavaTypeVariable)type).getBounds(), map)) != null || replacement != null)) {
            DefaultJavaTypeVariable fixed = new DefaultJavaTypeVariable(replacement != null ? replacement : jtv.getName(), jtv.getGenericDeclaration());
            fixed.setBounds(types != null ? types : jtv.getBounds());
            return fixed;
        }
        if (type instanceof JavaParameterizedType) {
            final JavaParameterizedType jpt = (JavaParameterizedType)type;
            int dim = ((DefaultJavaType)type).getDimensions();
            List types2 = jpt.getActualTypeArguments();
            if ((types2 = this.replaceTypeParameterList(types2, map)) != null || replacement != null) {
                DefaultJavaParameterizedType fixed = new DefaultJavaParameterizedType(replacement != null ? replacement : jpt.getFullyQualifiedName(), dim){

                    public String getCanonicalName() {
                        try {
                            return super.getCanonicalName();
                        }
                        catch (Exception e) {
                            return replacement != null ? replacement : jpt.getFullyQualifiedName();
                        }
                    }
                };
                fixed.setActualArgumentTypes(types2 != null ? types2 : jpt.getActualTypeArguments());
                return fixed;
            }
        }
        if (replacement != null) {
            return QdoxTools.asClass((String)replacement);
        }
        return null;
    }

    private <JT extends JavaType> List<JT> replaceTypeParameterList(List<JT> classes, Map<String, String> map) {
        if (classes == null) {
            return null;
        }
        boolean original = true;
        for (int i = 0; i < classes.size(); ++i) {
            JavaClass t = this.replaceTypeParameter((JavaType)classes.get(i), map);
            if (t == null) continue;
            if (original) {
                classes = new ArrayList<JT>(classes);
            }
            original = false;
            classes.set(i, t);
        }
        if (original) {
            return null;
        }
        return classes;
    }

    private void configureMatcherFluent(GeneratedMethod flMethod, JavaMethod factory, FactoryConfig factoryConfig, List<String> typeArguments) {
        QdoxTools.setReturns((DefaultJavaMethod)flMethod, (Object)"TheFluent");
        QdoxTools.setModifiers((JavaModel)flMethod, (String)"default");
        QdoxTools.setBody((AbstractBaseMethod)flMethod, (String)"return __(%s);", (Object[])new Object[]{this.staticCall.generate("method", (Object)factory)});
        flMethod.getTags().removeAll("return");
        flMethod.getTags().add("return fluent");
        this.mapTypeParameters(factoryConfig, flMethod, typeArguments);
    }

    protected void configureAdapterFluent(GeneratedMethod flMethod, JavaMethod factory, FactoryConfig factoryConfig, List<String> typeParameters) {
        String stepType;
        int iGeneric;
        JavaType adaptedType = QdoxTools.resolveReturnTypeArgument((JavaMethod)factory, (JavaClass)this.adapterClass, (int)1);
        Map<String, String> typeParamMap = factoryConfig.getTypeParameterMapping((JavaMethod)flMethod);
        if (adaptedType.getFullyQualifiedName().contains(" extends") && factoryConfig.getTypeParameterMap().isEmpty()) {
            String[] parts = adaptedType.getFullyQualifiedName().split(" extends ", 2);
            typeParamMap = new HashMap<String, String>(typeParamMap);
            typeParamMap.put(parts[0], parts[0]);
        }
        String stepClass = (iGeneric = (stepType = this.getFluentStepType(adaptedType)).indexOf(60)) < 0 ? stepType : stepType.substring(0, iGeneric);
        QdoxTools.setReturns((DefaultJavaMethod)flMethod, (Object)stepType);
        QdoxTools.setModifiers((JavaModel)flMethod, (String)"default");
        QdoxTools.setBody((AbstractBaseMethod)flMethod, (String)"return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(%s, %s.Step.adapter()));", (Object[])new Object[]{this.staticCall.generate("method", (Object)factory), stepClass});
        flMethod.getTags().removeAll("return");
        flMethod.getTags().add("return " + JavaNames.under_score((String)stepClass).replace('_', ' ') + " step");
        this.fixTypeParameters(flMethod, typeParameters, typeParamMap);
    }

    protected void invalidFactoryMethod(JavaMethod factory) throws RuntimeException {
        String methodName;
        try {
            methodName = factory.toString();
        }
        catch (Exception e) {
            try {
                methodName = factory.getCallSignature();
            }
            catch (Exception e2) {
                methodName = factory.getName();
            }
        }
        String msg = "Can't create fluent for\n    " + methodName;
        throw new RuntimeException(msg, this.suppressed);
    }

    private void addChainMethods(GeneratedClass iBase, GeneratedClass iChain, List<String> typeArgs, String name) {
        this.addChainMethods(iBase, iChain, typeArgs, name, null, false);
    }

    private void addChainMethods(GeneratedClass iBase, GeneratedClass iChain, List<String> typeArgs, String name, String terminal) {
        this.addChainMethods(iBase, iChain, typeArgs, name, terminal, true);
    }

    private void addChainMethods(GeneratedClass iBase, GeneratedClass iChain, List<String> typeArgs, String name, String terminal, boolean matcherMethod) {
        JavaClass chainClass = this.asChainFluent((JavaClass)iChain, typeArgs, "TheFluent");
        JavaClass chainTerminal = this.asChainTerminal((JavaClass)iBase, typeArgs);
        GeneratedMethod gm = QdoxTools.method((JavaClass)iBase, (Object[])new Object[]{name});
        gm.getAnnotations().add("Override");
        gm.setReturns(chainClass);
        if (matcherMethod) {
            gm = QdoxTools.method((JavaClass)iBase, (Object[])new Object[]{name});
            gm.getAnnotations().add("Override");
            gm.setReturns(chainClass);
            QdoxTools.setSignature((AbstractBaseMethod)gm, (String)"org.hamcrest.Matcher<? super Value> matcher");
        }
        if (terminal != null) {
            gm = QdoxTools.method((JavaClass)iChain, (Object[])new Object[]{terminal});
            gm.getAnnotations().add("Override");
            gm.setReturns(chainTerminal);
            gm = QdoxTools.method((JavaClass)iChain, (Object[])new Object[]{terminal});
            gm.getAnnotations().add("Override");
            QdoxTools.setReturns((DefaultJavaMethod)gm, (Object)"TheFluent");
            QdoxTools.setSignature((AbstractBaseMethod)gm, (String)"org.hamcrest.Matcher<? super Value> matcher");
        }
    }

    private void addChainImplementation(JavaClass iBase, GeneratedClass cStep, List<String> typeArgs, String theFluentArg, String valueType, String chainType, String name) {
        this.addChainImplementation(iBase, cStep, typeArgs, theFluentArg, chainType, name, valueType, true);
    }

    private void addChainImplementation(JavaClass iBase, GeneratedClass cImpl, List<String> typeArgs, String theFluentArg, String chainType, String name) {
        this.addChainImplementation(iBase, cImpl, typeArgs, theFluentArg, chainType, name, null, false);
    }

    private void addChainImplementation(JavaClass iBase, GeneratedClass cImpl, List<String> typeArgs, String theFluentArg, String chainType, String name, String valueType, boolean matcherMethod) {
        String baseName = iBase.getFullyQualifiedName();
        chainType = (baseName.contains("<") ? baseName.substring(0, baseName.indexOf(60)) : baseName) + "." + chainType;
        JavaClass iChain = QdoxTools.asClass((String)chainType);
        JavaClass chainClass = this.asChainFluent(iChain, typeArgs, theFluentArg);
        GeneratedMethod gm = QdoxTools.method((JavaClass)cImpl, (Object[])new Object[]{name});
        gm.getAnnotations().add("Override");
        gm.getModifiers().add((Object)"public");
        gm.setReturns(chainClass);
        gm.setSourceCode("return _" + name + "(" + chainType + ".class, Step.adapter());");
        if (matcherMethod) {
            gm = QdoxTools.method((JavaClass)cImpl, (Object[])new Object[]{name});
            gm.getAnnotations().add("Override");
            gm.getModifiers().add((Object)"public");
            gm.setReturns(chainClass);
            gm.setSourceCode("return " + name + "().__(matcher);");
            QdoxTools.setSignature((AbstractBaseMethod)gm, (String)("org.hamcrest.Matcher<? super " + valueType + "> matcher"));
        }
    }

    private JavaClass getAdapterType(FluentConfig fc) {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(GeneralTools.parametersToArgs(fc.getExtraParams()));
        args.add("Value");
        ArrayList<String> stepArgs = new ArrayList<String>(args);
        stepArgs.addAll(Arrays.asList("TheFluent", "?"));
        JavaClass cStep = (JavaClass)QdoxTools.withArgs((JavaClass)QdoxTools.asClass((String)(fc.getName() + ".Step")), stepArgs);
        JavaClass cAssert = (JavaClass)QdoxTools.withArgs((JavaClass)QdoxTools.asClass((String)(fc.getName() + ".Assert")), args);
        return this.getAdapterType(cStep, cAssert);
    }

    private JavaClass getAdapterType(JavaClass cStep, JavaClass cFluent) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("java.lang.Object");
        ArrayList<String> fluentArgs = new ArrayList<String>();
        for (JavaTypeVariable v : cFluent.getTypeParameters()) {
            String n = GeneralTools.parameterToArg((String)v.getName());
            fluentArgs.add(n);
        }
        args.add(QdoxTools.withArgs((JavaClass)cFluent, fluentArgs).getGenericFullyQualifiedName());
        args.add("TheFluent");
        ArrayList<String> stepArgs = new ArrayList<String>();
        for (JavaTypeVariable v : cStep.getTypeParameters()) {
            String n = GeneralTools.parameterToArg((String)v.getName());
            if (n.equals("This")) {
                n = "?";
            }
            stepArgs.add(n);
        }
        args.add(QdoxTools.withArgs((JavaClass)cStep, stepArgs).getGenericFullyQualifiedName());
        return (JavaClass)QdoxTools.withArgs((JavaClass)QdoxTools.asClass((String)"org.cthul.matchers.fluent.ext.ExtensionFactory"), args);
    }

    private String getFluentStepType(JavaType valueType) {
        FluentConfig stepConfig;
        String typeName;
        String typeArg = typeName = valueType.getGenericFullyQualifiedName();
        if (typeName.contains(" extends ")) {
            String[] parts = typeName.split(" extends ", 2);
            typeArg = parts[0];
        }
        if ((stepConfig = this.findConfigFor((JavaClass)valueType)) == null) {
            stepConfig = this.findConfigFor(QdoxTools.asClass((String)"java.lang.Object"));
        }
        return this.getFluentStepType(stepConfig, typeArg);
    }

    private String getFluentStepType(FluentConfig stepConfig, String typeArg) {
        return this.getFluentStepType(stepConfig, ".Step", typeArg, "TheFluent,?");
    }

    private String getFluentAssertType(FluentConfig stepConfig, String typeArg) {
        return this.getFluentStepType(stepConfig, ".Assert", typeArg, "");
    }

    private String getFluentStepType(FluentConfig stepConfig, String implClass, String typeArg, String moreArgs) {
        String fluent;
        if (!moreArgs.isEmpty()) {
            moreArgs = "," + moreArgs;
        }
        if (stepConfig != null) {
            fluent = stepConfig.getName();
            if (fluent.contains("...")) {
                fluent = fluent.replace("...", typeArg + moreArgs);
            }
            if (fluent.contains("<")) {
                fluent = fluent.replaceAll("[^\\d\\w_$]Value\\B", typeArg);
            }
        } else {
            fluent = "org.cthul.matchers.fluent8.ObjectFluent";
        }
        if (fluent.contains("<")) {
            int i = fluent.indexOf(60);
            fluent = fluent.substring(0, i) + implClass + fluent.substring(i);
        } else {
            fluent = fluent + implClass + "<";
            if (stepConfig != null && !stepConfig.getExtraParams().isEmpty()) {
                fluent = fluent + stepConfig.getExtraParams().stream().map(s -> s.contains(" extends ") ? s.substring(0, s.indexOf(" extends ")) : s).collect(Collectors.joining(",")) + ",";
            }
            fluent = fluent + typeArg + moreArgs + ">";
        }
        return fluent;
    }

    private FluentConfig findConfigFor(JavaClass valueClass) {
        String typeString = valueClass.getGenericFullyQualifiedName();
        JavaClass bestMatch = null;
        FluentConfig stepConfig = null;
        for (FluentConfig cfg : this.fluents) {
            if (cfg.getType().equals(typeString)) {
                stepConfig = cfg;
                break;
            }
            if (!valueClass.isA(QdoxTools.asClass((String)cfg.getType())) || bestMatch != null && (cfg.getType().equals("java.lang.Object") || bestMatch.isA(cfg.getValueClass()))) continue;
            bestMatch = cfg.getValueClass();
            stepConfig = cfg;
        }
        return stepConfig;
    }

    private void generateAssert(AssertConfig cfg, Api1 api) {
        GeneratedClass iAssert = QdoxTools.generatedInterface((Api1)api, (String)cfg.getName());
        iAssert.getInterfaces().addAll(cfg.getExtends());
        HashSet<String> names = new HashSet<String>();
        for (FluentConfig fc : this.fluents) {
            String adapterName;
            if (fc.isImplemented() || (adapterName = this.getAdapterName(fc, names)) == null) continue;
            GeneratedMethod mAdapter = QdoxTools.method((JavaClass)iAssert, (Object[])new Object[]{adapterName});
            mAdapter.getModifiers().add((Object)"public static");
            mAdapter.getTypeParameters().addAll(fc.getExtraParams());
            mAdapter.getTypeParameters().add("Value extends " + fc.getType());
            mAdapter.getTypeParameters().add("TheFluent");
            mAdapter.setReturns(this.getAdapterType(fc));
            mAdapter.setSourceCode("return " + fc.getName() + ".Step.adapter();");
            List<String> extraParams = fc.getExtraParams();
            extraParams.add("Value extends " + fc.getType());
            List extraArgs = GeneralTools.parametersToArgs(extraParams);
            String fluentClassName = fc.getName() + ".Assert";
            GeneratedMethod mAssert = QdoxTools.method((JavaClass)iAssert, (Object[])new Object[]{"public static assertThat(Value value)"});
            mAssert.setReturns((JavaClass)QdoxTools.withArgs((JavaClass)QdoxTools.asClass((String)fluentClassName), (Collection)extraArgs));
            mAssert.getTypeParameters().addAll(extraParams);
            mAssert.setBody("return new %s<>(org.cthul.matchers.fluent.builder.AssertionErrorHandler.instance(), org.cthul.matchers.fluent.adapters.IdentityValue.value(value));", new Object[]{fluentClassName});
        }
    }

    protected String getAdapterName(FluentConfig fc, Set<String> names) {
        String name = fc.getName();
        if (name.endsWith("Fluent")) {
            name = name.substring(0, name.length() - 6);
        }
        if (names.contains(name)) {
            name = fc.getType();
            if (name.contains("<")) {
                name = name.substring(0, name.indexOf(60));
            }
            name = name.substring(name.lastIndexOf(46) + 1);
        }
        if (!names.add(name = JavaNames.CamelCase((String)name))) {
            return null;
        }
        String adapterName = (name.matches("([AEIOU]).*") ? "an" : "a") + name;
        return adapterName;
    }

    private static <T> Stream<T> nonEmptyStream(Stream<T> stream, Supplier<T> defaultValue) {
        List list = stream.collect(Collectors.toList());
        if (list.isEmpty()) {
            list.add(defaultValue.get());
        }
        return list.stream();
    }

    public static class Renamer {
        final Map<Pattern, String> renameMap;

        public Renamer(Map<Pattern, String> renameMap) {
            this.renameMap = renameMap;
        }

        public String apply(String s) {
            for (Map.Entry<Pattern, String> e : this.renameMap.entrySet()) {
                s = e.getKey().matcher(s).replaceAll(e.getValue());
            }
            return s;
        }

        public void applyToName(GeneratedMethod m) {
            m.setName(this.apply(m.getName()));
        }
    }

    public static class AssertConfig {
        private final String name;
        private final List<String> extendz = new ArrayList<String>();

        public AssertConfig(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getExtends() {
            return this.extendz;
        }
    }

    public static class FactoryConfig {
        private final String clazz;
        private final List<String> includes;
        private final List<String> excludes;
        private final Map<String, String> typeParameterMap;
        private final Map<String, String> renameMap;
        private String adapterType = null;

        public FactoryConfig(String clazz) {
            this.clazz = clazz;
            this.includes = new ArrayList<String>(3);
            this.excludes = new ArrayList<String>(3);
            this.typeParameterMap = new HashMap<String, String>(3);
            this.renameMap = new HashMap<String, String>(3);
        }

        public String getClazz() {
            return this.clazz;
        }

        public List<String> getIncludes() {
            return this.includes;
        }

        public List<String> getExcludes() {
            return this.excludes;
        }

        public Map<String, String> getTypeParameterMap() {
            return this.typeParameterMap;
        }

        public Map<String, String> getTypeParameterMapping(JavaMethod jm) {
            Map<String, String> map = this.getTypeParameterMap();
            List tParams = jm.getTypeParameters();
            if (map.isEmpty() && !tParams.isEmpty()) {
                map = new HashMap<String, String>();
                map.put(((JavaTypeVariable)tParams.get(0)).getName(), "Value");
            } else {
                map = new HashMap<String, String>(map);
            }
            return map;
        }

        public Map<String, String> getRenameMap() {
            return this.renameMap;
        }

        public Map<Pattern, String> getRenamePatternMap() {
            HashMap<Pattern, String> result = new HashMap<Pattern, String>();
            this.renameMap.entrySet().forEach(e -> {
                String cfr_ignored_0 = (String)result.put(Pattern.compile((String)e.getKey()), (String)e.getValue());
            });
            return result;
        }

        public Renamer getRenamer() {
            return new Renamer(this.getRenamePatternMap());
        }

        Stream<JavaMethod> factoryMethods() {
            Stream<JavaMethod> methods = QdoxTools.asClass((String)this.clazz).getMethods().stream().filter(JavaMember::isStatic).filter(JavaMember::isPublic).filter(m -> QdoxTools.hasAnnotation((JavaAnnotatedElement)m, (String[])new String[]{".Factory"})).filter(this.matcher(this.includes, false)).filter(this.matcher(this.excludes, true));
            return FluentsGenerator.nonEmptyStream(methods, () -> {
                throw this.noFactories(QdoxTools.asClass((String)this.clazz));
            });
        }

        private Predicate<JavaMethod> matcher(List<String> rules, boolean exclude) {
            if (rules.isEmpty()) {
                return jm -> true;
            }
            StringBuilder sb = new StringBuilder();
            rules.stream().forEach(r -> sb.append("(").append((String)r).append(")|"));
            sb.setLength(sb.length() - 1);
            Pattern p = Pattern.compile(sb.toString());
            return jm -> p.matcher(jm.getDeclarationSignature(false)).find() ^ exclude;
        }

        private RuntimeException noFactories(JavaClass sourceClass) {
            StringBuilder sb = new StringBuilder();
            sb.append("No factory methods in ").append(sourceClass.getCanonicalName()).append(".");
            if (!this.includes.isEmpty()) {
                sb.append("\ninclude: ").append(this.includes);
            }
            if (!this.excludes.isEmpty()) {
                sb.append("\nexclude: ").append(this.includes);
            }
            for (JavaMethod jm : sourceClass.getMethods()) {
                if (!jm.isStatic()) continue;
                sb.append("\n- ");
                try {
                    sb.append(jm);
                }
                catch (Exception e) {
                    try {
                        sb.append(jm.getDeclarationSignature(true));
                    }
                    catch (Exception e2) {
                        try {
                            sb.append(jm.getName());
                        }
                        catch (Exception e3) {
                            sb.append(e);
                        }
                    }
                }
            }
            throw new RuntimeException(sb.toString());
        }

        public void setAdapterType(String adapterType) {
            this.adapterType = adapterType;
        }

        public String getAdapterType() {
            if (this.adapterType == null) {
                return "java.lang.Object";
            }
            return this.adapterType;
        }
    }

    public static class FluentConfig {
        private final String name;
        private final String type;
        private final List<String> extraParams;
        private final List<String> extendz;
        private final List<FactoryConfig> factories;
        private boolean isImplemented = false;
        private String adapterType;
        private JavaClass valueClass;

        public FluentConfig(String name, String type) {
            this.name = name;
            this.type = type != null ? type : "java.lang.Object";
            this.extraParams = new ArrayList<String>(3);
            this.extendz = new ArrayList<String>(3);
            this.factories = new ArrayList<FactoryConfig>(3);
        }

        public String getName() {
            return this.name;
        }

        public List<String> getExtraParams() {
            return this.extraParams;
        }

        public List<String> getExtends() {
            return this.extendz;
        }

        public void setImplemented(boolean isImplemented) {
            if (isImplemented && !this.factories.isEmpty()) {
                throw new IllegalArgumentException("Implementation reference can not define factories: " + this.name + " -> " + this.factories);
            }
            this.isImplemented = isImplemented;
        }

        public boolean isImplemented() {
            return this.isImplemented;
        }

        public String getType() {
            return this.type;
        }

        public JavaClass getValueClass() {
            if (this.valueClass == null) {
                this.valueClass = QdoxTools.asType((String)this.getType());
            }
            return this.valueClass;
        }

        public List<FactoryConfig> getFactories() {
            if (this.isImplemented && !this.factories.isEmpty()) {
                throw new IllegalArgumentException("Implementation reference can not define factories: " + this.name + " -> " + this.factories);
            }
            return this.factories;
        }

        public String getAdapterType() {
            return this.adapterType;
        }

        public void setAdapterType(String adapterType) {
            this.adapterType = adapterType;
        }

        public String getAdapterTypeName() {
            if (this.adapterType != null) {
                return this.adapterType;
            }
            String t = this.type;
            int i = t.indexOf(60);
            if (i > 0) {
                t = t.substring(0, i).trim();
            }
            return t;
        }

        private String getCastMethodName() {
            String cast = this.getName();
            if (cast.contains("<")) {
                cast = cast.substring(0, cast.indexOf(60));
            }
            if (cast.contains(".")) {
                cast = cast.substring(cast.lastIndexOf(46) + 1);
            }
            if (cast.endsWith("Fluent")) {
                cast = cast.substring(0, cast.length() - "Fluent".length());
            }
            return cast;
        }

        public boolean isValueSubclass(FluentConfig other) {
            return this != other && this.getValueClass().isA(other.getValueClass());
        }
    }
}

