/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.fluent.gen;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.cthul.matchers.fluent.gen.FluentsGenerator;

public class FluentsXmlParser {
    private final List<FluentsGenerator.FluentConfig> factories = new ArrayList<FluentsGenerator.FluentConfig>();
    private final List<FluentsGenerator.AssertConfig> asserts = new ArrayList<FluentsGenerator.AssertConfig>();

    public List<FluentsGenerator.FluentConfig> getFactories() {
        return this.factories;
    }

    public List<FluentsGenerator.AssertConfig> getAsserts() {
        return this.asserts;
    }

    public void parse(XMLStreamReader xml) throws XMLStreamException {
        try {
            xml.nextTag();
            xml.require(1, null, "fluents");
            block14: while (xml.nextTag() == 1) {
                switch (xml.getLocalName()) {
                    case "fluent": {
                        this.factories.add(this.readFluentConfig(xml));
                        continue block14;
                    }
                    case "assert": {
                        this.asserts.add(this.readAssertConfig(xml));
                        continue block14;
                    }
                }
                throw new XMLStreamException("Expected <fluent> or <assert>, got: " + xml.getLocalName(), xml.getLocation());
            }
            xml.require(2, null, "fluents");
        }
        catch (XMLStreamException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new XMLStreamException(e.getMessage(), xml.getLocation(), e);
        }
        finally {
            xml.close();
        }
    }

    private FluentsGenerator.FluentConfig readFluentConfig(XMLStreamReader xml) throws XMLStreamException {
        String name = xml.getAttributeValue(null, "name");
        String impl = xml.getAttributeValue(null, "impl");
        String type = xml.getAttributeValue(null, "type");
        String ext = xml.getAttributeValue(null, "extends");
        String extra = xml.getAttributeValue(null, "extraParams");
        if (impl != null) {
            impl = FluentsXmlParser.genericFix(impl);
            if (name == null) {
                name = impl;
            }
        }
        FluentsGenerator.FluentConfig flc = new FluentsGenerator.FluentConfig(name, FluentsXmlParser.genericFix(type));
        if (ext != null) {
            flc.getExtends().add(FluentsXmlParser.genericFix(ext));
        }
        if (extra != null) {
            extra = FluentsXmlParser.genericFix(extra);
            for (String s : extra.split(",")) {
                if (s.isEmpty()) continue;
                flc.getExtraParams().add(s);
            }
        }
        block11: while (xml.nextTag() == 1) {
            switch (xml.getLocalName()) {
                case "adapter": {
                    String aType = xml.getAttributeValue(null, "type");
                    flc.setAdapterType(aType);
                    xml.nextTag();
                    continue block11;
                }
                case "extends": {
                    flc.getExtends().add(FluentsXmlParser.genericFix(xml.getElementText()));
                    continue block11;
                }
                case "factory": {
                    flc.getFactories().add(this.readFactoryConfig(xml));
                    continue block11;
                }
            }
            throw new XMLStreamException("Expected <adapter>, <extends> or <factory>, got: " + xml.getLocalName(), xml.getLocation());
        }
        flc.setImplemented(impl != null);
        return flc;
    }

    private FluentsGenerator.FactoryConfig readFactoryConfig(XMLStreamReader xml) throws XMLStreamException {
        String clazz = xml.getAttributeValue(null, "class");
        FluentsGenerator.FactoryConfig fac = new FluentsGenerator.FactoryConfig(clazz);
        String s = xml.getAttributeValue(null, "include");
        if (s != null) {
            fac.getIncludes().add(s);
        }
        if ((s = xml.getAttributeValue(null, "exclude")) != null) {
            fac.getExcludes().add(s);
        }
        while (xml.nextTag() == 1) {
            switch (xml.getLocalName()) {
                case "include": {
                    fac.getIncludes().add(xml.getElementText());
                    break;
                }
                case "exclude": {
                    fac.getExcludes().add(xml.getElementText());
                    break;
                }
                case "rename": {
                    String from = xml.getAttributeValue(null, "from");
                    String to = xml.getAttributeValue(null, "to");
                    fac.getRenameMap().put(from, to);
                    xml.nextTag();
                    break;
                }
                case "mapTypeParameter": {
                    String from = xml.getAttributeValue(null, "from");
                    String to = xml.getAttributeValue(null, "to");
                    fac.getTypeParameterMap().put(FluentsXmlParser.genericFix(from), FluentsXmlParser.genericFix(to));
                    xml.nextTag();
                    break;
                }
                case "disableTypeParameterMapping": {
                    fac.getTypeParameterMap().put("---", "---");
                    xml.nextTag();
                    break;
                }
            }
        }
        return fac;
    }

    private FluentsGenerator.AssertConfig readAssertConfig(XMLStreamReader xml) throws XMLStreamException {
        String name = xml.getAttributeValue(null, "name");
        FluentsGenerator.AssertConfig asc = new FluentsGenerator.AssertConfig(name);
        while (xml.nextTag() == 1) {
            switch (xml.getLocalName()) {
                case "extends": {
                    asc.getExtends().add(FluentsXmlParser.genericFix(xml.getElementText()));
                }
            }
        }
        xml.require(2, null, "assert");
        return asc;
    }

    private static String genericFix(String s) {
        if (s == null) {
            return null;
        }
        return s.replace('{', '<').replace('}', '>');
    }
}

