package org.cthul.matchers;

public class FlMatchers {

    /**
     * @see org.cthul.matchers.object.CIs#is(org.hamcrest.Matcher)
     */
    public static <T> org.cthul.matchers.object.CIs<T> is(org.hamcrest.Matcher<? super T> matcher) {
        return org.cthul.matchers.object.CIs.is(matcher);
    }

    /**
     * @see org.cthul.matchers.object.CIs#has(org.hamcrest.Matcher)
     */
    public static <T> org.cthul.matchers.object.CIs<T> has(org.hamcrest.Matcher<? super T> matcher) {
        return org.cthul.matchers.object.CIs.has(matcher);
    }

    /**
     * @see org.cthul.matchers.object.CIs#not(org.hamcrest.Matcher)
     */
    public static <T> org.cthul.matchers.object.CIs<T> not(org.hamcrest.Matcher<? super T> matcher) {
        return org.cthul.matchers.object.CIs.not(matcher);
    }

    /**
     * @see org.cthul.matchers.object.CIs#isNot(org.hamcrest.Matcher)
     */
    public static <T> org.cthul.matchers.object.CIs<T> isNot(org.hamcrest.Matcher<? super T> matcher) {
        return org.cthul.matchers.object.CIs.isNot(matcher);
    }

    /**
     * @see org.cthul.matchers.object.CIs#_is(org.hamcrest.Matcher)
     */
    public static <T> org.cthul.matchers.object.CIs<T> _is(org.hamcrest.Matcher<? super T> matcher) {
        return org.cthul.matchers.object.CIs._is(matcher);
    }

    /**
     * @see org.cthul.matchers.object.CIs#_has(org.hamcrest.Matcher)
     */
    public static <T> org.cthul.matchers.object.CIs<T> _has(org.hamcrest.Matcher<? super T> matcher) {
        return org.cthul.matchers.object.CIs._has(matcher);
    }

    /**
     * @see org.cthul.matchers.object.CIs#_not(org.hamcrest.Matcher)
     */
    public static <T> org.cthul.matchers.object.CIs<T> _not(org.hamcrest.Matcher<? super T> matcher) {
        return org.cthul.matchers.object.CIs._not(matcher);
    }

    /**
     * @see org.cthul.matchers.object.CIs#_isNot(org.hamcrest.Matcher)
     */
    public static <T> org.cthul.matchers.object.CIs<T> _isNot(org.hamcrest.Matcher<? super T> matcher) {
        return org.cthul.matchers.object.CIs._isNot(matcher);
    }

    /**
     * Can the given pattern be found in the string?
     *
     * @param regex
     * @return String-Matcher
     * @see org.cthul.matchers.object.ContainsPattern#containsPattern(java.lang.String)
     */
    public static org.hamcrest.Matcher<java.lang.CharSequence> containsPattern(java.lang.String regex) {
        return org.cthul.matchers.object.ContainsPattern.containsPattern(regex);
    }

    /**
     * Can the given pattern be found in the string?
     *
     * @param p
     * @return String-Matcher
     * @see org.cthul.matchers.object.ContainsPattern#containsPattern(java.util.regex.Pattern)
     */
    public static org.hamcrest.Matcher<java.lang.CharSequence> containsPattern(java.util.regex.Pattern p) {
        return org.cthul.matchers.object.ContainsPattern.containsPattern(p);
    }

    /**
     * Does the pattern match the entire string?
     *
     * @param regex
     * @return String-Matcher
     * @see org.cthul.matchers.object.ContainsPattern#matchesPattern(java.lang.String)
     */
    public static org.hamcrest.Matcher<java.lang.CharSequence> matchesPattern(java.lang.String regex) {
        return org.cthul.matchers.object.ContainsPattern.matchesPattern(regex);
    }

    /**
     * Does the pattern match the entire string?
     *
     * @param p
     * @return String-Matcher
     * @see org.cthul.matchers.object.ContainsPattern#matchesPattern(java.util.regex.Pattern)
     */
    public static org.hamcrest.Matcher<java.lang.CharSequence> matchesPattern(java.util.regex.Pattern p) {
        return org.cthul.matchers.object.ContainsPattern.matchesPattern(p);
    }

    /**
     * @see org.cthul.matchers.object.InstanceThat#instanceThat(java.lang.Class,org.hamcrest.Matcher)
     */
    public static <T,T2> org.cthul.matchers.chain.AndChainMatcher.Builder<T> instanceThat(java.lang.Class<T2> clazz, org.hamcrest.Matcher<? super T2> m) {
        return org.cthul.matchers.object.InstanceThat.instanceThat(clazz, m);
    }

    /**
     * @see org.cthul.matchers.object.InstanceThat#instanceThat(java.lang.Class,org.hamcrest.Matcher...)
     */
    public static <T,T2> org.cthul.matchers.chain.AndChainMatcher.Builder<T> instanceThat(java.lang.Class<T2> clazz, org.hamcrest.Matcher<? super T2>... m) {
        return org.cthul.matchers.object.InstanceThat.instanceThat(clazz, m);
    }

    /**
     * @see org.cthul.matchers.object.InstanceThat#isInstanceThat(java.lang.Class,org.hamcrest.Matcher)
     */
    public static <T,T2> org.cthul.matchers.chain.AndChainMatcher.Builder<T> isInstanceThat(java.lang.Class<T2> clazz, org.hamcrest.Matcher<? super T2> m) {
        return org.cthul.matchers.object.InstanceThat.isInstanceThat(clazz, m);
    }

    /**
     * @see org.cthul.matchers.object.InstanceThat#isInstanceThat(java.lang.Class,org.hamcrest.Matcher...)
     */
    public static <T,T2> org.hamcrest.Matcher<T> isInstanceThat(java.lang.Class<T2> clazz, org.hamcrest.Matcher<? super T2>... m) {
        return org.cthul.matchers.object.InstanceThat.isInstanceThat(clazz, m);
    }

    /**
     * @see org.cthul.matchers.object.InstanceOf#isInstanceOf(java.lang.Class)
     */
    public static <T> org.cthul.matchers.object.InstanceOf<T> isInstanceOf(java.lang.Class<T> clazz) {
        return org.cthul.matchers.object.InstanceOf.isInstanceOf(clazz);
    }

    /**
     * @see org.cthul.matchers.object.InstanceOf#instanceOf(java.lang.Class)
     */
    public static <T> org.cthul.matchers.object.InstanceOf<T> instanceOf(java.lang.Class<T> clazz) {
        return org.cthul.matchers.object.InstanceOf.instanceOf(clazz);
    }

    /**
     * @see org.cthul.matchers.object.InstanceOf#isA(java.lang.Class)
     */
    public static <T> org.cthul.matchers.object.InstanceOf<T> isA(java.lang.Class<T> clazz) {
        return org.cthul.matchers.object.InstanceOf.isA(clazz);
    }

    /**
     * @see org.cthul.matchers.object.InstanceOf#_instanceOf(java.lang.Class)
     */
    public static <T> org.cthul.matchers.object.InstanceOf<T> _instanceOf(java.lang.Class<T> clazz) {
        return org.cthul.matchers.object.InstanceOf._instanceOf(clazz);
    }

    /**
     * @see org.cthul.matchers.object.InstanceOf#_isA(java.lang.Class)
     */
    public static <T> org.cthul.matchers.object.InstanceOf<T> _isA(java.lang.Class<T> clazz) {
        return org.cthul.matchers.object.InstanceOf._isA(clazz);
    }

    /**
     * @see org.cthul.matchers.object.InstanceOf#a(java.lang.Class)
     */
    public static <T> org.cthul.matchers.object.InstanceOf<T> a(java.lang.Class<T> clazz) {
        return org.cthul.matchers.object.InstanceOf.a(clazz);
    }

    /**
     * @see org.cthul.matchers.exceptions.CausedBy#causedBy(org.hamcrest.Matcher)
     */
    public static org.cthul.matchers.exceptions.CausedBy causedBy(org.hamcrest.Matcher<? super java.lang.Throwable> matcher) {
        return org.cthul.matchers.exceptions.CausedBy.causedBy(matcher);
    }

    /**
     * @see org.cthul.matchers.exceptions.CausedBy#causedBy(java.lang.Class)
     */
    public static org.cthul.matchers.exceptions.CausedBy causedBy(java.lang.Class<? extends java.lang.Throwable> clazz) {
        return org.cthul.matchers.exceptions.CausedBy.causedBy(clazz);
    }

    /**
     * @see org.cthul.matchers.exceptions.CausedBy#causedBy(java.lang.String)
     */
    public static org.cthul.matchers.exceptions.CausedBy causedBy(java.lang.String message) {
        return org.cthul.matchers.exceptions.CausedBy.causedBy(message);
    }

    /**
     * @see org.cthul.matchers.exceptions.CausedBy#causedBy(java.lang.Class,java.lang.String)
     */
    public static org.cthul.matchers.exceptions.CausedBy causedBy(java.lang.Class<? extends java.lang.Throwable> clazz, java.lang.String message) {
        return org.cthul.matchers.exceptions.CausedBy.causedBy(clazz, message);
    }

    /**
     * @see org.cthul.matchers.exceptions.CausedBy#causedBy(java.lang.Class,org.hamcrest.Matcher)
     */
    public static org.cthul.matchers.exceptions.CausedBy causedBy(java.lang.Class<? extends java.lang.Throwable> clazz, org.hamcrest.Matcher<? super java.lang.Throwable> matcher) {
        return org.cthul.matchers.exceptions.CausedBy.causedBy(clazz, matcher);
    }

    /**
     * @see org.cthul.matchers.exceptions.CausedBy#causedBy(java.lang.Class,java.lang.String,org.hamcrest.Matcher)
     */
    public static org.cthul.matchers.exceptions.CausedBy causedBy(java.lang.Class<? extends java.lang.Throwable> clazz, java.lang.String message, org.hamcrest.Matcher<? super java.lang.Throwable> matcher) {
        return org.cthul.matchers.exceptions.CausedBy.causedBy(clazz, message, matcher);
    }

    /**
     * @see org.cthul.matchers.exceptions.CausedBy#directlyCausedBy(org.hamcrest.Matcher)
     */
    public static org.cthul.matchers.exceptions.CausedBy directlyCausedBy(org.hamcrest.Matcher<? super java.lang.Throwable> matcher) {
        return org.cthul.matchers.exceptions.CausedBy.directlyCausedBy(matcher);
    }

    /**
     * @see org.cthul.matchers.exceptions.CausedBy#directlyCausedBy(java.lang.Class)
     */
    public static org.cthul.matchers.exceptions.CausedBy directlyCausedBy(java.lang.Class<? extends java.lang.Throwable> clazz) {
        return org.cthul.matchers.exceptions.CausedBy.directlyCausedBy(clazz);
    }

    /**
     * @see org.cthul.matchers.exceptions.CausedBy#directlyCausedBy(java.lang.Class,java.lang.String)
     */
    public static org.cthul.matchers.exceptions.CausedBy directlyCausedBy(java.lang.Class<? extends java.lang.Throwable> clazz, java.lang.String message) {
        return org.cthul.matchers.exceptions.CausedBy.directlyCausedBy(clazz, message);
    }

    /**
     * @see org.cthul.matchers.exceptions.CausedBy#directlyCausedBy(java.lang.Class,org.hamcrest.Matcher)
     */
    public static org.cthul.matchers.exceptions.CausedBy directlyCausedBy(java.lang.Class<? extends java.lang.Throwable> clazz, org.hamcrest.Matcher<? super java.lang.Throwable> matcher) {
        return org.cthul.matchers.exceptions.CausedBy.directlyCausedBy(clazz, matcher);
    }

    /**
     * @see org.cthul.matchers.exceptions.CausedBy#directlyCausedBy(java.lang.Class,java.lang.String,org.hamcrest.Matcher)
     */
    public static org.cthul.matchers.exceptions.CausedBy directlyCausedBy(java.lang.Class<? extends java.lang.Throwable> clazz, java.lang.String message, org.hamcrest.Matcher<? super java.lang.Throwable> matcher) {
        return org.cthul.matchers.exceptions.CausedBy.directlyCausedBy(clazz, message, matcher);
    }

    /**
     * @see org.cthul.matchers.exceptions.ExceptionMessage#messageIs(java.lang.String)
     */
    public static org.cthul.matchers.exceptions.ExceptionMessage messageIs(java.lang.String message) {
        return org.cthul.matchers.exceptions.ExceptionMessage.messageIs(message);
    }

    /**
     * @see org.cthul.matchers.exceptions.ExceptionMessage#messageContains(java.lang.String)
     */
    public static org.cthul.matchers.exceptions.ExceptionMessage messageContains(java.lang.String regex) {
        return org.cthul.matchers.exceptions.ExceptionMessage.messageContains(regex);
    }

    /**
     * @see org.cthul.matchers.exceptions.ExceptionMessage#messageMatches(java.lang.String)
     */
    public static org.cthul.matchers.exceptions.ExceptionMessage messageMatches(java.lang.String regex) {
        return org.cthul.matchers.exceptions.ExceptionMessage.messageMatches(regex);
    }

    /**
     * @see org.cthul.matchers.exceptions.ExceptionMessage#messageContains(java.util.regex.Pattern)
     */
    public static org.cthul.matchers.exceptions.ExceptionMessage messageContains(java.util.regex.Pattern pattern) {
        return org.cthul.matchers.exceptions.ExceptionMessage.messageContains(pattern);
    }

    /**
     * @see org.cthul.matchers.exceptions.ExceptionMessage#messageMatches(java.util.regex.Pattern)
     */
    public static org.cthul.matchers.exceptions.ExceptionMessage messageMatches(java.util.regex.Pattern pattern) {
        return org.cthul.matchers.exceptions.ExceptionMessage.messageMatches(pattern);
    }

    /**
     * @see org.cthul.matchers.exceptions.ExceptionMessage#message(org.hamcrest.Matcher)
     */
    public static org.cthul.matchers.exceptions.ExceptionMessage message(org.hamcrest.Matcher<? super java.lang.String> messageMatcher) {
        return org.cthul.matchers.exceptions.ExceptionMessage.message(messageMatcher);
    }

    /**
     * @see org.cthul.matchers.exceptions.IsThrowable#throwable()
     */
    public static org.cthul.matchers.object.InstanceOf<java.lang.Throwable> throwable() {
        return org.cthul.matchers.exceptions.IsThrowable.throwable();
    }

    /**
     * @see org.cthul.matchers.exceptions.IsThrowable#throwable(java.lang.Class)
     */
    public static <T extends Throwable> org.cthul.matchers.object.InstanceOf<T> throwable(java.lang.Class<T> clazz) {
        return org.cthul.matchers.exceptions.IsThrowable.throwable(clazz);
    }

    /**
     * @see org.cthul.matchers.exceptions.IsThrowable#throwable(java.lang.String)
     */
    public static org.hamcrest.Matcher<java.lang.Object> throwable(java.lang.String message) {
        return org.cthul.matchers.exceptions.IsThrowable.throwable(message);
    }

    /**
     * @see org.cthul.matchers.exceptions.IsThrowable#throwable(java.lang.Class,java.lang.String)
     */
    public static org.hamcrest.Matcher<java.lang.Object> throwable(java.lang.Class<? extends java.lang.Throwable> clazz, java.lang.String message) {
        return org.cthul.matchers.exceptions.IsThrowable.throwable(clazz, message);
    }

    /**
     * @see org.cthul.matchers.exceptions.IsThrowable#throwable(org.hamcrest.Matcher)
     */
    public static org.hamcrest.Matcher<java.lang.Object> throwable(org.hamcrest.Matcher<? super java.lang.Throwable> matcher) {
        return org.cthul.matchers.exceptions.IsThrowable.throwable(matcher);
    }

    /**
     * @see org.cthul.matchers.exceptions.IsThrowable#throwable(java.lang.Class,org.hamcrest.Matcher)
     */
    public static <T extends Throwable> org.hamcrest.Matcher<java.lang.Object> throwable(java.lang.Class<T> clazz, org.hamcrest.Matcher<? super T> matcher) {
        return org.cthul.matchers.exceptions.IsThrowable.throwable(clazz, matcher);
    }

    /**
     * @see org.cthul.matchers.exceptions.IsThrowable#throwable(java.lang.Class,java.lang.String,org.hamcrest.Matcher)
     */
    public static <T extends Throwable> org.hamcrest.Matcher<java.lang.Object> throwable(java.lang.Class<T> clazz, java.lang.String message, org.hamcrest.Matcher<? super T> matcher) {
        return org.cthul.matchers.exceptions.IsThrowable.throwable(clazz, message, matcher);
    }

    /**
     * @see org.cthul.matchers.exceptions.IsThrowable#exception()
     */
    public static org.cthul.matchers.object.InstanceOf<java.lang.Exception> exception() {
        return org.cthul.matchers.exceptions.IsThrowable.exception();
    }

    /**
     * @see org.cthul.matchers.exceptions.IsThrowable#exception(java.lang.Class)
     */
    public static <T extends Exception> org.cthul.matchers.object.InstanceOf<T> exception(java.lang.Class<T> clazz) {
        return org.cthul.matchers.exceptions.IsThrowable.exception(clazz);
    }

    /**
     * @see org.cthul.matchers.exceptions.IsThrowable#exception(java.lang.String)
     */
    public static org.hamcrest.Matcher<java.lang.Object> exception(java.lang.String message) {
        return org.cthul.matchers.exceptions.IsThrowable.exception(message);
    }

    /**
     * @see org.cthul.matchers.exceptions.IsThrowable#exception(org.hamcrest.Matcher)
     */
    public static org.hamcrest.Matcher<java.lang.Object> exception(org.hamcrest.Matcher<? super java.lang.Exception> matcher) {
        return org.cthul.matchers.exceptions.IsThrowable.exception(matcher);
    }

    /**
     * @see org.cthul.matchers.exceptions.IsThrowable#exception(java.lang.Class,java.lang.String)
     */
    public static org.hamcrest.Matcher<java.lang.Object> exception(java.lang.Class<? extends java.lang.Exception> clazz, java.lang.String message) {
        return org.cthul.matchers.exceptions.IsThrowable.exception(clazz, message);
    }

    /**
     * @see org.cthul.matchers.exceptions.IsThrowable#exception(java.lang.Class,org.hamcrest.Matcher)
     */
    public static <T extends Exception> org.hamcrest.Matcher<java.lang.Object> exception(java.lang.Class<T> clazz, org.hamcrest.Matcher<? super T> matcher) {
        return org.cthul.matchers.exceptions.IsThrowable.exception(clazz, matcher);
    }

    /**
     * @see org.cthul.matchers.exceptions.IsThrowable#exception(java.lang.Class,java.lang.String,org.hamcrest.Matcher)
     */
    public static <T extends Exception> org.hamcrest.Matcher<java.lang.Object> exception(java.lang.Class<T> clazz, java.lang.String message, org.hamcrest.Matcher<? super T> matcher) {
        return org.cthul.matchers.exceptions.IsThrowable.exception(clazz, message, matcher);
    }

    /**
     * Does the proc raise a throwable that satisfies the condition?
     *
     * @param throwableMatcher
     * @return Proc-Matcher
     * @see org.cthul.matchers.proc.Raises#raises(org.hamcrest.Matcher)
     */
    public static org.hamcrest.Matcher<org.cthul.proc.Proc> raises(org.hamcrest.Matcher<? super java.lang.Throwable> throwableMatcher) {
        return org.cthul.matchers.proc.Raises.raises(throwableMatcher);
    }

    /**
     * Does the proc raise a throwable that satisfies the condition?
     *
     * @param clazz
     * @return Proc-Matcher
     * @see org.cthul.matchers.proc.Raises#raises(java.lang.Class)
     */
    public static org.hamcrest.Matcher<org.cthul.proc.Proc> raises(java.lang.Class<? extends java.lang.Throwable> clazz) {
        return org.cthul.matchers.proc.Raises.raises(clazz);
    }

    /**
     * Does the proc raise a throwable that satisfies the condition?
     *
     * @param regex
     * @return Proc-Matcher
     * @see org.cthul.matchers.proc.Raises#raises(java.lang.String)
     */
    public static org.hamcrest.Matcher<org.cthul.proc.Proc> raises(java.lang.String regex) {
        return org.cthul.matchers.proc.Raises.raises(regex);
    }

    /**
     * Does the proc raise a throwable that satisfies the condition?
     *
     * @param clazz
     * @param regex
     * @return Proc-Matcher
     * @see org.cthul.matchers.proc.Raises#raises(java.lang.Class,java.lang.String)
     */
    public static org.hamcrest.Matcher<org.cthul.proc.Proc> raises(java.lang.Class<? extends java.lang.Throwable> clazz, java.lang.String regex) {
        return org.cthul.matchers.proc.Raises.raises(clazz, regex);
    }

    /**
     * Does the proc raise a throwable that satisfies the condition?
     *
     * @param clazz
     * @param matcher
     * @return Proc-Matcher
     * @see org.cthul.matchers.proc.Raises#raises(java.lang.Class,org.hamcrest.Matcher)
     */
    public static org.hamcrest.Matcher<org.cthul.proc.Proc> raises(java.lang.Class<? extends java.lang.Throwable> clazz, org.hamcrest.Matcher<? super java.lang.Throwable> matcher) {
        return org.cthul.matchers.proc.Raises.raises(clazz, matcher);
    }

    /**
     * Does the proc throw an exception?
     *
     * @return Proc-Matcher
     * @see org.cthul.matchers.proc.Raises#raisesException()
     */
    public static org.hamcrest.Matcher<org.cthul.proc.Proc> raisesException() {
        return org.cthul.matchers.proc.Raises.raisesException();
    }

    /**
     * Does the proc raise an exception that satisfies the condition?
     *
     * @param matcher
     * @return Proc-Matcher
     * @see org.cthul.matchers.proc.Raises#raisesException(org.hamcrest.Matcher)
     */
    public static org.hamcrest.Matcher<org.cthul.proc.Proc> raisesException(org.hamcrest.Matcher<? super java.lang.Exception> matcher) {
        return org.cthul.matchers.proc.Raises.raisesException(matcher);
    }

    /**
     * Does the proc raise an exception that satisfies the condition?
     *
     * @param clazz
     * @return Proc-Matcher
     * @see org.cthul.matchers.proc.Raises#raisesException(java.lang.Class)
     */
    public static org.hamcrest.Matcher<org.cthul.proc.Proc> raisesException(java.lang.Class<? extends java.lang.Exception> clazz) {
        return org.cthul.matchers.proc.Raises.raisesException(clazz);
    }

    /**
     * Does the proc raise an exception that satisfies the condition?
     *
     * @param regex
     * @return Proc-Matcher
     * @see org.cthul.matchers.proc.Raises#raisesException(java.lang.String)
     */
    public static org.hamcrest.Matcher<org.cthul.proc.Proc> raisesException(java.lang.String regex) {
        return org.cthul.matchers.proc.Raises.raisesException(regex);
    }

    /**
     * Does the proc raise an exception that satisfies the condition?
     *
     * @param clazz
     * @param regex
     * @return Proc-Matcher
     * @see org.cthul.matchers.proc.Raises#raisesException(java.lang.Class,java.lang.String)
     */
    public static org.hamcrest.Matcher<org.cthul.proc.Proc> raisesException(java.lang.Class<? extends java.lang.Exception> clazz, java.lang.String regex) {
        return org.cthul.matchers.proc.Raises.raisesException(clazz, regex);
    }

    /**
     * Does the proc return a value equal to {@code value}?
     *
     * @param value
     * @return Proc-Matcher
     * @see org.cthul.matchers.proc.Returns#result(java.lang.Object)
     */
    public static org.hamcrest.Matcher<org.cthul.proc.Proc> result(java.lang.Object value) {
        return org.cthul.matchers.proc.Returns.result(value);
    }

    /**
     * Does the proc return a value that satisfies the condition?
     *
     * @param resultMatcher
     * @return Proc-Matcher
     * @see org.cthul.matchers.proc.Returns#result(org.hamcrest.Matcher)
     */
    public static org.hamcrest.Matcher<org.cthul.proc.Proc> result(org.hamcrest.Matcher<?> resultMatcher) {
        return org.cthul.matchers.proc.Returns.result(resultMatcher);
    }

    /**
     * Does the proc complete without throwing an exception?
     *
     * @return Proc-Matcher
     * @see org.cthul.matchers.proc.Returns#hasResult()
     */
    public static org.hamcrest.Matcher<org.cthul.proc.Proc> hasResult() {
        return org.cthul.matchers.proc.Returns.hasResult();
    }

    /**
     * Does the proc return a value equal to {@code value}?
     *
     * @param value
     * @return Proc-Matcher
     * @see org.cthul.matchers.proc.Returns#returns(java.lang.Object)
     */
    public static org.hamcrest.Matcher<org.cthul.proc.Proc> returns(java.lang.Object value) {
        return org.cthul.matchers.proc.Returns.returns(value);
    }

    /**
     * Does the proc return a value that satisfies the condition?
     *
     * @param resultMatcher
     * @return Proc-Matcher
     * @see org.cthul.matchers.proc.Returns#returns(org.hamcrest.Matcher)
     */
    public static org.hamcrest.Matcher<org.cthul.proc.Proc> returns(org.hamcrest.Matcher<?> resultMatcher) {
        return org.cthul.matchers.proc.Returns.returns(resultMatcher);
    }

    /**
     * Does the proc complete without throwing an exception?
     *
     * @return Proc-Matcher
     * @see org.cthul.matchers.proc.Returns#returns()
     */
    public static org.hamcrest.Matcher<org.cthul.proc.Proc> returns() {
        return org.cthul.matchers.proc.Returns.returns();
    }

    /**
     * Wraps an existing matcher, overriding its description with that specified.  All other functions are
     * delegated to the decorated matcher, including its mismatch description.
     * <p>
     * For example:
     * <pre>describedAs("a big decimal equal to %0", equalTo(myBigDecimal), myBigDecimal.toPlainString())</pre>
     *
     * @param description
    the new description for the wrapped matcher
     * @param matcher
    the matcher to wrap
     * @param values
    optional values to insert into the tokenised description
     * @see org.hamcrest.core.DescribedAs#describedAs(java.lang.String,org.hamcrest.Matcher,java.lang.Object...)
     */
    public static <T> org.hamcrest.Matcher<T> describedAs(java.lang.String description, org.hamcrest.Matcher<T> matcher, java.lang.Object... values) {
        return org.hamcrest.core.DescribedAs.describedAs(description, matcher, values);
    }

    /**
     * Creates a matcher that always matches, regardless of the examined object.
     *
     * @see org.hamcrest.core.IsAnything#anything()
     */
    public static org.hamcrest.Matcher<java.lang.Object> anything() {
        return org.hamcrest.core.IsAnything.anything();
    }

    /**
     * Creates a matcher that always matches, regardless of the examined object, but describes
     * itself with the specified {@link String}.
     *
     * @param description
    a meaningful {@link String} used when describing itself
     * @see org.hamcrest.core.IsAnything#anything(java.lang.String)
     */
    public static org.hamcrest.Matcher<java.lang.Object> anything(java.lang.String description) {
        return org.hamcrest.core.IsAnything.anything(description);
    }

    /**
     * Creates a matcher for {@link Iterable}s that only matches when a single pass over the
     * examined {@link Iterable} yields at least one item that is matched by the specified
     * <code>itemMatcher</code>.  Whilst matching, the traversal of the examined {@link Iterable}
     * will stop as soon as a matching item is found.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar"), hasItem(startsWith("ba")))</pre>
     *
     * @param itemMatcher
    the matcher to apply to items provided by the examined {@link Iterable}
     * @see org.hamcrest.core.IsCollectionContaining#hasItem(org.hamcrest.Matcher)
     */
    public static <T> org.hamcrest.Matcher<java.lang.Iterable<? super T>> hasItem(org.hamcrest.Matcher<? super T> itemMatcher) {
        return org.hamcrest.core.IsCollectionContaining.hasItem(itemMatcher);
    }

    /**
     * Creates a matcher for {@link Iterable}s that only matches when a single pass over the
     * examined {@link Iterable} yields at least one item that is equal to the specified
     * <code>item</code>.  Whilst matching, the traversal of the examined {@link Iterable}
     * will stop as soon as a matching item is found.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar"), hasItem("bar"))</pre>
     *
     * @param item
    the item to compare against the items provided by the examined {@link Iterable}
     * @see org.hamcrest.core.IsCollectionContaining#hasItem(java.lang.Object)
     */
    public static <T> org.hamcrest.Matcher<java.lang.Iterable<? super T>> hasItem(T item) {
        return org.hamcrest.core.IsCollectionContaining.hasItem(item);
    }

    /**
     * Creates a matcher for {@link Iterable}s that matches when consecutive passes over the
     * examined {@link Iterable} yield at least one item that is matched by the corresponding
     * matcher from the specified <code>itemMatchers</code>.  Whilst matching, each traversal of
     * the examined {@link Iterable} will stop as soon as a matching item is found.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar", "baz"), hasItems(endsWith("z"), endsWith("o")))</pre>
     *
     * @param itemMatchers
    the matchers to apply to items provided by the examined {@link Iterable}
     * @see org.hamcrest.core.IsCollectionContaining#hasItems(org.hamcrest.Matcher...)
     */
    public static <T> org.hamcrest.Matcher<java.lang.Iterable<T>> hasItems(org.hamcrest.Matcher<? super T>... itemMatchers) {
        return org.hamcrest.core.IsCollectionContaining.hasItems(itemMatchers);
    }

    /**
     * Creates a matcher for {@link Iterable}s that matches when consecutive passes over the
     * examined {@link Iterable} yield at least one item that is equal to the corresponding
     * item from the specified <code>items</code>.  Whilst matching, each traversal of the
     * examined {@link Iterable} will stop as soon as a matching item is found.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar", "baz"), hasItems("baz", "foo"))</pre>
     *
     * @param items
    the items to compare against the items provided by the examined {@link Iterable}
     * @see org.hamcrest.core.IsCollectionContaining#hasItems(java.lang.Object...)
     */
    public static <T> org.hamcrest.Matcher<java.lang.Iterable<T>> hasItems(T... items) {
        return org.hamcrest.core.IsCollectionContaining.hasItems(items);
    }

    /**
     * Creates a matcher that matches if examined object is <code>null</code>.
     * <p>
     * For example:
     * <pre>assertThat(cheese, is(nullValue())</pre>
     *
     * @see org.hamcrest.core.IsNull#nullValue()
     */
    public static org.hamcrest.Matcher<java.lang.Object> nullValue() {
        return org.hamcrest.core.IsNull.nullValue();
    }

    /**
     * A shortcut to the frequently used <code>not(nullValue())</code>.
     * <p>
     * For example:
     * <pre>assertThat(cheese, is(notNullValue()))</pre>
     * instead of:
     * <pre>assertThat(cheese, is(not(nullValue())))</pre>
     *
     * @see org.hamcrest.core.IsNull#notNullValue()
     */
    public static org.hamcrest.Matcher<java.lang.Object> notNullValue() {
        return org.hamcrest.core.IsNull.notNullValue();
    }

    /**
     * Creates a matcher that matches if examined object is <code>null</code>. Accepts a
     * single dummy argument to facilitate type inference.
     * <p>
     * For example:
     * <pre>assertThat(cheese, is(nullValue(Cheese.class))</pre>
     *
     * @param type
    dummy parameter used to infer the generic type of the returned matcher
     * @see org.hamcrest.core.IsNull#nullValue(java.lang.Class)
     */
    public static <T> org.hamcrest.Matcher<T> nullValue(java.lang.Class<T> type) {
        return org.hamcrest.core.IsNull.nullValue(type);
    }

    /**
     * A shortcut to the frequently used <code>not(nullValue(X.class)). Accepts a
     * single dummy argument to facilitate type inference.</code>.
     * <p>
     * For example:
     * <pre>assertThat(cheese, is(notNullValue(X.class)))</pre>
     * instead of:
     * <pre>assertThat(cheese, is(not(nullValue(X.class))))</pre>
     *
     * @param type
    dummy parameter used to infer the generic type of the returned matcher
     * @see org.hamcrest.core.IsNull#notNullValue(java.lang.Class)
     */
    public static <T> org.hamcrest.Matcher<T> notNullValue(java.lang.Class<T> type) {
        return org.hamcrest.core.IsNull.notNullValue(type);
    }

    /**
     * Creates a matcher that matches only when the examined object is the same instance as
     * the specified target object.
     *
     * @param target
    the target instance against which others should be assessed
     * @see org.hamcrest.core.IsSame#sameInstance(java.lang.Object)
     */
    public static <T> org.hamcrest.Matcher<T> sameInstance(T target) {
        return org.hamcrest.core.IsSame.sameInstance(target);
    }

    /**
     * Creates a matcher that matches only when the examined object is the same instance as
     * the specified target object.
     *
     * @param target
    the target instance against which others should be assessed
     * @see org.hamcrest.core.IsSame#theInstance(java.lang.Object)
     */
    public static <T> org.hamcrest.Matcher<T> theInstance(T target) {
        return org.hamcrest.core.IsSame.theInstance(target);
    }

    /**
     * Creates a matcher that matches if the examined {@link String} contains the specified
     * {@link String} anywhere.
     * <p>
     * For example:
     * <pre>assertThat("myStringOfNote", containsString("ring"))</pre>
     *
     * @param substring
    the substring that the returned matcher will expect to find within any examined string
     * @see org.hamcrest.core.StringContains#containsString(java.lang.String)
     */
    public static org.hamcrest.Matcher<java.lang.String> containsString(java.lang.String substring) {
        return org.hamcrest.core.StringContains.containsString(substring);
    }

    /**
     * Creates a matcher that matches if the examined {@link String} starts with the specified
     * {@link String}.
     * <p>
     * For example:
     * <pre>assertThat("myStringOfNote", startsWith("my"))</pre>
     *
     * @param prefix
     the substring that the returned matcher will expect at the start of any examined string
     * @see org.hamcrest.core.StringStartsWith#startsWith(java.lang.String)
     */
    public static org.hamcrest.Matcher<java.lang.String> startsWith(java.lang.String prefix) {
        return org.hamcrest.core.StringStartsWith.startsWith(prefix);
    }

    /**
     * Creates a matcher that matches if the examined {@link String} ends with the specified
     * {@link String}.
     * <p>
     * For example:
     * <pre>assertThat("myStringOfNote", endsWith("Note"))</pre>
     *
     * @param suffix
     the substring that the returned matcher will expect at the end of any examined string
     * @see org.hamcrest.core.StringEndsWith#endsWith(java.lang.String)
     */
    public static org.hamcrest.Matcher<java.lang.String> endsWith(java.lang.String suffix) {
        return org.hamcrest.core.StringEndsWith.endsWith(suffix);
    }

    /**
     * Creates a matcher that matches arrays whose elements are satisfied by the specified matchers.  Matches
     * positively only if the number of matchers specified is equal to the length of the examined array and
     * each matcher[i] is satisfied by array[i].
     * <p>
     * For example:
     * <pre>assertThat(new Integer[]{1,2,3}, is(array(equalTo(1), equalTo(2), equalTo(3))))</pre>
     *
     * @param elementMatchers
    the matchers that the elements of examined arrays should satisfy
     * @see org.hamcrest.collection.IsArray#array(org.hamcrest.Matcher...)
     */
    public static <T> org.hamcrest.collection.IsArray<T> array(org.hamcrest.Matcher<? super T>... elementMatchers) {
        return org.hamcrest.collection.IsArray.array(elementMatchers);
    }

    /**
     * Creates a matcher for arrays that matches when the examined array contains at least one item
     * that is matched by the specified <code>elementMatcher</code>.  Whilst matching, the traversal
     * of the examined array will stop as soon as a matching element is found.
     * <p>
     * For example:
     * <pre>assertThat(new String[] {"foo", "bar"}, hasItemInArray(startsWith("ba")))</pre>
     *
     * @param elementMatcher
    the matcher to apply to elements in examined arrays
     * @see org.hamcrest.collection.IsArrayContaining#hasItemInArray(org.hamcrest.Matcher)
     */
    public static <T> org.hamcrest.Matcher<T[]> hasItemInArray(org.hamcrest.Matcher<? super T> elementMatcher) {
        return org.hamcrest.collection.IsArrayContaining.hasItemInArray(elementMatcher);
    }

    /**
     * A shortcut to the frequently used <code>hasItemInArray(equalTo(x))</code>.
     * <p>
     * For example:
     * <pre>assertThat(hasItemInArray(x))</pre>
     * instead of:
     * <pre>assertThat(hasItemInArray(equalTo(x)))</pre>
     *
     * @param element
    the element that should be present in examined arrays
     * @see org.hamcrest.collection.IsArrayContaining#hasItemInArray(java.lang.Object)
     */
    public static <T> org.hamcrest.Matcher<T[]> hasItemInArray(T element) {
        return org.hamcrest.collection.IsArrayContaining.hasItemInArray(element);
    }

    /**
     * Creates a matcher for arrays that matcheswhen each item in the examined array is
     * logically equal to the corresponding item in the specified items.  For a positive match,
     * the examined array must be of the same length as the number of specified items.
     * <p>
     * For example:
     * <pre>assertThat(new String[]{"foo", "bar"}, contains("foo", "bar"))</pre>
     *
     * @param items
    the items that must equal the items within an examined array
     * @see org.hamcrest.collection.IsArrayContainingInOrder#arrayContaining(java.lang.Object...)
     */
    public static <E> org.hamcrest.Matcher<E[]> arrayContaining(E... items) {
        return org.hamcrest.collection.IsArrayContainingInOrder.arrayContaining(items);
    }

    /**
     * Creates a matcher for arrays that matches when each item in the examined array satisfies the
     * corresponding matcher in the specified matchers.  For a positive match, the examined array
     * must be of the same length as the number of specified matchers.
     * <p>
     * For example:
     * <pre>assertThat(new String[]{"foo", "bar"}, contains(equalTo("foo"), equalTo("bar")))</pre>
     *
     * @param itemMatchers
    the matchers that must be satisfied by the items in the examined array
     * @see org.hamcrest.collection.IsArrayContainingInOrder#arrayContaining(org.hamcrest.Matcher...)
     */
    public static <E> org.hamcrest.Matcher<E[]> arrayContaining(org.hamcrest.Matcher<? super E>... itemMatchers) {
        return org.hamcrest.collection.IsArrayContainingInOrder.arrayContaining(itemMatchers);
    }

    /**
     * Creates a matcher for arrays that matches when each item in the examined array satisfies the
     * corresponding matcher in the specified list of matchers.  For a positive match, the examined array
     * must be of the same length as the specified list of matchers.
     * <p>
     * For example:
     * <pre>assertThat(new String[]{"foo", "bar"}, contains(Arrays.asList(equalTo("foo"), equalTo("bar"))))</pre>
     *
     * @param itemMatchers
    a list of matchers, each of which must be satisfied by the corresponding item in an examined array
     * @see org.hamcrest.collection.IsArrayContainingInOrder#arrayContaining(java.util.List)
     */
    public static <E> org.hamcrest.Matcher<E[]> arrayContaining(java.util.List<org.hamcrest.Matcher<? super E>> itemMatchers) {
        return org.hamcrest.collection.IsArrayContainingInOrder.arrayContaining(itemMatchers);
    }

    /**
     * Creates an order agnostic matcher for arrays that matches when each item in the
     * examined array satisfies one matcher anywhere in the specified matchers.
     * For a positive match, the examined array must be of the same length as the number of
     * specified matchers.
     * <p>
     * N.B. each of the specified matchers will only be used once during a given examination, so be
     * careful when specifying matchers that may be satisfied by more than one entry in an examined
     * array.
     * <p>
     * For example:
     * <pre>assertThat(new String[]{"foo", "bar"}, arrayContainingInAnyOrder(equalTo("bar"), equalTo("foo")))</pre>
     *
     * @param itemMatchers
    a list of matchers, each of which must be satisfied by an entry in an examined array
     * @see org.hamcrest.collection.IsArrayContainingInAnyOrder#arrayContainingInAnyOrder(org.hamcrest.Matcher...)
     */
    public static <E> org.hamcrest.Matcher<E[]> arrayContainingInAnyOrder(org.hamcrest.Matcher<? super E>... itemMatchers) {
        return org.hamcrest.collection.IsArrayContainingInAnyOrder.arrayContainingInAnyOrder(itemMatchers);
    }

    /**
     * Creates an order agnostic matcher for arrays that matches when each item in the
     * examined array satisfies one matcher anywhere in the specified collection of matchers.
     * For a positive match, the examined array must be of the same length as the specified collection
     * of matchers.
     * <p>
     * N.B. each matcher in the specified collection will only be used once during a given
     * examination, so be careful when specifying matchers that may be satisfied by more than
     * one entry in an examined array.
     * <p>
     * For example:
     * <pre>assertThat(new String[]{"foo", "bar"}, arrayContainingInAnyOrder(Arrays.asList(equalTo("bar"), equalTo("foo"))))</pre>
     *
     * @param itemMatchers
    a list of matchers, each of which must be satisfied by an item provided by an examined array
     * @see org.hamcrest.collection.IsArrayContainingInAnyOrder#arrayContainingInAnyOrder(java.util.Collection)
     */
    public static <E> org.hamcrest.Matcher<E[]> arrayContainingInAnyOrder(java.util.Collection<org.hamcrest.Matcher<? super E>> itemMatchers) {
        return org.hamcrest.collection.IsArrayContainingInAnyOrder.arrayContainingInAnyOrder(itemMatchers);
    }

    /**
     * Creates an order agnostic matcher for arrays that matches when each item in the
     * examined array is logically equal to one item anywhere in the specified items.
     * For a positive match, the examined array must be of the same length as the number of
     * specified items.
     * <p>
     * N.B. each of the specified items will only be used once during a given examination, so be
     * careful when specifying items that may be equal to more than one entry in an examined
     * array.
     * <p>
     * For example:
     * <pre>assertThat(new String[]{"foo", "bar"}, containsInAnyOrder("bar", "foo"))</pre>
     *
     * @param items
    the items that must equal the entries of an examined array, in any order
     * @see org.hamcrest.collection.IsArrayContainingInAnyOrder#arrayContainingInAnyOrder(java.lang.Object...)
     */
    public static <E> org.hamcrest.Matcher<E[]> arrayContainingInAnyOrder(E... items) {
        return org.hamcrest.collection.IsArrayContainingInAnyOrder.arrayContainingInAnyOrder(items);
    }

    /**
     * Creates a matcher for arrays that matches when the <code>length</code> of the array
     * satisfies the specified matcher.
     * <p>
     * For example:
     * <pre>assertThat(new String[]{"foo", "bar"}, arrayWithSize(equalTo(2)))</pre>
     *
     * @param sizeMatcher
    a matcher for the length of an examined array
     * @see org.hamcrest.collection.IsArrayWithSize#arrayWithSize(org.hamcrest.Matcher)
     */
    public static <E> org.hamcrest.Matcher<E[]> arrayWithSize(org.hamcrest.Matcher<? super java.lang.Integer> sizeMatcher) {
        return org.hamcrest.collection.IsArrayWithSize.arrayWithSize(sizeMatcher);
    }

    /**
     * Creates a matcher for arrays that matches when the <code>length</code> of the array
     * equals the specified <code>size</code>.
     * <p>
     * For example:
     * <pre>assertThat(new String[]{"foo", "bar"}, arrayWithSize(2))</pre>
     *
     * @param size
    the length that an examined array must have for a positive match
     * @see org.hamcrest.collection.IsArrayWithSize#arrayWithSize(int)
     */
    public static <E> org.hamcrest.Matcher<E[]> arrayWithSize(int size) {
        return org.hamcrest.collection.IsArrayWithSize.arrayWithSize(size);
    }

    /**
     * Creates a matcher for arrays that matches when the <code>length</code> of the array
     * is zero.
     * <p>
     * For example:
     * <pre>assertThat(new String[0], emptyArray())</pre>
     *
     * @see org.hamcrest.collection.IsArrayWithSize#emptyArray()
     */
    public static <E> org.hamcrest.Matcher<E[]> emptyArray() {
        return org.hamcrest.collection.IsArrayWithSize.emptyArray();
    }

    /**
     * Creates a matcher for {@link java.util.Collection}s that matches when the <code>size()</code> method returns
     * a value that satisfies the specified matcher.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar"), hasSize(equalTo(2)))</pre>
     *
     * @param sizeMatcher
    a matcher for the size of an examined {@link java.util.Collection}
     * @see org.hamcrest.collection.IsCollectionWithSize#hasSize(org.hamcrest.Matcher)
     */
    public static <E> org.hamcrest.Matcher<java.util.Collection<? extends E>> hasSize(org.hamcrest.Matcher<? super java.lang.Integer> sizeMatcher) {
        return org.hamcrest.collection.IsCollectionWithSize.hasSize(sizeMatcher);
    }

    /**
     * Creates a matcher for {@link java.util.Collection}s that matches when the <code>size()</code> method returns
     * a value equal to the specified <code>size</code>.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar"), hasSize(2))</pre>
     *
     * @param size
    the expected size of an examined {@link java.util.Collection}
     * @see org.hamcrest.collection.IsCollectionWithSize#hasSize(int)
     */
    public static <E> org.hamcrest.Matcher<java.util.Collection<? extends E>> hasSize(int size) {
        return org.hamcrest.collection.IsCollectionWithSize.hasSize(size);
    }

    /**
     * Creates a matcher for {@link java.util.Collection}s matching examined collections whose <code>isEmpty</code>
     * method returns <code>true</code>.
     * <p>
     * For example:
     * <pre>assertThat(new ArrayList&lt;String&gt;(), is(empty()))</pre>
     *
     * @see org.hamcrest.collection.IsEmptyCollection#empty()
     */
    public static <E> org.hamcrest.Matcher<java.util.Collection<? extends E>> empty() {
        return org.hamcrest.collection.IsEmptyCollection.empty();
    }

    /**
     * Creates a matcher for {@link java.util.Collection}s matching examined collections whose <code>isEmpty</code>
     * method returns <code>true</code>.
     * <p>
     * For example:
     * <pre>assertThat(new ArrayList&lt;String&gt;(), is(emptyCollectionOf(String.class)))</pre>
     *
     * @param type
    the type of the collection's content
     * @see org.hamcrest.collection.IsEmptyCollection#emptyCollectionOf(java.lang.Class)
     */
    public static <E> org.hamcrest.Matcher<java.util.Collection<E>> emptyCollectionOf(java.lang.Class<E> type) {
        return org.hamcrest.collection.IsEmptyCollection.emptyCollectionOf(type);
    }

    /**
     * Creates a matcher for {@link Iterable}s matching examined iterables that yield no items.
     * <p>
     * For example:
     * <pre>assertThat(new ArrayList&lt;String&gt;(), is(emptyIterable()))</pre>
     *
     * @see org.hamcrest.collection.IsEmptyIterable#emptyIterable()
     */
    public static <E> org.hamcrest.Matcher<java.lang.Iterable<? extends E>> emptyIterable() {
        return org.hamcrest.collection.IsEmptyIterable.emptyIterable();
    }

    /**
     * Creates a matcher for {@link Iterable}s matching examined iterables that yield no items.
     * <p>
     * For example:
     * <pre>assertThat(new ArrayList&lt;String&gt;(), is(emptyIterableOf(String.class)))</pre>
     *
     * @param type
    the type of the iterable's content
     * @see org.hamcrest.collection.IsEmptyIterable#emptyIterableOf(java.lang.Class)
     */
    public static <E> org.hamcrest.Matcher<java.lang.Iterable<E>> emptyIterableOf(java.lang.Class<E> type) {
        return org.hamcrest.collection.IsEmptyIterable.emptyIterableOf(type);
    }

    /**
     * Creates a matcher for {@link Iterable}s that matches when a single pass over the
     * examined {@link Iterable} yields a series of items, each logically equal to the
     * corresponding item in the specified items.  For a positive match, the examined iterable
     * must be of the same length as the number of specified items.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar"), contains("foo", "bar"))</pre>
     *
     * @param items
    the items that must equal the items provided by an examined {@link Iterable}
     * @see org.hamcrest.collection.IsIterableContainingInOrder#contains(java.lang.Object...)
     */
    public static <E> org.hamcrest.Matcher<java.lang.Iterable<? extends E>> contains(E... items) {
        return org.hamcrest.collection.IsIterableContainingInOrder.contains(items);
    }

    /**
     * Creates a matcher for {@link Iterable}s that matches when a single pass over the
     * examined {@link Iterable} yields a single item that satisfies the specified matcher.
     * For a positive match, the examined iterable must only yield one item.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo"), contains(equalTo("foo")))</pre>
     *
     * @param itemMatcher
    the matcher that must be satisfied by the single item provided by an
    examined {@link Iterable}
     * @see org.hamcrest.collection.IsIterableContainingInOrder#contains(org.hamcrest.Matcher)
     */
    public static <E> org.hamcrest.Matcher<java.lang.Iterable<? extends E>> contains(org.hamcrest.Matcher<? super E> itemMatcher) {
        return org.hamcrest.collection.IsIterableContainingInOrder.contains(itemMatcher);
    }

    /**
     * Creates a matcher for {@link Iterable}s that matches when a single pass over the
     * examined {@link Iterable} yields a series of items, each satisfying the corresponding
     * matcher in the specified matchers.  For a positive match, the examined iterable
     * must be of the same length as the number of specified matchers.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar"), contains(equalTo("foo"), equalTo("bar")))</pre>
     *
     * @param itemMatchers
    the matchers that must be satisfied by the items provided by an examined {@link Iterable}
     * @see org.hamcrest.collection.IsIterableContainingInOrder#contains(org.hamcrest.Matcher...)
     */
    public static <E> org.hamcrest.Matcher<java.lang.Iterable<? extends E>> contains(org.hamcrest.Matcher<? super E>... itemMatchers) {
        return org.hamcrest.collection.IsIterableContainingInOrder.contains(itemMatchers);
    }

    /**
     * Creates a matcher for {@link Iterable}s that matches when a single pass over the
     * examined {@link Iterable} yields a series of items, each satisfying the corresponding
     * matcher in the specified list of matchers.  For a positive match, the examined iterable
     * must be of the same length as the specified list of matchers.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar"), contains(Arrays.asList(equalTo("foo"), equalTo("bar"))))</pre>
     *
     * @param itemMatchers
    a list of matchers, each of which must be satisfied by the corresponding item provided by
    an examined {@link Iterable}
     * @see org.hamcrest.collection.IsIterableContainingInOrder#contains(java.util.List)
     */
    public static <E> org.hamcrest.Matcher<java.lang.Iterable<? extends E>> contains(java.util.List<org.hamcrest.Matcher<? super E>> itemMatchers) {
        return org.hamcrest.collection.IsIterableContainingInOrder.contains(itemMatchers);
    }

    /**
     * Creates a matcher for {@link Iterable}s that matches when a single pass over the
     * examined {@link Iterable} yields a single item that satisfies the specified matcher.
     * For a positive match, the examined iterable must only yield one item.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo"), containsInAnyOrder(equalTo("foo")))</pre>
     *
     * @deprecated use contains(Matcher<? super E> itemMatcher) instead
     * @param itemMatcher
    the matcher that must be satisfied by the single item provided by an
    examined {@link Iterable}
     * @see org.hamcrest.collection.IsIterableContainingInAnyOrder#containsInAnyOrder(org.hamcrest.Matcher)
     */
    public static <E> org.hamcrest.Matcher<java.lang.Iterable<? extends E>> containsInAnyOrder(org.hamcrest.Matcher<? super E> itemMatcher) {
        return org.hamcrest.collection.IsIterableContainingInAnyOrder.containsInAnyOrder(itemMatcher);
    }

    /**
     * Creates an order agnostic matcher for {@link Iterable}s that matches when a single pass over
     * the examined {@link Iterable} yields a series of items, each satisfying one matcher anywhere
     * in the specified matchers.  For a positive match, the examined iterable must be of the same
     * length as the number of specified matchers.
     * <p>
     * N.B. each of the specified matchers will only be used once during a given examination, so be
     * careful when specifying matchers that may be satisfied by more than one entry in an examined
     * iterable.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar"), containsInAnyOrder(equalTo("bar"), equalTo("foo")))</pre>
     *
     * @param itemMatchers
    a list of matchers, each of which must be satisfied by an item provided by an examined {@link Iterable}
     * @see org.hamcrest.collection.IsIterableContainingInAnyOrder#containsInAnyOrder(org.hamcrest.Matcher...)
     */
    public static <T> org.hamcrest.Matcher<java.lang.Iterable<? extends T>> containsInAnyOrder(org.hamcrest.Matcher<? super T>... itemMatchers) {
        return org.hamcrest.collection.IsIterableContainingInAnyOrder.containsInAnyOrder(itemMatchers);
    }

    /**
     * Creates an order agnostic matcher for {@link Iterable}s that matches when a single pass over
     * the examined {@link Iterable} yields a series of items, each logically equal to one item
     * anywhere in the specified items. For a positive match, the examined iterable
     * must be of the same length as the number of specified items.
     * <p>
     * N.B. each of the specified items will only be used once during a given examination, so be
     * careful when specifying items that may be equal to more than one entry in an examined
     * iterable.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar"), containsInAnyOrder("bar", "foo"))</pre>
     *
     * @param items
    the items that must equal the items provided by an examined {@link Iterable} in any order
     * @see org.hamcrest.collection.IsIterableContainingInAnyOrder#containsInAnyOrder(java.lang.Object...)
     */
    public static <T> org.hamcrest.Matcher<java.lang.Iterable<? extends T>> containsInAnyOrder(T... items) {
        return org.hamcrest.collection.IsIterableContainingInAnyOrder.containsInAnyOrder(items);
    }

    /**
     * Creates an order agnostic matcher for {@link Iterable}s that matches when a single pass over
     * the examined {@link Iterable} yields a series of items, each satisfying one matcher anywhere
     * in the specified collection of matchers.  For a positive match, the examined iterable
     * must be of the same length as the specified collection of matchers.
     * <p>
     * N.B. each matcher in the specified collection will only be used once during a given
     * examination, so be careful when specifying matchers that may be satisfied by more than
     * one entry in an examined iterable.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar"), containsInAnyOrder(Arrays.asList(equalTo("bar"), equalTo("foo"))))</pre>
     *
     * @param itemMatchers
    a list of matchers, each of which must be satisfied by an item provided by an examined {@link Iterable}
     * @see org.hamcrest.collection.IsIterableContainingInAnyOrder#containsInAnyOrder(java.util.Collection)
     */
    public static <T> org.hamcrest.Matcher<java.lang.Iterable<? extends T>> containsInAnyOrder(java.util.Collection<org.hamcrest.Matcher<? super T>> itemMatchers) {
        return org.hamcrest.collection.IsIterableContainingInAnyOrder.containsInAnyOrder(itemMatchers);
    }

    /**
     * Creates a matcher for {@link Iterable}s that matches when a single pass over the
     * examined {@link Iterable} yields an item count that satisfies the specified
     * matcher.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar"), iterableWithSize(equalTo(2)))</pre>
     *
     * @param sizeMatcher
    a matcher for the number of items that should be yielded by an examined {@link Iterable}
     * @see org.hamcrest.collection.IsIterableWithSize#iterableWithSize(org.hamcrest.Matcher)
     */
    public static <E> org.hamcrest.Matcher<java.lang.Iterable<E>> iterableWithSize(org.hamcrest.Matcher<? super java.lang.Integer> sizeMatcher) {
        return org.hamcrest.collection.IsIterableWithSize.iterableWithSize(sizeMatcher);
    }

    /**
     * Creates a matcher for {@link Iterable}s that matches when a single pass over the
     * examined {@link Iterable} yields an item count that is equal to the specified
     * <code>size</code> argument.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar"), iterableWithSize(2))</pre>
     *
     * @param size
    the number of items that should be yielded by an examined {@link Iterable}
     * @see org.hamcrest.collection.IsIterableWithSize#iterableWithSize(int)
     */
    public static <E> org.hamcrest.Matcher<java.lang.Iterable<E>> iterableWithSize(int size) {
        return org.hamcrest.collection.IsIterableWithSize.iterableWithSize(size);
    }

    /**
     * Creates a matcher for {@link java.util.Map}s matching when the examined {@link java.util.Map} contains
     * at least one entry whose key satisfies the specified <code>keyMatcher</code> <b>and</b> whose
     * value satisfies the specified <code>valueMatcher</code>.
     * <p>
     * For example:
     * <pre>assertThat(myMap, hasEntry(equalTo("bar"), equalTo("foo")))</pre>
     *
     * @param keyMatcher
    the key matcher that, in combination with the valueMatcher, must be satisfied by at least one entry
     * @param valueMatcher
    the value matcher that, in combination with the keyMatcher, must be satisfied by at least one entry
     * @see org.hamcrest.collection.IsMapContaining#hasEntry(org.hamcrest.Matcher,org.hamcrest.Matcher)
     */
    public static <K,V> org.hamcrest.Matcher<java.util.Map<? extends K,? extends V>> hasEntry(org.hamcrest.Matcher<? super K> keyMatcher, org.hamcrest.Matcher<? super V> valueMatcher) {
        return org.hamcrest.collection.IsMapContaining.hasEntry(keyMatcher, valueMatcher);
    }

    /**
     * Creates a matcher for {@link java.util.Map}s matching when the examined {@link java.util.Map} contains
     * at least one entry whose key equals the specified <code>key</code> <b>and</b> whose value equals the
     * specified <code>value</code>.
     * <p>
     * For example:
     * <pre>assertThat(myMap, hasEntry("bar", "foo"))</pre>
     *
     * @param key
    the key that, in combination with the value, must be describe at least one entry
     * @param value
    the value that, in combination with the key, must be describe at least one entry
     * @see org.hamcrest.collection.IsMapContaining#hasEntry(java.lang.Object,java.lang.Object)
     */
    public static <K,V> org.hamcrest.Matcher<java.util.Map<? extends K,? extends V>> hasEntry(K key, V value) {
        return org.hamcrest.collection.IsMapContaining.hasEntry(key, value);
    }

    /**
     * Creates a matcher for {@link java.util.Map}s matching when the examined {@link java.util.Map} contains
     * at least one key that satisfies the specified matcher.
     * <p>
     * For example:
     * <pre>assertThat(myMap, hasKey(equalTo("bar")))</pre>
     *
     * @param keyMatcher
    the matcher that must be satisfied by at least one key
     * @see org.hamcrest.collection.IsMapContaining#hasKey(org.hamcrest.Matcher)
     */
    public static <K> org.hamcrest.Matcher<java.util.Map<? extends K,?>> hasKey(org.hamcrest.Matcher<? super K> keyMatcher) {
        return org.hamcrest.collection.IsMapContaining.hasKey(keyMatcher);
    }

    /**
     * Creates a matcher for {@link java.util.Map}s matching when the examined {@link java.util.Map} contains
     * at least one key that is equal to the specified key.
     * <p>
     * For example:
     * <pre>assertThat(myMap, hasKey("bar"))</pre>
     *
     * @param key
    the key that satisfying maps must contain
     * @see org.hamcrest.collection.IsMapContaining#hasKey(java.lang.Object)
     */
    public static <K> org.hamcrest.Matcher<java.util.Map<? extends K,?>> hasKey(K key) {
        return org.hamcrest.collection.IsMapContaining.hasKey(key);
    }

    /**
     * Creates a matcher for {@link java.util.Map}s matching when the examined {@link java.util.Map} contains
     * at least one value that satisfies the specified valueMatcher.
     * <p>
     * For example:
     * <pre>assertThat(myMap, hasValue(equalTo("foo")))</pre>
     *
     * @param valueMatcher
    the matcher that must be satisfied by at least one value
     * @see org.hamcrest.collection.IsMapContaining#hasValue(org.hamcrest.Matcher)
     */
    public static <V> org.hamcrest.Matcher<java.util.Map<?,? extends V>> hasValue(org.hamcrest.Matcher<? super V> valueMatcher) {
        return org.hamcrest.collection.IsMapContaining.hasValue(valueMatcher);
    }

    /**
     * Creates a matcher for {@link java.util.Map}s matching when the examined {@link java.util.Map} contains
     * at least one value that is equal to the specified value.
     * <p>
     * For example:
     * <pre>assertThat(myMap, hasValue("foo"))</pre>
     *
     * @param value
    the value that satisfying maps must contain
     * @see org.hamcrest.collection.IsMapContaining#hasValue(java.lang.Object)
     */
    public static <V> org.hamcrest.Matcher<java.util.Map<?,? extends V>> hasValue(V value) {
        return org.hamcrest.collection.IsMapContaining.hasValue(value);
    }

    /**
     * Creates a matcher that matches when the examined object is found within the
     * specified collection.
     * <p>
     * For example:
     * <pre>assertThat("foo", isIn(Arrays.asList("bar", "foo")))</pre>
     *
     * @param collection
    the collection in which matching items must be found
     * @see org.hamcrest.collection.IsIn#isIn(java.util.Collection)
     */
    public static <T> org.hamcrest.Matcher<T> isIn(java.util.Collection<T> collection) {
        return org.hamcrest.collection.IsIn.isIn(collection);
    }

    /**
     * Creates a matcher that matches when the examined object is found within the
     * specified array.
     * <p>
     * For example:
     * <pre>assertThat("foo", isIn(new String[]{"bar", "foo"}))</pre>
     *
     * @param elements
    the array in which matching items must be found
     * @see org.hamcrest.collection.IsIn#isIn(java.lang.Object[])
     */
    public static <T> org.hamcrest.Matcher<T> isIn(T[] elements) {
        return org.hamcrest.collection.IsIn.isIn(elements);
    }

    /**
     * Creates a matcher that matches when the examined object is equal to one of the
     * specified elements.
     * <p>
     * For example:
     * <pre>assertThat("foo", isIn("bar", "foo"))</pre>
     *
     * @param elements
    the elements amongst which matching items will be found
     * @see org.hamcrest.collection.IsIn#isOneOf(java.lang.Object...)
     */
    public static <T> org.hamcrest.Matcher<T> isOneOf(T... elements) {
        return org.hamcrest.collection.IsIn.isOneOf(elements);
    }

    /**
     * Creates a matcher of {@link Double}s that matches when an examined double is equal
     * to the specified <code>operand</code>, within a range of +/- <code>error</code>.
     * <p>
     * For example:
     * <pre>assertThat(1.03, is(closeTo(1.0, 0.03)))</pre>
     *
     * @param operand
    the expected value of matching doubles
     * @param error
    the delta (+/-) within which matches will be allowed
     * @see org.hamcrest.number.IsCloseTo#closeTo(double,double)
     */
    public static org.hamcrest.Matcher<java.lang.Double> closeTo(double operand, double error) {
        return org.hamcrest.number.IsCloseTo.closeTo(operand, error);
    }

    /**
     * Creates a matcher of {@link java.math.BigDecimal}s that matches when an examined BigDecimal is equal
     * to the specified <code>operand</code>, within a range of +/- <code>error</code>. The comparison for equality
     * is done by BigDecimals {@link java.math.BigDecimal#compareTo(java.math.BigDecimal)} method.
     * <p>
     * For example:
     * <pre>assertThat(new BigDecimal("1.03"), is(closeTo(new BigDecimal("1.0"), new BigDecimal("0.03"))))</pre>
     *
     * @param operand
    the expected value of matching BigDecimals
     * @param error
    the delta (+/-) within which matches will be allowed
     * @see org.hamcrest.number.BigDecimalCloseTo#closeTo(java.math.BigDecimal,java.math.BigDecimal)
     */
    public static org.hamcrest.Matcher<java.math.BigDecimal> closeTo(java.math.BigDecimal operand, java.math.BigDecimal error) {
        return org.hamcrest.number.BigDecimalCloseTo.closeTo(operand, error);
    }

    /**
     * Creates a matcher of {@link Comparable} object that matches when the examined object is
     * equal to the specified value, as reported by the <code>compareTo</code> method of the
     * <b>examined</b> object.
     * <p>
     * For example:
     * <pre>assertThat(1, comparesEqualTo(1))</pre>
     *
     * @param value
    the value which, when passed to the compareTo method of the examined object, should return zero
     * @see org.hamcrest.number.OrderingComparison#comparesEqualTo(java.lang.Comparable)
     */
    public static <T extends Comparable<T>> org.hamcrest.Matcher<T> comparesEqualTo(T value) {
        return org.hamcrest.number.OrderingComparison.comparesEqualTo(value);
    }

    /**
     * Creates a matcher of {@link Comparable} object that matches when the examined object is
     * greater than the specified value, as reported by the <code>compareTo</code> method of the
     * <b>examined</b> object.
     * <p>
     * For example:
     * <pre>assertThat(2, greaterThan(1))</pre>
     *
     * @param value
    the value which, when passed to the compareTo method of the examined object, should return greater
    than zero
     * @see org.hamcrest.number.OrderingComparison#greaterThan(java.lang.Comparable)
     */
    public static <T extends Comparable<T>> org.hamcrest.Matcher<T> greaterThan(T value) {
        return org.hamcrest.number.OrderingComparison.greaterThan(value);
    }

    /**
     * Creates a matcher of {@link Comparable} object that matches when the examined object is
     * greater than or equal to the specified value, as reported by the <code>compareTo</code> method
     * of the <b>examined</b> object.
     * <p>
     * For example:
     * <pre>assertThat(1, greaterThanOrEqualTo(1))</pre>
     *
     * @param value
    the value which, when passed to the compareTo method of the examined object, should return greater
    than or equal to zero
     * @see org.hamcrest.number.OrderingComparison#greaterThanOrEqualTo(java.lang.Comparable)
     */
    public static <T extends Comparable<T>> org.hamcrest.Matcher<T> greaterThanOrEqualTo(T value) {
        return org.hamcrest.number.OrderingComparison.greaterThanOrEqualTo(value);
    }

    /**
     * Creates a matcher of {@link Comparable} object that matches when the examined object is
     * less than the specified value, as reported by the <code>compareTo</code> method of the
     * <b>examined</b> object.
     * <p>
     * For example:
     * <pre>assertThat(1, lessThan(2))</pre>
     *
     * @param value
    the value which, when passed to the compareTo method of the examined object, should return less
    than zero
     * @see org.hamcrest.number.OrderingComparison#lessThan(java.lang.Comparable)
     */
    public static <T extends Comparable<T>> org.hamcrest.Matcher<T> lessThan(T value) {
        return org.hamcrest.number.OrderingComparison.lessThan(value);
    }

    /**
     * Creates a matcher of {@link Comparable} object that matches when the examined object is
     * less than or equal to the specified value, as reported by the <code>compareTo</code> method
     * of the <b>examined</b> object.
     * <p>
     * For example:
     * <pre>assertThat(1, lessThanOrEqualTo(1))</pre>
     *
     * @param value
    the value which, when passed to the compareTo method of the examined object, should return less
    than or equal to zero
     * @see org.hamcrest.number.OrderingComparison#lessThanOrEqualTo(java.lang.Comparable)
     */
    public static <T extends Comparable<T>> org.hamcrest.Matcher<T> lessThanOrEqualTo(T value) {
        return org.hamcrest.number.OrderingComparison.lessThanOrEqualTo(value);
    }

    /**
     * Creates a matcher of {@link String} that matches when the examined string is equal to
     * the specified expectedString, ignoring case.
     * <p>
     * For example:
     * <pre>assertThat("Foo", equalToIgnoringCase("FOO"))</pre>
     *
     * @param expectedString
    the expected value of matched strings
     * @see org.hamcrest.text.IsEqualIgnoringCase#equalToIgnoringCase(java.lang.String)
     */
    public static org.hamcrest.Matcher<java.lang.String> equalToIgnoringCase(java.lang.String expectedString) {
        return org.hamcrest.text.IsEqualIgnoringCase.equalToIgnoringCase(expectedString);
    }

    /**
     * Creates a matcher of {@link String} that matches when the examined string is equal to
     * the specified expectedString, when whitespace differences are (mostly) ignored.  To be
     * exact, the following whitespace rules are applied:
     * <ul>
     *   <li>all leading and trailing whitespace of both the expectedString and the examined string are ignored</li>
     *   <li>any remaining whitespace, appearing within either string, is collapsed to a single space before comparison</li>
     * </ul>
     * <p>
     * For example:
     * <pre>assertThat("   my\tfoo  bar ", equalToIgnoringWhiteSpace(" my  foo bar"))</pre>
     *
     * @param expectedString
    the expected value of matched strings
     * @see org.hamcrest.text.IsEqualIgnoringWhiteSpace#equalToIgnoringWhiteSpace(java.lang.String)
     */
    public static org.hamcrest.Matcher<java.lang.String> equalToIgnoringWhiteSpace(java.lang.String expectedString) {
        return org.hamcrest.text.IsEqualIgnoringWhiteSpace.equalToIgnoringWhiteSpace(expectedString);
    }

    /**
     * Creates a matcher of {@link String} that matches when the examined string has zero length.
     * <p>
     * For example:
     * <pre>assertThat("", isEmptyString())</pre>
     *
     * @see org.hamcrest.text.IsEmptyString#isEmptyString()
     */
    public static org.hamcrest.Matcher<java.lang.String> isEmptyString() {
        return org.hamcrest.text.IsEmptyString.isEmptyString();
    }

    /**
     * Creates a matcher of {@link String} that matches when the examined string is <code>null</code>, or
     * has zero length.
     * <p>
     * For example:
     * <pre>assertThat(((String)null), isEmptyString())</pre>
     *
     * @see org.hamcrest.text.IsEmptyString#isEmptyOrNullString()
     */
    public static org.hamcrest.Matcher<java.lang.String> isEmptyOrNullString() {
        return org.hamcrest.text.IsEmptyString.isEmptyOrNullString();
    }

    /**
     * Creates a matcher of {@link String} that matches when the examined string contains all of
     * the specified substrings, regardless of the order of their appearance.
     * <p>
     * For example:
     * <pre>assertThat("myfoobarbaz", stringContainsInOrder(Arrays.asList("bar", "foo")))</pre>
     *
     * @param substrings
    the substrings that must be contained within matching strings
     * @see org.hamcrest.text.StringContainsInOrder#stringContainsInOrder(java.lang.Iterable)
     */
    public static org.hamcrest.Matcher<java.lang.String> stringContainsInOrder(java.lang.Iterable<java.lang.String> substrings) {
        return org.hamcrest.text.StringContainsInOrder.stringContainsInOrder(substrings);
    }

    /**
     * Creates a matcher that matches any examined object whose <code>toString</code> method
     * returns a value that satisfies the specified matcher.
     * <p>
     * For example:
     * <pre>assertThat(true, hasToString(equalTo("TRUE")))</pre>
     *
     * @param toStringMatcher
    the matcher used to verify the toString result
     * @see org.hamcrest.object.HasToString#hasToString(org.hamcrest.Matcher)
     */
    public static <T> org.hamcrest.Matcher<T> hasToString(org.hamcrest.Matcher<? super java.lang.String> toStringMatcher) {
        return org.hamcrest.object.HasToString.hasToString(toStringMatcher);
    }

    /**
     * Creates a matcher that matches any examined object whose <code>toString</code> method
     * returns a value equalTo the specified string.
     * <p>
     * For example:
     * <pre>assertThat(true, hasToString("TRUE"))</pre>
     *
     * @param expectedToString
    the expected toString result
     * @see org.hamcrest.object.HasToString#hasToString(java.lang.String)
     */
    public static <T> org.hamcrest.Matcher<T> hasToString(java.lang.String expectedToString) {
        return org.hamcrest.object.HasToString.hasToString(expectedToString);
    }

    /**
     * Creates a matcher of {@link Class} that matches when the specified baseType is
     * assignable from the examined class.
     * <p>
     * For example:
     * <pre>assertThat(Integer.class, typeCompatibleWith(Number.class))</pre>
     *
     * @param baseType
    the base class to examine classes against
     * @see org.hamcrest.object.IsCompatibleType#typeCompatibleWith(java.lang.Class)
     */
    public static <T> org.hamcrest.Matcher<java.lang.Class<?>> typeCompatibleWith(java.lang.Class<T> baseType) {
        return org.hamcrest.object.IsCompatibleType.typeCompatibleWith(baseType);
    }

    /**
     * Creates a matcher of {@link java.util.EventObject} that matches any object
     * derived from <var>eventClass</var> announced by <var>source</var>.
     * </p>
     * For example:
     * <pre>assertThat(myEvent, is(eventFrom(PropertyChangeEvent.class, myBean)))</pre>
     *
     * @param eventClass
    the class of the event to match on
     * @param source
    the source of the event
     * @see org.hamcrest.object.IsEventFrom#eventFrom(java.lang.Class,java.lang.Object)
     */
    public static org.hamcrest.Matcher<java.util.EventObject> eventFrom(java.lang.Class<? extends java.util.EventObject> eventClass, java.lang.Object source) {
        return org.hamcrest.object.IsEventFrom.eventFrom(eventClass, source);
    }

    /**
     * Creates a matcher of {@link java.util.EventObject} that matches any EventObject
     * announced by <var>source</var>.
     * </p>
     * For example:
     * <pre>assertThat(myEvent, is(eventFrom(myBean)))</pre>
     *
     * @param source
    the source of the event
     * @see org.hamcrest.object.IsEventFrom#eventFrom(java.lang.Object)
     */
    public static org.hamcrest.Matcher<java.util.EventObject> eventFrom(java.lang.Object source) {
        return org.hamcrest.object.IsEventFrom.eventFrom(source);
    }

    /**
     * Creates a matcher that matches when the examined object has a JavaBean property
     * with the specified name.
     * <p>
     * For example:
     * <pre>assertThat(myBean, hasProperty("foo"))</pre>
     *
     * @param propertyName
    the name of the JavaBean property that examined beans should possess
     * @see org.hamcrest.beans.HasProperty#hasProperty(java.lang.String)
     */
    public static <T> org.hamcrest.Matcher<T> hasProperty(java.lang.String propertyName) {
        return org.hamcrest.beans.HasProperty.hasProperty(propertyName);
    }

    /**
     * Creates a matcher that matches when the examined object has a JavaBean property
     * with the specified name whose value satisfies the specified matcher.
     * <p>
     * For example:
     * <pre>assertThat(myBean, hasProperty("foo", equalTo("bar"))</pre>
     *
     * @param propertyName
    the name of the JavaBean property that examined beans should possess
     * @param valueMatcher
    a matcher for the value of the specified property of the examined bean
     * @see org.hamcrest.beans.HasPropertyWithValue#hasProperty(java.lang.String,org.hamcrest.Matcher)
     */
    public static <T> org.hamcrest.Matcher<T> hasProperty(java.lang.String propertyName, org.hamcrest.Matcher<?> valueMatcher) {
        return org.hamcrest.beans.HasPropertyWithValue.hasProperty(propertyName, valueMatcher);
    }

    /**
     * Creates a matcher that matches when the examined object has values for all of
     * its JavaBean properties that are equal to the corresponding values of the
     * specified bean.
     * <p>
     * For example:
     * <pre>assertThat(myBean, samePropertyValuesAs(myExpectedBean))</pre>
     *
     * @param expectedBean
    the bean against which examined beans are compared
     * @see org.hamcrest.beans.SamePropertyValuesAs#samePropertyValuesAs(java.lang.Object)
     */
    public static <T> org.hamcrest.Matcher<T> samePropertyValuesAs(T expectedBean) {
        return org.hamcrest.beans.SamePropertyValuesAs.samePropertyValuesAs(expectedBean);
    }

    /**
     * Creates a matcher of {@link org.w3c.dom.Node}s that matches when the examined node has a value at the
     * specified <code>xPath</code> that satisfies the specified <code>valueMatcher</code>.
     * <p>
     * For example:
     * <pre>assertThat(xml, hasXPath("/root/something[2]/cheese", equalTo("Cheddar")))</pre>
     *
     * @param xPath
    the target xpath
     * @param valueMatcher
    matcher for the value at the specified xpath
     * @see org.hamcrest.xml.HasXPath#hasXPath(java.lang.String,org.hamcrest.Matcher)
     */
    public static org.hamcrest.Matcher<org.w3c.dom.Node> hasXPath(java.lang.String xPath, org.hamcrest.Matcher<java.lang.String> valueMatcher) {
        return org.hamcrest.xml.HasXPath.hasXPath(xPath, valueMatcher);
    }

    /**
     * Creates a matcher of {@link org.w3c.dom.Node}s that matches when the examined node has a value at the
     * specified <code>xPath</code>, within the specified <code>namespaceContext</code>, that satisfies
     * the specified <code>valueMatcher</code>.
     * <p>
     * For example:
     * <pre>assertThat(xml, hasXPath("/root/something[2]/cheese", myNs, equalTo("Cheddar")))</pre>
     *
     * @param xPath
    the target xpath
     * @param namespaceContext
    the namespace for matching nodes
     * @param valueMatcher
    matcher for the value at the specified xpath
     * @see org.hamcrest.xml.HasXPath#hasXPath(java.lang.String,javax.xml.namespace.NamespaceContext,org.hamcrest.Matcher)
     */
    public static org.hamcrest.Matcher<org.w3c.dom.Node> hasXPath(java.lang.String xPath, javax.xml.namespace.NamespaceContext namespaceContext, org.hamcrest.Matcher<java.lang.String> valueMatcher) {
        return org.hamcrest.xml.HasXPath.hasXPath(xPath, namespaceContext, valueMatcher);
    }

    /**
     * Creates a matcher of {@link org.w3c.dom.Node}s that matches when the examined node contains a node
     * at the specified <code>xPath</code>, with any content.
     * <p>
     * For example:
     * <pre>assertThat(xml, hasXPath("/root/something[2]/cheese"))</pre>
     *
     * @param xPath
    the target xpath
     * @see org.hamcrest.xml.HasXPath#hasXPath(java.lang.String)
     */
    public static org.hamcrest.Matcher<org.w3c.dom.Node> hasXPath(java.lang.String xPath) {
        return org.hamcrest.xml.HasXPath.hasXPath(xPath);
    }

    /**
     * Creates a matcher of {@link org.w3c.dom.Node}s that matches when the examined node contains a node
     * at the specified <code>xPath</code> within the specified namespace context, with any content.
     * <p>
     * For example:
     * <pre>assertThat(xml, hasXPath("/root/something[2]/cheese", myNs))</pre>
     *
     * @param xPath
    the target xpath
     * @param namespaceContext
    the namespace for matching nodes
     * @see org.hamcrest.xml.HasXPath#hasXPath(java.lang.String,javax.xml.namespace.NamespaceContext)
     */
    public static org.hamcrest.Matcher<org.w3c.dom.Node> hasXPath(java.lang.String xPath, javax.xml.namespace.NamespaceContext namespaceContext) {
        return org.hamcrest.xml.HasXPath.hasXPath(xPath, namespaceContext);
    }

}
