/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.diagnose;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.cthul.matchers.diagnose.QuickDiagnosingMatcher;
import org.cthul.matchers.diagnose.result.MatchResult;
import org.cthul.matchers.diagnose.result.MatchResultMismatch;
import org.cthul.matchers.diagnose.result.MatchResultSuccess;
import org.cthul.matchers.diagnose.result.MatcherProxy;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public class QuickDiagnose {
    private static boolean enableDiagnosingHack = true;

    public static boolean matches(Matcher<?> matcher, Object item, Description mismatch) {
        if (mismatch instanceof Description.NullDescription) {
            return matcher.matches(item);
        }
        if (matcher instanceof QuickDiagnosingMatcher) {
            return ((QuickDiagnosingMatcher)matcher).matches(item, mismatch);
        }
        if (matcher instanceof DiagnosingMatcher) {
            return DiagnosingHack.matches(matcher, item, mismatch);
        }
        return QuickDiagnose.simpleMatch(matcher, item, mismatch);
    }

    public static boolean matches(Matcher<?> matcher, Object item, Description mismatch, String message) {
        if (mismatch instanceof Description.NullDescription) {
            return matcher.matches(item);
        }
        if (message == null || message.equals("$1")) {
            return QuickDiagnose.matches(matcher, item, mismatch);
        }
        if (message.contains("$1")) {
            StringDescription subMismatch = new StringDescription();
            if (!QuickDiagnose.matches(matcher, item, (Description)subMismatch)) {
                mismatch.appendText(message.replace("$1", subMismatch.toString()));
                return false;
            }
        } else if (!matcher.matches(item)) {
            mismatch.appendText(message);
            return false;
        }
        return true;
    }

    public static <T> MatchResult<T> matchResult(Matcher<?> matcher, T item) {
        if (matcher instanceof QuickDiagnosingMatcher) {
            return ((QuickDiagnosingMatcher)matcher).matchResult(item);
        }
        StringDescription mismatch = new StringDescription();
        if (QuickDiagnose.matches(matcher, item, (Description)mismatch)) {
            return new MatchResultSuccess(item, matcher);
        }
        return new MatchResultMismatch(item, matcher, mismatch.toString());
    }

    public static <T> QuickDiagnosingMatcher<T> matcher(final Matcher<T> matcher) {
        if (matcher instanceof QuickDiagnosingMatcher) {
            return (QuickDiagnosingMatcher)matcher;
        }
        return new MatcherProxy<T>(){

            @Override
            protected Matcher<T> matcher() {
                return matcher;
            }
        };
    }

    private static boolean simpleMatch(Matcher<?> matcher, Object item, Description mismatch) {
        if (matcher.matches(item)) {
            return true;
        }
        matcher.describeMismatch(item, mismatch);
        return false;
    }

    public static synchronized void disableDiagnosingHack() {
        enableDiagnosingHack = false;
        if (DiagnosingHack.diagnosingMatches != null) {
            throw new IllegalStateException("Diagnosing hack already activated");
        }
    }

    private static synchronized boolean diagnosingHackEnabled() {
        return enableDiagnosingHack;
    }

    public static synchronized boolean diagnosingHackActivated() {
        return DiagnosingHack.hackEnabled;
    }

    private static class DiagnosingHack {
        private static final Method diagnosingMatches;
        private static final boolean hackEnabled;

        private DiagnosingHack() {
        }

        private static boolean matches(Matcher<?> matcher, Object item, Description mismatch) {
            if (diagnosingMatches == null) {
                return QuickDiagnose.simpleMatch(matcher, item, mismatch);
            }
            try {
                return DiagnosingHack.invokeDiagnosingMatches(matcher, item, mismatch);
            }
            catch (IllegalAccessException e) {
                if (enableDiagnosingHack) {
                    try {
                        diagnosingMatches.setAccessible(true);
                        DiagnosingHack.invokeDiagnosingMatches(matcher, item, mismatch);
                    }
                    catch (IllegalAccessException | SecurityException e2) {
                        enableDiagnosingHack = false;
                    }
                }
                return QuickDiagnose.simpleMatch(matcher, item, mismatch);
            }
        }

        private static boolean invokeDiagnosingMatches(Matcher<?> matcher, Object item, Description mismatch) throws IllegalAccessException {
            try {
                return (Boolean)diagnosingMatches.invoke(matcher, item, mismatch);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new RuntimeException(cause);
            }
        }

        static {
            Method matches = null;
            boolean success = false;
            if (QuickDiagnose.diagnosingHackEnabled()) {
                try {
                    matches = DiagnosingMatcher.class.getMethod("matches", Object.class, Description.class);
                    matches.setAccessible(true);
                    success = true;
                }
                catch (NoSuchMethodException | SecurityException e) {
                    success = false;
                }
            }
            hackEnabled = success;
            diagnosingMatches = matches;
        }
    }
}

