/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.diagnose.safe;

import org.cthul.matchers.diagnose.nested.NestedMatcher;
import org.cthul.matchers.diagnose.result.MatchResult;
import org.cthul.matchers.diagnose.safe.TypesafeNestedResultMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.internal.ReflectiveTypeFinder;

public abstract class TypesafeFeatureMatcher<V, F>
extends TypesafeNestedResultMatcher<V> {
    private static final ReflectiveTypeFinder TYPE_FINDER = new ReflectiveTypeFinder("getFeature", 1, 0);
    private final Matcher<? super F> featureMatcher;
    private final String matchPrefix;
    private final String mismatchPrefix;

    public TypesafeFeatureMatcher(Matcher<? super F> featureMatcher, String matchPrefix, String mismatchPrefix) {
        super(TYPE_FINDER);
        this.featureMatcher = featureMatcher;
        this.matchPrefix = matchPrefix;
        this.mismatchPrefix = mismatchPrefix;
    }

    public TypesafeFeatureMatcher(Matcher<? super F> featureMatcher, String matchPrefix, String mismatchPrefix, Class<?> expectedType) {
        super(expectedType);
        this.featureMatcher = featureMatcher;
        this.matchPrefix = matchPrefix;
        this.mismatchPrefix = mismatchPrefix;
    }

    public TypesafeFeatureMatcher(Matcher<? super F> featureMatcher, String matchPrefix, String mismatchPrefix, ReflectiveTypeFinder typeFinder) {
        super(typeFinder);
        this.featureMatcher = featureMatcher;
        this.matchPrefix = matchPrefix;
        this.mismatchPrefix = mismatchPrefix;
    }

    protected abstract F getFeature(V var1);

    public void describeTo(Description description) {
        this.describeFeature(description);
        this.describeFeatureMatcher(description);
    }

    protected void describeFeature(Description description) {
        if (this.matchPrefix != null) {
            description.appendText(this.matchPrefix).appendText(" ");
        }
    }

    protected void describeFeatureMatcher(Description description) {
        this.nestedDescribeTo((SelfDescribing)this.featureMatcher, description);
    }

    protected void describeMatchedFeature(V item, Description description) {
        this.describeMismatchedFeature(item, description);
    }

    protected void describeExpectedFeature(V item, Description description) {
        this.describeFeature(description);
    }

    protected void describeMismatchedFeature(V item, Description description) {
        if (this.mismatchPrefix != null) {
            description.appendText(this.mismatchPrefix).appendText(" ");
        }
    }

    @Override
    public int getDescriptionPrecedence() {
        return 0x100000;
    }

    @Override
    protected boolean matchesSafely(V item) {
        return this.featureMatcher.matches(this.getFeature(item));
    }

    @Override
    protected <I extends V> MatchResult<I> matchResultSafely(final I item) {
        final MatchResult<F> mr = TypesafeFeatureMatcher.quickMatchResult(this.featureMatcher, this.getFeature(item));
        return new NestedMatcher.NestedResult<I, Matcher<?>>(item, this, mr.matched()){

            @Override
            public void describeMatch(Description d) {
                TypesafeFeatureMatcher.this.describeMatchedFeature(item, d);
                this.nestedDescribeTo(this.getMatchPrecedence(), mr, d);
            }

            @Override
            public void describeExpected(Description d) {
                TypesafeFeatureMatcher.this.describeExpectedFeature(item, d);
                this.nestedDescribeTo(this.getExpectedPrecedence(), mr.getMismatch().getExpectedDescription(), d);
            }

            @Override
            public void describeMismatch(Description d) {
                TypesafeFeatureMatcher.this.describeMismatchedFeature(item, d);
                this.nestedDescribeTo(this.getMismatchPrecedence(), mr, d);
            }
        };
    }
}

