/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.fluent.adapters;

import org.cthul.matchers.diagnose.QuickMatcherBase;
import org.cthul.matchers.fluent.adapters.ConvertingAdapter;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public class AsTypeAdapter<Type>
extends ConvertingAdapter<Object, Type> {
    private final boolean isNumber;
    private final Class<?> clazz;

    @Factory
    public static <V> AsTypeAdapter<V> as(Class<V> clazz) {
        return new AsTypeAdapter(clazz);
    }

    @Factory
    public static AsTypeAdapter<Boolean> asBoolean() {
        return AsTypeAdapter.as(Boolean.class);
    }

    public static AsTypeAdapter<Byte> asByte() {
        return AsTypeAdapter.as(Byte.class);
    }

    @Factory
    public static AsTypeAdapter<Byte> asChar() {
        return AsTypeAdapter.as(Byte.class);
    }

    public static AsTypeAdapter<Float> asFloat() {
        return AsTypeAdapter.as(Float.class);
    }

    @Factory
    public static AsTypeAdapter<Double> asDouble() {
        return AsTypeAdapter.as(Double.class);
    }

    @Factory
    public static AsTypeAdapter<Integer> asInt() {
        return AsTypeAdapter.as(Integer.class);
    }

    @Factory
    public static AsTypeAdapter<Long> asLong() {
        return AsTypeAdapter.as(Long.class);
    }

    public static AsTypeAdapter<Short> asShort() {
        return AsTypeAdapter.as(Short.class);
    }

    @Factory
    public static AsTypeAdapter<String> asString() {
        return AsTypeAdapter.as(String.class);
    }

    public AsTypeAdapter(Class<?> clazz) {
        super(AsTypeAdapter.precondition(clazz));
        this.isNumber = Number.class.isAssignableFrom(clazz);
        this.clazz = clazz;
    }

    @Override
    protected boolean hasDescription() {
        return false;
    }

    @Override
    protected Type adaptValue(Object v) {
        if (this.isNumber && v != null) {
            Number n = (Number)v;
            if (this.clazz == Float.class) {
                v = Float.valueOf(n.floatValue());
            } else if (this.clazz == Double.class) {
                v = n.doubleValue();
            } else if (this.clazz == Integer.class) {
                v = n.intValue();
            } else if (this.clazz == Long.class) {
                v = n.longValue();
            }
        }
        return (Type)v;
    }

    @Override
    public void describeTo(Description description) {
        description.appendValue((Object)this);
    }

    private static Matcher<Object> precondition(Class<?> clazz) {
        if (clazz == Float.class) {
            return new Precondition(Byte.class, Short.class, Integer.class, Long.class, Float.class);
        }
        if (clazz == Double.class) {
            return new Precondition(Number.class);
        }
        if (clazz == Integer.class) {
            return new Precondition(Byte.class, Short.class, Integer.class);
        }
        if (clazz == Long.class) {
            return new Precondition(Byte.class, Short.class, Integer.class, Long.class);
        }
        return new Precondition(clazz);
    }

    private static class Precondition
    extends QuickMatcherBase<Object> {
        private final Class[] types;

        public Precondition(Class ... types) {
            this.types = types;
        }

        @Override
        public boolean matches(Object o) {
            if (o == null) {
                return true;
            }
            for (Class c : this.types) {
                if (!c.isInstance(o)) continue;
                return true;
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("is null or an instance of");
            boolean first = true;
            for (Class c : this.types) {
                if (first) {
                    description.appendText(" ");
                    first = false;
                } else {
                    description.appendText(" or ");
                }
                String n = c.getCanonicalName();
                if (this.types.length > 1) {
                    n = n.replaceFirst("java.lang.", "");
                }
                description.appendText(n);
            }
        }

        @Override
        public void describeMismatch(Object item, Description description) {
            description.appendValue(item).appendText(" is a ").appendText(item.getClass().getCanonicalName());
        }
    }
}

