/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.fluent.adapters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.cthul.matchers.diagnose.nested.Nested;
import org.cthul.matchers.fluent.value.AbstractMatchValueAdapter;
import org.cthul.matchers.fluent.value.ElementMatcher;
import org.cthul.matchers.fluent.value.MatchValue;
import org.cthul.matchers.fluent.value.MatchValueAdapterBase;
import org.hamcrest.Description;
import org.hamcrest.SelfDescribing;
import org.hamcrest.internal.ReflectiveTypeFinder;

public abstract class SimpleAnyOfAdapter<Value, Item>
extends AbstractMatchValueAdapter<Value, Item> {
    protected static final ReflectiveTypeFinder ADAPTED_TYPE_FINDER = new ReflectiveTypeFinder("getElements", 1, 0);
    private final Class<?> valueType;
    private final String name;

    public SimpleAnyOfAdapter() {
        this(null, ADAPTED_TYPE_FINDER);
    }

    public SimpleAnyOfAdapter(String name) {
        this(name, ADAPTED_TYPE_FINDER);
    }

    public SimpleAnyOfAdapter(Class<?> valueType) {
        this(null, valueType);
    }

    public SimpleAnyOfAdapter(ReflectiveTypeFinder typeFinder) {
        this(null, typeFinder);
    }

    public SimpleAnyOfAdapter(String name, Class<?> valueType) {
        this.name = name;
        this.valueType = valueType;
    }

    public SimpleAnyOfAdapter(String name, ReflectiveTypeFinder typeFinder) {
        this.name = name;
        this.valueType = typeFinder.findExpectedType(this.getClass());
    }

    @Override
    public MatchValue<Item> adapt(MatchValue<? extends Value> value) {
        return new AnyOfValues<Value>(this.valueType, value);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("any");
        if (this.name != null) {
            description.appendText(" ").appendText(this.name);
        }
    }

    @Override
    protected void describeResult(SelfDescribing result, Description description) {
        result.describeTo(description);
    }

    protected abstract Iterable<? extends Item> getElements(Value var1);

    protected void describeElement(Value owner, Item element, int index, Description description) {
        if (this.name != null) {
            description.appendText(this.name).appendText(" ");
        } else {
            description.appendText("#");
        }
        description.appendText(String.valueOf(index)).appendText(" ");
    }

    protected static class PreviousMatcher<Value> {
        final ElementMatcher<? super Value> matcher;
        boolean success = true;
        PreviousMatcher next = null;

        public PreviousMatcher(ElementMatcher<? super Value> matcher) {
            this.matcher = matcher;
        }
    }

    protected static class E<Item>
    implements ElementMatcher.Element<Item> {
        private final Item value;
        private final int index;
        private ElementMatcher<? super Item> mismatch = null;
        private ElementMatcher.Result mismatchResult = null;

        public E(Item value, int i) {
            this.value = value;
            this.index = i;
        }

        @Override
        public Item value() {
            return this.value;
        }

        public int getIndex() {
            return this.index;
        }

        public ElementMatcher.Result mismatchResult() {
            if (this.mismatchResult == null) {
                this.mismatchResult = this.mismatch.matchResult(this);
            }
            return this.mismatchResult;
        }
    }

    protected static class RemainingValidElements<Item> {
        private final Iterator<? extends Item> source;
        private final List<E<Item>> invalidElements = new ArrayList<E<Item>>();
        private E<Item> current = null;

        public RemainingValidElements(Iterable<? extends Item> iterable) {
            this.source = iterable.iterator();
        }

        public E<Item> getCurrent() {
            return this.current;
        }

        public List<E<Item>> getInvalidElements() {
            return this.invalidElements;
        }

        public Iterable<E<Item>> more() {
            return new Iterable<E<Item>>(){

                @Override
                public Iterator<E<Item>> iterator() {
                    return RemainingValidElements.this.iterateMore();
                }
            };
        }

        private Iterator<E<Item>> iterateMore() {
            return new Iterator<E<Item>>(){

                @Override
                public boolean hasNext() {
                    if (RemainingValidElements.this.current != null) {
                        RemainingValidElements.this.invalidElements.add(RemainingValidElements.this.current);
                        RemainingValidElements.this.current = null;
                    }
                    return RemainingValidElements.this.source.hasNext();
                }

                @Override
                public E<Item> next() {
                    return RemainingValidElements.this.current = new E(RemainingValidElements.this.source.next(), RemainingValidElements.this.invalidElements.size());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    protected class AnyOfValues<V extends Value>
    extends AbstractMatchValueAdapter.AbstractAdaptedValue<V, Item> {
        private PreviousMatcher<Item> matchers;
        private PreviousMatcher<Item> matchersEnd;

        public AnyOfValues(Class<?> valueType, MatchValue<V> actualValue) {
            super(valueType, actualValue);
            this.matchers = null;
            this.matchersEnd = null;
        }

        @Override
        protected Object createItem(ElementMatcher.Element<V> key) {
            return new RemainingValidElements(SimpleAnyOfAdapter.this.getElements(key.value()));
        }

        @Override
        protected boolean matchSafely(ElementMatcher.Element<V> element, ElementMatcher<? super Item> matcher) {
            RemainingValidElements it = (RemainingValidElements)this.cachedItem(element);
            return this.findValidItem(it, matcher) != null;
        }

        protected E<Item> findValidItem(RemainingValidElements<Item> remaining, ElementMatcher<? super Item> matcher) {
            PreviousMatcher pm = this.addToPreviousChain(matcher);
            E current = remaining.getCurrent();
            if (current != null) {
                if (matcher.matches(current)) {
                    return current;
                }
                pm.success = false;
                current.mismatch = matcher;
            }
            for (E e : remaining.more()) {
                if (!this.matchAgainstPrevious(e)) continue;
                return e;
            }
            return null;
        }

        protected PreviousMatcher<Item> addToPreviousChain(ElementMatcher<? super Item> matcher) {
            PreviousMatcher pm = this.matchers;
            while (pm != null) {
                if (pm.matcher == matcher) {
                    return pm;
                }
                pm = pm.next;
            }
            pm = new PreviousMatcher(matcher);
            if (this.matchers == null) {
                this.matchersEnd = this.matchers = pm;
            } else {
                this.matchersEnd.next = pm;
                this.matchersEnd = pm;
            }
            return pm;
        }

        protected boolean matchAgainstPrevious(E<Item> e) {
            PreviousMatcher pm = this.matchers;
            while (pm != null) {
                if (!pm.success && !pm.matcher.matches(e)) {
                    e.mismatch = pm.matcher;
                    return false;
                }
                pm = pm.next;
            }
            pm = this.matchers;
            while (pm != null) {
                if (pm.success && !pm.matcher.matches(e)) {
                    pm.success = false;
                    e.mismatch = pm.matcher;
                    return false;
                }
                pm = pm.next;
            }
            return true;
        }

        @Override
        protected ElementMatcher.Result matchResultSafely(ElementMatcher.Element<V> element, ElementMatcher<? super Item> matcher) {
            RemainingValidElements it = (RemainingValidElements)this.cachedItem(element);
            E e = this.findValidItem(it, matcher);
            if (e == null) {
                return this.failResult(element, it);
            }
            return this.successResult(element, e);
        }

        protected ElementMatcher.Result successResult(final ElementMatcher.Element<V> owner, final E<Item> e) {
            final ArrayList<ElementMatcher.Result> matches = new ArrayList<ElementMatcher.Result>();
            PreviousMatcher pm = this.matchers;
            while (pm != null) {
                matches.add(pm.matcher.matchResult(e));
                pm = pm.next;
            }
            return new MatchValueAdapterBase.InternalResult(true){

                @Override
                public void describeTo(Description description) {
                    for (ElementMatcher.Result r : Nested.collectDescriptions(matches, description, ", ", ", and ", " and ")) {
                        SimpleAnyOfAdapter.this.describeElement(owner.value(), e.value(), e.getIndex(), description);
                        r.describeTo(description);
                    }
                }

                @Override
                public void describeExpected(ElementMatcher.ExpectationDescription description) {
                    for (ElementMatcher.Result r : matches) {
                        r.describeExpected(description);
                    }
                }
            };
        }

        protected ElementMatcher.Result failResult(final ElementMatcher.Element<V> owner, final RemainingValidElements<Item> remaining) {
            return new MatchValueAdapterBase.InternalResult(false){

                @Override
                public void describeTo(Description description) {
                    List invalids = remaining.getInvalidElements();
                    for (E e : Nested.collectDescriptions(invalids, description, ", ", ", and ", " and ")) {
                        SimpleAnyOfAdapter.this.describeElement(owner.value(), e.value(), e.getIndex(), description);
                        e.mismatchResult().describeTo(description);
                    }
                }

                @Override
                public void describeExpected(ElementMatcher.ExpectationDescription description) {
                    List invalids = remaining.getInvalidElements();
                    for (E e : invalids) {
                        e.mismatchResult().describeExpected(description);
                    }
                }
            };
        }

        @Override
        public void describeValue(Description description) {
            SimpleAnyOfAdapter.this.describeValue(this.getSourceValue(), description);
        }

        @Override
        public void describeValueType(Description description) {
            SimpleAnyOfAdapter.this.describeValueType(this.getSourceValue(), description);
        }

        @Override
        protected void describeProducer(SelfDescribing sd, Description d) {
            SimpleAnyOfAdapter.this.describeProducer(sd, d);
        }

        @Override
        protected void describeConsumer(SelfDescribing sd, Description d) {
            SimpleAnyOfAdapter.this.describeConsumer(sd, d);
        }
    }
}

