/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.fluent.adapters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.cthul.matchers.diagnose.nested.Nested;
import org.cthul.matchers.fluent.value.AbstractMatchValueAdapter;
import org.cthul.matchers.fluent.value.ElementMatcher;
import org.cthul.matchers.fluent.value.MatchValue;
import org.cthul.matchers.fluent.value.MatchValueAdapterBase;
import org.hamcrest.Description;
import org.hamcrest.SelfDescribing;
import org.hamcrest.internal.ReflectiveTypeFinder;

public abstract class SimpleEachOfAdapter<Value, Item>
extends AbstractMatchValueAdapter<Value, Item> {
    protected static final ReflectiveTypeFinder ADAPTED_TYPE_FINDER = new ReflectiveTypeFinder("getElements", 1, 0);
    private final Class<?> valueType;
    private final String name;

    public SimpleEachOfAdapter() {
        this(null, ADAPTED_TYPE_FINDER);
    }

    public SimpleEachOfAdapter(String name) {
        this(name, ADAPTED_TYPE_FINDER);
    }

    public SimpleEachOfAdapter(Class<?> valueType) {
        this(null, valueType);
    }

    public SimpleEachOfAdapter(ReflectiveTypeFinder typeFinder) {
        this(null, typeFinder);
    }

    public SimpleEachOfAdapter(String name, Class<?> valueType) {
        this.name = name;
        this.valueType = valueType;
    }

    public SimpleEachOfAdapter(String name, ReflectiveTypeFinder typeFinder) {
        this.name = name;
        this.valueType = typeFinder.findExpectedType(this.getClass());
    }

    @Override
    public MatchValue<Item> adapt(MatchValue<? extends Value> value) {
        return new EachOfValues<Value>(this.valueType, value);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("each");
        if (this.name != null) {
            description.appendText(" ").appendText(this.name);
        }
    }

    @Override
    protected void describeResult(SelfDescribing result, Description description) {
        result.describeTo(description);
    }

    protected abstract Iterable<? extends Item> getElements(Value var1);

    protected void describeElement(Value owner, Item element, int index, Description description) {
        if (this.name != null) {
            description.appendText(this.name).appendText(" ");
        } else {
            description.appendText("#");
        }
        description.appendText(String.valueOf(index)).appendText(" ");
    }

    protected static class E<Item>
    implements ElementMatcher.Element<Item> {
        private final Item value;
        final int i;
        ElementMatcher<? super Item> mismatch = null;
        ElementMatcher.Result mismatchResult = null;
        E<Item> next = null;

        public E(Item value, int i) {
            this.value = value;
            this.i = i;
        }

        @Override
        public Item value() {
            return this.value;
        }

        public ElementMatcher.Result mismatchResult() {
            if (this.mismatchResult == null) {
                this.mismatchResult = this.mismatch.matchResult(this);
            }
            return this.mismatchResult;
        }
    }

    protected static class SourceElements<Item>
    implements Iterable<E<Item>> {
        private final Iterator<? extends Item> source;
        private final List<E<Item>> list = new ArrayList<E<Item>>();
        E<Item> invalid = null;

        public SourceElements(Iterable<? extends Item> iterable) {
            this.source = iterable.iterator();
        }

        @Override
        public Iterator<E<Item>> iterator() {
            return new Iterator<E<Item>>(){
                Iterator<E<Item>> previous;
                {
                    this.previous = SourceElements.this.list.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.previous != null && this.previous.hasNext() || SourceElements.this.source.hasNext();
                }

                @Override
                public E<Item> next() {
                    if (this.previous != null && this.previous.hasNext()) {
                        return this.previous.next();
                    }
                    this.previous = null;
                    E next = new E(SourceElements.this.source.next(), SourceElements.this.list.size());
                    SourceElements.this.list.add(next);
                    return next;
                }
            };
        }
    }

    protected class EachOfValues<V extends Value>
    extends AbstractMatchValueAdapter.AbstractAdaptedValue<V, Item> {
        public EachOfValues(Class<?> valueType, MatchValue<V> actualValue) {
            super(valueType, actualValue);
        }

        @Override
        protected Object createItem(ElementMatcher.Element<V> key) {
            return new SourceElements(SimpleEachOfAdapter.this.getElements(key.value()));
        }

        @Override
        protected boolean matchSafely(ElementMatcher.Element<V> element, ElementMatcher<? super Item> matcher) {
            SourceElements it = (SourceElements)this.cachedItem(element);
            return this.findInvalidItem(it, matcher) == null;
        }

        protected E<Item> findInvalidItem(SourceElements<Item> elements, ElementMatcher<? super Item> matcher) {
            if (elements.invalid != null) {
                return elements.invalid;
            }
            for (E e : elements) {
                if (matcher.matches(e)) continue;
                e.mismatch = matcher;
                elements.invalid = e;
                return e;
            }
            return null;
        }

        @Override
        protected ElementMatcher.Result matchResultSafely(ElementMatcher.Element<V> element, ElementMatcher<? super Item> matcher) {
            SourceElements it = (SourceElements)this.cachedItem(element);
            E invalid = this.findInvalidItem(it, matcher);
            if (invalid == null) {
                return this.successResult(element, it, matcher);
            }
            return this.failResult(element, invalid);
        }

        protected ElementMatcher.Result successResult(final ElementMatcher.Element<V> owner, final SourceElements<Item> it, final ElementMatcher<? super Item> matcher) {
            return new MatchValueAdapterBase.InternalResult(true){
                List<ElementMatcher.Result> matches;
                {
                    super(match);
                    this.matches = null;
                }

                @Override
                public void describeTo(Description description) {
                    if (this.matches == null) {
                        this.matches = new ArrayList<ElementMatcher.Result>();
                        for (E<Object> e : it) {
                            this.matches.add(matcher.matchResult(e));
                        }
                    }
                    for (E<Object> e : Nested.collectDescriptions(it, description, ", ", ", and ", " and ")) {
                        SimpleEachOfAdapter.this.describeElement(owner.value(), e.value(), e.i, description);
                        this.matches.get(e.i).describeTo(description);
                    }
                }

                @Override
                public void describeExpected(ElementMatcher.ExpectationDescription description) {
                    for (E e : it) {
                        e.mismatchResult().describeExpected(description);
                    }
                }
            };
        }

        protected ElementMatcher.Result failResult(final ElementMatcher.Element<V> owner, final E<Item> item) {
            return new MatchValueAdapterBase.InternalResult(false){

                @Override
                public void describeTo(Description description) {
                    SimpleEachOfAdapter.this.describeElement(owner.value(), item.value(), item.i, description);
                    item.mismatchResult().describeTo(description);
                }

                @Override
                public void describeExpected(ElementMatcher.ExpectationDescription description) {
                    item.mismatchResult().describeExpected(description);
                }
            };
        }

        @Override
        public void describeValue(Description description) {
            SimpleEachOfAdapter.this.describeValue(this.getSourceValue(), description);
        }

        @Override
        public void describeValueType(Description description) {
            SimpleEachOfAdapter.this.describeValueType(this.getSourceValue(), description);
        }

        @Override
        protected void describeProducer(SelfDescribing sd, Description d) {
            SimpleEachOfAdapter.this.describeProducer(sd, d);
        }

        @Override
        protected void describeConsumer(SelfDescribing sd, Description d) {
            SimpleEachOfAdapter.this.describeConsumer(sd, d);
        }
    }
}

