/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.fluent.builder;

import org.cthul.matchers.chain.AndChainMatcher;
import org.cthul.matchers.chain.ChainFactory;
import org.cthul.matchers.chain.NOrChainMatcher;
import org.cthul.matchers.chain.OrChainMatcher;
import org.cthul.matchers.diagnose.QuickDiagnose;
import org.cthul.matchers.diagnose.nested.Nested;
import org.cthul.matchers.diagnose.nested.NestedResultMatcher;
import org.cthul.matchers.diagnose.result.MatchResult;
import org.cthul.matchers.fluent.FluentStep;
import org.cthul.matchers.fluent.adapters.AsTypeAdapter;
import org.cthul.matchers.fluent.builder.ExtensibleChainBuilder;
import org.cthul.matchers.fluent.builder.FluentChainBuilder;
import org.cthul.matchers.fluent.builder.FluentStepBuilder;
import org.cthul.matchers.fluent.builder.Matchable;
import org.cthul.matchers.fluent.ext.ExtensibleFluentStep;
import org.cthul.matchers.fluent.ext.FluentFactory;
import org.cthul.matchers.fluent.ext.StepFactory;
import org.cthul.matchers.fluent.value.MatchValueAdapter;
import org.cthul.matchers.object.InstanceOf;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;

public abstract class AbstractFluentStepBuilder<Value, BaseFluent, TheFluent extends BaseFluent, This extends AbstractFluentStepBuilder<Value, BaseFluent, TheFluent, This>>
implements ExtensibleFluentStep<Value, BaseFluent, TheFluent, This> {
    private boolean negate = false;
    private String prefix = null;
    private static final StepFactory AND_CHAIN_FACTORY = new StepFactory(){

        public Object newStep(Matchable matchable) {
            return new BasicAndChain(matchable, AndChainMatcher.all());
        }
    };
    private static final StepFactory OR_CHAIN_FACTORY = new StepFactory(){

        public Object newStep(Matchable matchable) {
            return new BasicOrChain(matchable, OrChainMatcher.any());
        }
    };

    protected void _is() {
        this.prefix = "is";
    }

    protected void _has() {
        this.prefix = "has";
    }

    protected void _not() {
        this.negate = !this.negate;
    }

    protected String _prefix() {
        String p = this.prefix;
        this.prefix = null;
        return p;
    }

    protected boolean _negation() {
        boolean n = this.negate;
        this.negate = false;
        return n;
    }

    protected TheFluent _match(Matcher<? super Value> matcher) {
        return this._apply(matcher, this._prefix(), this._negation());
    }

    protected TheFluent _match(Value value) {
        if (value instanceof Matcher) {
            return this._match((Value)new AmbiguousValueMatcher<Value>(value));
        }
        return this._match((Value)IsEqual.equalTo(value));
    }

    protected <P> TheFluent _match(MatchValueAdapter<? super Value, P> adapter, Matcher<? super P> matcher) {
        return this._match((Value)adapter.adapt(matcher));
    }

    protected <P> FluentStep<P, TheFluent> _adapt(MatchValueAdapter<? super Value, ? extends P> adapter) {
        return this._step(adapter, this._prefix(), this._negation());
    }

    protected <Step> Step _adapt(StepFactory<? super Value, TheFluent, Step> factory) {
        return this._step(factory, this._prefix(), this._negation());
    }

    protected This _this() {
        return (This)this;
    }

    protected <Chain> Chain _chain(Class<Chain> chainClass, StepFactory<? super Value, ?, ?> stepFactory, ChainFactory chainFactory, String completionToken) {
        StepFactory factory = ExtensibleChainBuilder.factory(chainClass, stepFactory, chainFactory, completionToken);
        return this._adapt(factory);
    }

    protected abstract TheFluent _apply(Matcher<? super Value> var1, String var2, boolean var3);

    protected <Next> FluentStep<Next, TheFluent> _step(MatchValueAdapter<? super Value, ? extends Next> adapter, String prefix, boolean not) {
        return this._step(this._matchable(adapter, prefix, not));
    }

    protected <Step> Step _step(StepFactory<? super Value, TheFluent, Step> factory, String prefix, boolean not) {
        return factory.newStep(this._matchable(prefix, not));
    }

    protected <Next, Fl> FluentStep<Next, Fl> _step(Matchable<? extends Next, Fl> matchable) {
        return new FluentStepBuilder(matchable);
    }

    protected Matchable<Value, TheFluent> _matchable(final String prefix, final boolean not) {
        return new Matchable<Value, TheFluent>(){

            @Override
            public TheFluent apply(Matcher<? super Value> matcher) {
                return AbstractFluentStepBuilder.this._apply(matcher, prefix, not);
            }

            public String toString() {
                return AbstractFluentStepBuilder.this.toString();
            }
        };
    }

    protected <Next> Matchable<Next, TheFluent> _matchable(final MatchValueAdapter<? super Value, Next> adapter, final String prefix, final boolean not) {
        return new Matchable<Next, TheFluent>(){

            @Override
            public TheFluent apply(Matcher<? super Next> matcher) {
                Matcher m = adapter.adapt(matcher);
                return AbstractFluentStepBuilder.this._apply(m, prefix, not);
            }

            public String toString() {
                return AbstractFluentStepBuilder.this.toString();
            }
        };
    }

    @Override
    public This is() {
        this._is();
        return this._this();
    }

    @Override
    public This has() {
        this._has();
        return this._this();
    }

    @Override
    public This not() {
        this._not();
        return this._this();
    }

    @Override
    public This isNot() {
        this._is();
        this._not();
        return this._this();
    }

    @Override
    public This hasNot() {
        this._has();
        this._not();
        return this._this();
    }

    @Override
    public TheFluent __(Matcher<? super Value> matcher) {
        return this._match((Value)matcher);
    }

    @Override
    public TheFluent is(Matcher<? super Value> matcher) {
        this._is();
        return this._match((Value)matcher);
    }

    @Override
    public TheFluent has(Matcher<? super Value> matcher) {
        this._has();
        return this._match((Value)matcher);
    }

    @Override
    public TheFluent not(Matcher<? super Value> matcher) {
        this._not();
        return this._match((Value)matcher);
    }

    @Override
    public TheFluent isNot(Matcher<? super Value> matcher) {
        this._is();
        this._not();
        return this._match((Value)matcher);
    }

    @Override
    public TheFluent hasNot(Matcher<? super Value> matcher) {
        this._has();
        this._not();
        return this._match((Value)matcher);
    }

    @Override
    public TheFluent equalTo(Value value) {
        return this._match((Value)IsEqual.equalTo(value));
    }

    @Override
    public TheFluent is(Value value) {
        this._is();
        return this._match(value);
    }

    @Override
    public TheFluent not(Value value) {
        this._not();
        return this._match(value);
    }

    @Override
    public TheFluent isNot(Value value) {
        this._is();
        this._not();
        return this._match(value);
    }

    @Override
    public TheFluent allOf(Matcher<? super Value> ... matchers) {
        return this._match((Value)AndChainMatcher.all(matchers));
    }

    @Override
    public TheFluent anyOf(Matcher<? super Value> ... matchers) {
        return this._match((Value)OrChainMatcher.any(matchers));
    }

    @Override
    public TheFluent noneOf(Matcher<? super Value> ... matchers) {
        return this._match((Value)NOrChainMatcher.none(matchers));
    }

    @Override
    public <NextValue> FluentStep<NextValue, TheFluent> __(MatchValueAdapter<? super Value, ? extends NextValue> adapter) {
        return this._adapt(adapter);
    }

    @Override
    public <NextValue> FluentStep<NextValue, TheFluent> not(MatchValueAdapter<? super Value, ? extends NextValue> adapter) {
        this._not();
        return this._adapt(adapter);
    }

    @Override
    public <NextValue> FluentStep<NextValue, TheFluent> has(MatchValueAdapter<? super Value, ? extends NextValue> adapter) {
        this._has();
        return this._adapt(adapter);
    }

    @Override
    public <NextValue> FluentStep<NextValue, TheFluent> hasNot(MatchValueAdapter<? super Value, ? extends NextValue> adapter) {
        this._has();
        this._not();
        return this._adapt(adapter);
    }

    @Override
    public <NextValue> TheFluent __(MatchValueAdapter<? super Value, ? extends NextValue> adapter, Matcher<? super NextValue> matcher) {
        return this._match(adapter, matcher);
    }

    @Override
    public <NextValue> TheFluent has(MatchValueAdapter<? super Value, ? extends NextValue> adapter, Matcher<? super NextValue> matcher) {
        this._has();
        return this._match(adapter, matcher);
    }

    @Override
    public <NextValue> TheFluent not(MatchValueAdapter<? super Value, ? extends NextValue> adapter, Matcher<? super NextValue> matcher) {
        this._not();
        return this._match(adapter, matcher);
    }

    @Override
    public <NextValue> TheFluent hasNot(MatchValueAdapter<? super Value, ? extends NextValue> adapter, Matcher<? super NextValue> matcher) {
        this._has();
        this._not();
        return this._match(adapter, matcher);
    }

    @Override
    public <Value2 extends Value> TheFluent isA(Class<Value2> clazz, Matcher<? super Value2> matcher) {
        return this._match((Value)InstanceOf.isA(clazz).that((Matcher<Value2>)matcher));
    }

    @Override
    public <Value2 extends Value> TheFluent hasType(Class<Value2> clazz) {
        return this._match((Value)InstanceOf.isA(clazz));
    }

    @Override
    public <Value2 extends Value> FluentStep<Value2, TheFluent> as(Class<Value2> clazz) {
        return this._adapt(AsTypeAdapter.as(clazz));
    }

    @Override
    public <Step> Step as(StepFactory<? super Value, TheFluent, Step> adapter) {
        return this._adapt(adapter);
    }

    protected <NextFluent> NextFluent asFluent(FluentFactory<? super Value, NextFluent> adapter) {
        if (this._negation()) {
            throw new IllegalStateException("Negation not supported for fluent type cast");
        }
        return adapter.newFluent(this._matchable(this._prefix(), false));
    }

    @Override
    public FluentStep.AndChain<Value, ? extends TheFluent, ?> all() {
        return this._adapt(AbstractFluentStepBuilder.andChainFactory());
    }

    protected <Chain> Chain _both(Class<Chain> chainClass, StepFactory<? super Value, ?, ?> stepFactory) {
        return this._chain(chainClass, stepFactory, AndChainMatcher.all(), "and");
    }

    @Override
    public FluentStep.AndChain<Value, ? extends TheFluent, ?> both() {
        return this.all();
    }

    @Override
    public FluentStep.AndChain<Value, ? extends TheFluent, ?> both(Matcher<? super Value> matcher) {
        return (FluentStep.AndChain)this.both().__(matcher);
    }

    protected <Chain> Chain _all(Class<Chain> chainClass, StepFactory<? super Value, ?, ?> stepFactory) {
        return this._both(chainClass, stepFactory);
    }

    private static <Value, TheFluent> StepFactory<Value, TheFluent, FluentStep.AndChain<Value, ? extends TheFluent, ?>> andChainFactory() {
        return AND_CHAIN_FACTORY;
    }

    protected <Chain> Chain _either(Class<Chain> chainClass, StepFactory<? super Value, ?, ?> stepFactory) {
        return this._chain(chainClass, stepFactory, OrChainMatcher.any(), "or");
    }

    @Override
    public FluentStep.OrChain<Value, ? extends TheFluent, ?> either() {
        return this._adapt(AbstractFluentStepBuilder.orChainFactory());
    }

    @Override
    public FluentStep.OrChain<Value, ? extends TheFluent, ?> either(Matcher<? super Value> matcher) {
        return (FluentStep.OrChain)this.either().__(matcher);
    }

    private static <Value, TheFluent> StepFactory<Value, TheFluent, FluentStep.OrChain<Value, ? extends TheFluent, ?>> orChainFactory() {
        return OR_CHAIN_FACTORY;
    }

    private static class AmbiguousValueMatcher<T>
    extends NestedResultMatcher<T> {
        private final Matcher<T> equalToMatcher;
        private final Matcher<T> matcherValue;

        public AmbiguousValueMatcher(T value) {
            this.equalToMatcher = IsEqual.equalTo(value);
            this.matcherValue = (Matcher)value;
        }

        public void describeTo(Description description) {
            this.matcherValue.describeTo(description);
        }

        @Override
        public int getDescriptionPrecedence() {
            return Nested.precedenceOf(this.matcherValue);
        }

        @Override
        public boolean matches(Object o) {
            return this.equalToMatcher.matches(o) || this.matcherValue.matches(o);
        }

        @Override
        public <I> MatchResult<I> matchResult(I item) {
            if (item instanceof Matcher) {
                if (this.equalToMatcher.matches(item)) {
                    return QuickDiagnose.matchResult(this.equalToMatcher, item);
                }
                if (this.matcherValue.matches(item)) {
                    return QuickDiagnose.matchResult(this.equalToMatcher, item);
                }
                return QuickDiagnose.matchResult(this.equalToMatcher, item);
            }
            if (this.equalToMatcher.matches(item)) {
                return QuickDiagnose.matchResult(this.equalToMatcher, item);
            }
            return QuickDiagnose.matchResult(this.matcherValue, item);
        }
    }

    protected static class BasicOrChain<Value, TheFluent>
    extends FluentChainBuilder<Value, TheFluent, BasicOrChain<Value, TheFluent>>
    implements FluentStep.OrChain<Value, TheFluent, BasicOrChain<Value, TheFluent>> {
        public BasicOrChain(Matchable<Value, TheFluent> matchable, ChainFactory chainFactory) {
            super(matchable, chainFactory);
        }

        @Override
        public FluentStep<Value, TheFluent> or() {
            return this._terminate();
        }

        @Override
        public TheFluent or(Matcher<? super Value> matcher) {
            return this.or().__(matcher);
        }
    }

    protected static class BasicAndChain<Value, TheFluent>
    extends FluentChainBuilder<Value, TheFluent, BasicAndChain<Value, TheFluent>>
    implements FluentStep.AndChain<Value, TheFluent, BasicAndChain<Value, TheFluent>> {
        public BasicAndChain(Matchable<Value, TheFluent> matchable, ChainFactory chainFactory) {
            super(matchable, chainFactory);
        }

        @Override
        public FluentStep<Value, TheFluent> and() {
            return this._terminate();
        }

        @Override
        public TheFluent and(Matcher<? super Value> matcher) {
            return this.and().__(matcher);
        }
    }
}

