/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.fluent.builder;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.cthul.matchers.chain.ChainFactory;
import org.cthul.matchers.fluent.FluentStep;
import org.cthul.matchers.fluent.builder.FluentChainBuilder;
import org.cthul.matchers.fluent.builder.Matchable;
import org.cthul.matchers.fluent.ext.StepFactory;
import org.hamcrest.Matcher;

public class ExtensibleChainBuilder<Value, TheFluent>
extends FluentChainBuilder<Value, TheFluent, ExtensibleChainBuilder<Value, TheFluent>>
implements InvocationHandler {
    private final String terminalToken;
    private final Object stepHandler;
    private Object proxy = null;

    public static <Value, TheFluent, Chain> StepFactory<Value, TheFluent, Chain> factory(final Class<Chain> chainClass, final StepFactory<? super Value, ?, ?> factory, final ChainFactory chainFactory, final String terminalToken) {
        return new StepFactory<Value, TheFluent, Chain>(){

            @Override
            public Chain newStep(Matchable<? extends Value, TheFluent> matchable) {
                return ExtensibleChainBuilder.create(chainClass, factory, matchable, chainFactory, terminalToken);
            }
        };
    }

    public static <Value, TheFluent, Chain> Chain create(Class<Chain> chainClass, StepFactory<? super Value, ?, ?> factory, Matchable<? extends Value, TheFluent> matchable, ChainFactory chainFactory, String terminalToken) {
        Class[] interfaces = new Class[]{chainClass};
        ExtensibleChainBuilder<Value, TheFluent> builder = new ExtensibleChainBuilder<Value, TheFluent>(factory, matchable, chainFactory, terminalToken);
        Object proxy = Proxy.newProxyInstance(chainClass.getClassLoader(), interfaces, builder);
        builder.setProxy(proxy);
        return (Chain)proxy;
    }

    protected ExtensibleChainBuilder(StepFactory<? super Value, ?, ?> factory, Matchable<Value, TheFluent> matchable, ChainFactory chainFactory, String completionToken) {
        super(matchable, chainFactory);
        this.terminalToken = completionToken;
        this.stepHandler = this.buildStepHandler(factory);
    }

    protected void setProxy(Object proxy) {
        this.proxy = proxy;
    }

    private <F> Object buildStepHandler(StepFactory<? super Value, F, ?> factory) {
        return factory.newStep(this.matchable());
    }

    private <F> Matchable<Value, F> matchable() {
        return new Matchable<Value, Object>(){

            @Override
            public Object apply(Matcher<? super Value> matcher) {
                ExtensibleChainBuilder.this.__(matcher);
                if (ExtensibleChainBuilder.this._isTerminating()) {
                    return ExtensibleChainBuilder.this._submit();
                }
                return ExtensibleChainBuilder.this.proxy;
            }
        };
    }

    @Override
    protected FluentStep<Value, TheFluent> _terminalStep() {
        return (FluentStep)this.proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        if (method.getName().equals(this.terminalToken)) {
            if (args == null || args.length == 0) {
                this._terminate();
                return proxy;
            }
            this._terminate();
            methodName = "__";
        } else {
            methodName = method.getName();
        }
        Method stepMethod = this.stepHandler.getClass().getMethod(methodName, method.getParameterTypes());
        return stepMethod.invoke(this.stepHandler, args);
    }
}

