/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.fluent.builder;

import java.util.ArrayList;
import java.util.List;
import org.cthul.matchers.chain.ChainFactory;
import org.cthul.matchers.fluent.FluentStep;
import org.cthul.matchers.fluent.builder.AbstractFluentBuilder;
import org.cthul.matchers.fluent.builder.FluentStepBuilder;
import org.cthul.matchers.fluent.builder.Matchable;
import org.cthul.matchers.object.CIs;
import org.hamcrest.Matcher;

public class FluentChainBuilder<Value, TheFluent, This extends FluentChainBuilder<Value, TheFluent, This>>
extends AbstractFluentBuilder<Value, This> {
    private final List<Matcher<? super Value>> list = new ArrayList<Matcher<? super Value>>();
    private final Matchable<Value, TheFluent> matchable;
    private final ChainFactory chainFactory;
    private boolean terminate = false;
    private boolean submitted = false;

    public FluentChainBuilder(Matchable<Value, TheFluent> matchable, ChainFactory chainFactory) {
        this.matchable = matchable;
        this.chainFactory = chainFactory;
    }

    @Override
    protected This _apply(Matcher<? super Value> matcher, String prefix, boolean not) {
        if (this.submitted) {
            throw new IllegalStateException("Chain is already submitted");
        }
        matcher = CIs.wrap(prefix, not, matcher);
        this.list.add(matcher);
        return (This)((FluentChainBuilder)this._this());
    }

    public boolean _isTerminating() {
        return this.terminate;
    }

    protected TheFluent _submit() {
        if (this.submitted) {
            throw new IllegalStateException("Chain is already submitted");
        }
        this.submitted = true;
        Matcher<? super Value> matcher = this.chainFactory.create(this.list);
        return this.matchable.apply(matcher);
    }

    protected FluentStep<Value, TheFluent> _terminate() {
        if (this.submitted) {
            throw new IllegalStateException("Chain is already submitted");
        }
        this.terminate = true;
        return this._terminalStep();
    }

    protected FluentStep<Value, TheFluent> _terminalStep() {
        Matchable m = new Matchable<Value, TheFluent>(){

            @Override
            public TheFluent apply(Matcher<? super Value> matcher) {
                FluentChainBuilder.this.__(matcher);
                return FluentChainBuilder.this._submit();
            }
        };
        return new FluentStepBuilder(m);
    }
}

