/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.fluent.builder;

import java.util.ArrayList;
import java.util.List;
import org.cthul.matchers.chain.AndChainMatcher;
import org.cthul.matchers.chain.ChainFactory;
import org.cthul.matchers.chain.OrChainMatcher;
import org.cthul.matchers.chain.XOrChainMatcher;
import org.cthul.matchers.diagnose.QuickDiagnose;
import org.cthul.matchers.diagnose.QuickDiagnosingMatcher;
import org.cthul.matchers.diagnose.result.MatchResult;
import org.cthul.matchers.fluent.FluentMatcher;
import org.cthul.matchers.fluent.adapters.IdentityValue;
import org.cthul.matchers.fluent.builder.AbstractFluentMatcherBuilder;
import org.cthul.matchers.fluent.ext.ExtensibleFluentMatcher;
import org.cthul.matchers.fluent.value.MatchValueAdapter;
import org.cthul.matchers.object.CIs;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public class FluentMatcherBuilder<Value, Match, This extends FluentMatcherBuilder<Value, Match, This>>
extends AbstractFluentMatcherBuilder<Value, Match, This>
implements ExtensibleFluentMatcher<Value, Match, This> {
    private final List<Matcher<? super Value>> matchers = new ArrayList<Matcher<? super Value>>();
    private final MatchValueAdapter<Match, Value> matchValueType;
    private ChainFactory chainFactory = null;
    private boolean xorPossible = true;
    private QuickDiagnosingMatcher<Match> result = null;

    @Factory
    public static <V> FluentMatcher<V, V> match() {
        return new FluentMatcherBuilder(IdentityValue.value());
    }

    @Factory
    public static <V> FluentMatcher<V, V> match(Class<V> c) {
        return new FluentMatcherBuilder(IdentityValue.value());
    }

    @Factory
    public static <V, M> FluentMatcher<V, M> match(MatchValueAdapter<M, V> adapter) {
        return new FluentMatcherBuilder(adapter);
    }

    public FluentMatcherBuilder(MatchValueAdapter<Match, Value> matchValueType) {
        this.matchValueType = matchValueType;
    }

    protected void modify() {
        if (this.result != null) {
            throw new IllegalStateException("Matcher already created");
        }
    }

    protected void ensureChain(ChainFactory f) {
        if (this.chainFactory == null) {
            this.chainFactory = f;
            this.xorPossible = false;
        } else if (this.chainFactory != f) {
            throw new IllegalStateException("Chain type is " + this.chainFactory + ", but required was " + f);
        }
    }

    @Override
    protected void _and() {
        this.ensureChain(AndChainMatcher.FACTORY);
    }

    @Override
    protected void _or() {
        this.ensureChain(OrChainMatcher.FACTORY);
    }

    protected void _xor() {
        if (this.xorPossible) {
            this.chainFactory = null;
        }
        this.ensureChain(XOrChainMatcher.FACTORY);
    }

    @Override
    protected This _apply(Matcher<? super Value> matcher, String prefix, boolean not) {
        this.matchers.add(CIs.wrap(prefix, not, matcher));
        return (This)((FluentMatcherBuilder)this._this());
    }

    @Override
    public QuickDiagnosingMatcher<Match> getMatcher() {
        if (this.result == null) {
            if (this.chainFactory == null) {
                this._and();
            }
            this.result = this.buildMatcher();
        }
        return this.result;
    }

    protected QuickDiagnosingMatcher<Match> buildMatcher() {
        ChainFactory cf = this.chainFactory;
        if (cf == null) {
            cf = AndChainMatcher.FACTORY;
        }
        Matcher<? super Value> m = cf.create(this.matchers);
        Matcher<Match> m2 = this.matchValueType.adapt(m);
        return QuickDiagnose.matcher(m2);
    }

    @Override
    public boolean matches(Object item, Description mismatch) {
        return this.getMatcher().matches(item, mismatch);
    }

    public boolean matches(Object item) {
        return this.getMatcher().matches(item);
    }

    public void describeMismatch(Object item, Description mismatchDescription) {
        this.getMatcher().describeMismatch(item, mismatchDescription);
    }

    public void describeTo(Description description) {
        this.getMatcher().describeTo(description);
    }

    @Override
    public <I> MatchResult<I> matchResult(I item) {
        return this.getMatcher().matchResult(item);
    }

    @Deprecated
    public void _dont_implement_Matcher___instead_extend_BaseMatcher_() {
    }

    public String toString() {
        if (this.result == null) {
            return this.buildMatcher().toString();
        }
        return this.getMatcher().toString();
    }
}

