/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.fluent.lib.collection;

import java.util.Collection;
import org.cthul.matchers.fluent.adapters.SimpleAdapter;
import org.cthul.matchers.fluent.value.MatchValue;
import org.cthul.matchers.fluent.value.MatchValueAdapter;
import org.hamcrest.Factory;

public class IterableSizeAdapter
extends SimpleAdapter<Iterable<?>, Integer> {
    private static final IterableSizeAdapter INSTANCE = new IterableSizeAdapter();

    @Factory
    public static IterableSizeAdapter size() {
        return INSTANCE;
    }

    @Factory
    public static MatchValue<Integer> sizeOf(Iterable<?> iterable) {
        return IterableSizeAdapter.size().adapt(iterable);
    }

    @Factory
    public static MatchValue<Integer> sizeOf(MatchValue<? extends Iterable<?>> value) {
        return IterableSizeAdapter.size().adapt(value);
    }

    @Factory
    public static <V> MatchValueAdapter<V, Integer> sizeOf(MatchValueAdapter<V, ? extends Iterable<?>> adapter) {
        return IterableSizeAdapter.size().adapt(adapter);
    }

    public IterableSizeAdapter() {
        super("size", Iterable.class);
    }

    @Override
    protected Integer adaptValue(Iterable<?> v) {
        if (v instanceof Collection) {
            return ((Collection)v).size();
        }
        int i = 0;
        for (Object o : v) {
            ++i;
        }
        return i;
    }
}

