/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.fluent.value;

import java.util.HashMap;
import java.util.Map;
import org.cthul.matchers.diagnose.QuickDiagnose;
import org.cthul.matchers.diagnose.result.MatchResult;
import org.cthul.matchers.fluent.value.ElementMatcher;
import org.cthul.matchers.fluent.value.ElementMatcherWrapper;
import org.cthul.matchers.fluent.value.MatchValue;
import org.cthul.matchers.fluent.value.MatchValueAdapterBase;
import org.cthul.matchers.fluent.value.MatchValueBase;
import org.cthul.matchers.object.CIs;
import org.cthul.matchers.object.InstanceOf;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.core.IsEqual;

public abstract class AbstractMatchValueAdapter<Value, Property>
extends MatchValueAdapterBase<Value, Property> {
    @Override
    public abstract MatchValue<Property> adapt(MatchValue<? extends Value> var1);

    protected void describeValue(MatchValue<? extends Value> source, Description description) {
        this.describeProducer(source.getValueDescription(), description);
    }

    protected void describeValueType(MatchValue<? extends Value> source, Description description) {
        this.describeProducer(source.getValueTypeDescription(), description);
    }

    protected static class InternalAdaptingMatcher<Value, Property>
    implements ElementMatcher<Value> {
        private final AbstractAdaptedValue<Value, Property> adaptedValue;
        private final ElementMatcher<? super Property> itemMatcher;

        public InternalAdaptingMatcher(AbstractAdaptedValue<Value, Property> adaptedValue, ElementMatcher<? super Property> itemMatcher) {
            this.adaptedValue = adaptedValue;
            this.itemMatcher = itemMatcher;
        }

        @Override
        public boolean matches(ElementMatcher.Element<?> element) {
            return this.adaptedValue.matches(element, this.itemMatcher);
        }

        @Override
        public ElementMatcher.Result matchResult(ElementMatcher.Element<?> e) {
            return this.adaptedValue.matchResult(e, this.itemMatcher);
        }

        public void describeTo(Description description) {
            description.appendText("[InternalAdaptedMatcher: ");
            description.appendDescriptionOf(this.itemMatcher);
            description.appendText("]");
        }

        @Override
        public int getDescriptionPrecedence() {
            return 0x700000;
        }
    }

    protected static abstract class AbstractAdaptedValue<Value, Property>
    extends MatchValueBase<Property> {
        private final Class<?> valueType;
        private final Matcher<? super Value> precondition;
        private final MatchValue<Value> sourceValue;
        private Map<ElementMatcher.Element<Value>, Object> cache = null;
        private ElementMatcher.Element<Value> firstKey = null;
        private Object firstCached = null;

        public AbstractAdaptedValue(Class<?> valueType, MatchValue<Value> sourceValue) {
            this.valueType = valueType;
            this.precondition = null;
            this.sourceValue = sourceValue;
        }

        public AbstractAdaptedValue(Matcher<? super Value> precondition, MatchValue<Value> sourceValue) {
            this.valueType = null;
            this.precondition = precondition;
            this.sourceValue = sourceValue;
        }

        public AbstractAdaptedValue(Class<?> valueType, Matcher<Object> precondition, MatchValue<Value> sourceValue) {
            this.valueType = valueType;
            this.precondition = precondition;
            this.sourceValue = sourceValue;
        }

        protected boolean acceptValue(ElementMatcher.Element<?> element) {
            return this.acceptValue(element.value());
        }

        protected boolean acceptValue(Object value) {
            if (this.valueType != null && !this.valueType.isInstance(value)) {
                return false;
            }
            return this.precondition == null || this.precondition.matches(value);
        }

        protected MatchResult<?> matchResultOfUnaccepted(Object value) {
            if (this.valueType != null && !this.valueType.isInstance(value)) {
                return InstanceOf.isA(this.valueType).matchResult(value);
            }
            if (this.precondition != null && !this.precondition.matches(value)) {
                return QuickDiagnose.matchResult(this.precondition, value);
            }
            return CIs.isNot(IsEqual.equalTo((Object)value)).matchResult(value);
        }

        protected ElementMatcher.Result matchResultOfUnaccepted(ElementMatcher.Element<?> element) {
            return ElementMatcherWrapper.asElementResult(this.matchResultOfUnaccepted(element.value()));
        }

        protected MatchValue<Value> getSourceValue() {
            return this.sourceValue;
        }

        protected ElementMatcher<Value> adapt(ElementMatcher<? super Property> matcher) {
            return new InternalAdaptingMatcher(this, matcher);
        }

        @Override
        public boolean matched() {
            return this.sourceValue.matched();
        }

        @Override
        public boolean matches(ElementMatcher<? super Property> matcher) {
            return this.sourceValue.matches(this.adapt(matcher));
        }

        @Override
        public MatchResult<?> matchResult() {
            return this.sourceValue.matchResult();
        }

        protected abstract void describeConsumer(SelfDescribing var1, Description var2);

        protected abstract void describeProducer(SelfDescribing var1, Description var2);

        protected boolean matches(ElementMatcher.Element<?> element, ElementMatcher<? super Property> matcher) {
            if (this.acceptValue(element.value())) {
                return this.matchSafely(element, matcher);
            }
            return false;
        }

        protected abstract boolean matchSafely(ElementMatcher.Element<Value> var1, ElementMatcher<? super Property> var2);

        protected ElementMatcher.Result matchResult(ElementMatcher.Element<?> element, ElementMatcher<? super Property> matcher) {
            if (this.acceptValue(element)) {
                return this.matchResultSafely(element, matcher);
            }
            return this.matchResultOfUnaccepted(element);
        }

        protected abstract ElementMatcher.Result matchResultSafely(ElementMatcher.Element<Value> var1, ElementMatcher<? super Property> var2);

        protected <T> T cachedItem(ElementMatcher.Element<Value> key) {
            Object value;
            if (this.cache == null) {
                if (key.equals(this.firstKey)) {
                    return this.cast(this.firstCached);
                }
            } else {
                value = this.cache.get(key);
                if (value != null) {
                    return this.cast(value);
                }
            }
            value = this.createItem(key);
            if (this.cache == null) {
                if (this.firstKey == null) {
                    this.firstKey = key;
                    this.firstCached = value;
                    return this.cast(value);
                }
                this.cache = new HashMap<ElementMatcher.Element<Value>, Object>();
                this.cache.put(this.firstKey, this.firstCached);
            }
            this.cache.put(key, value);
            return this.cast(value);
        }

        private <T> T cast(Object o) {
            return (T)o;
        }

        protected Object createItem(ElementMatcher.Element<Value> key) {
            throw new UnsupportedOperationException("#createItem not implemented");
        }
    }
}

