/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.fluent.value;

import org.cthul.matchers.diagnose.QuickDiagnose;
import org.cthul.matchers.diagnose.SelfDescribingBase;
import org.cthul.matchers.diagnose.nested.Nested;
import org.cthul.matchers.diagnose.nested.NestedResultMatcher;
import org.cthul.matchers.diagnose.result.AbstractMatchResult;
import org.cthul.matchers.diagnose.result.MatchResult;
import org.cthul.matchers.fluent.value.ElementMatcher;
import org.cthul.matchers.fluent.value.ExpectationStringDescription;
import org.cthul.matchers.object.CIs;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;

public class ElementMatcherWrapper<Item>
extends SelfDescribingBase
implements ElementMatcher<Item> {
    private final int index;
    private final Matcher<? super Item> matcher;

    public ElementMatcherWrapper(int index, Matcher<? super Item> matcher, String prefix, boolean not) {
        this(index, CIs.wrap(prefix, not, matcher));
    }

    public ElementMatcherWrapper(int index, Matcher<? super Item> matcher) {
        this.index = index;
        this.matcher = matcher;
    }

    @Override
    public void describeTo(Description description) {
        this.matcher.describeTo(description);
    }

    @Override
    public int getDescriptionPrecedence() {
        return Nested.precedenceOf(this.matcher);
    }

    @Override
    public boolean matches(ElementMatcher.Element<?> element) {
        return this.matcher.matches(element.value());
    }

    @Override
    public ElementMatcher.Result matchResult(ElementMatcher.Element<?> element) {
        MatchResult<?> result = QuickDiagnose.matchResult(this.matcher, element.value());
        return ElementMatcherWrapper.asElementResult(this.index, result);
    }

    public Matcher<? super Item> getActualMatcher() {
        return this.matcher;
    }

    public static ElementMatcher.Result asElementResult(MatchResult<?> result) {
        return ElementMatcherWrapper.asElementResult(-1, result);
    }

    public static ElementMatcher.Result asElementResult(final int index, final MatchResult<?> result) {
        return new ElementMatcher.Result(){

            @Override
            public boolean matched() {
                return result.matched();
            }

            @Override
            public void describeTo(Description description) {
                result.describeTo(description);
            }

            @Override
            public void describeExpected(ElementMatcher.ExpectationDescription description) {
                if (this.matched()) {
                    description.addExpected(index, (SelfDescribing)result.getMatcher());
                } else {
                    description.addExpected(index, result.getMismatch().getExpectedDescription());
                }
            }

            public String toString() {
                return new StringDescription().appendDescriptionOf((SelfDescribing)this).toString();
            }
        };
    }

    public static <T> Matcher<T> asMatcher(final ElementMatcher<T> em) {
        if (em instanceof ElementMatcherWrapper) {
            return ((ElementMatcherWrapper)em).getActualMatcher();
        }
        return new NestedResultMatcher<T>(){

            @Override
            public <I> MatchResult<I> matchResult(final I item) {
                ElementMatcher.Element element = new ElementMatcher.Element<I>(){

                    @Override
                    public I value() {
                        return item;
                    }
                };
                final ElementMatcher.Result r = em.matchResult(element);
                return new AbstractMatchResult<I, Matcher<T>>(item, this, r.matched(), r){

                    @Override
                    public void describeExpected(Description d) {
                        new ExpectationStringDescription().addExpected(r).describeTo(d);
                    }
                };
            }

            public void describeTo(Description description) {
                em.describeTo(description);
            }

            @Override
            public int getDescriptionPrecedence() {
                return em.getDescriptionPrecedence();
            }
        };
    }
}

