/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.fluent.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.cthul.matchers.diagnose.SelfDescribingBase;
import org.cthul.matchers.fluent.value.ElementMatcher;
import org.hamcrest.Description;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;

public class ExpectationStringDescription
extends SelfDescribingBase
implements ElementMatcher.ExpectationDescription {
    private ArrayList<SelfDescribing> sorted = null;
    private ArrayList<SelfDescribing> unsorted = null;
    private StringDescription current = null;

    protected StringDescription current() {
        if (this.current == null) {
            this.current = new StringDescription();
        }
        return this.current;
    }

    public ExpectationStringDescription addExpected(ElementMatcher.Result result) {
        result.describeExpected(this);
        return this;
    }

    @Override
    public ExpectationStringDescription addExpected(int index, SelfDescribing expected) {
        if (index < 0) {
            if (this.unsorted == null) {
                this.unsorted = new ArrayList();
            }
            this.unsorted.add(expected);
        } else {
            if (this.sorted == null) {
                this.sorted = new ArrayList();
            }
            this.sorted.ensureCapacity(index);
            while (this.sorted.size() <= index) {
                this.sorted.add(null);
            }
            this.sorted.set(index, expected);
        }
        this.current = null;
        return this;
    }

    public Description appendText(String text) {
        return this.current().appendText(text);
    }

    public Description appendDescriptionOf(SelfDescribing value) {
        return this.current().appendDescriptionOf(value);
    }

    public Description appendValue(Object value) {
        return this.current().appendValue(value);
    }

    public <T> Description appendValueList(String start, String separator, String end, T ... values) {
        return this.current().appendValueList(start, separator, end, (Object[])values);
    }

    public <T> Description appendValueList(String start, String separator, String end, Iterable<T> values) {
        return this.current().appendValueList(start, separator, end, values);
    }

    public Description appendList(String start, String separator, String end, Iterable<? extends SelfDescribing> values) {
        return this.current().appendList(start, separator, end, values);
    }

    @Override
    public void describeTo(Description description) {
        if (this.current != null) {
            description.appendText(this.current.toString());
            description.appendText(" ");
        }
        LinkedHashSet<String> expected = new LinkedHashSet<String>();
        this.describeAll(expected, this.unsorted);
        this.describeAll(expected, this.sorted);
        int last = expected.size() - 1;
        int i = 0;
        for (String s : expected) {
            if (i > 0) {
                if (i == last) {
                    description.appendText(i == 1 ? " " : ", ");
                    description.appendText("and ");
                } else {
                    description.appendText(", ");
                }
            }
            description.appendText(s);
            ++i;
        }
    }

    private void describeAll(Collection<String> target, Iterable<SelfDescribing> source) {
        if (source != null) {
            for (SelfDescribing s : source) {
                if (s == null) continue;
                target.add(StringDescription.toString((SelfDescribing)s));
            }
        }
    }
}

