/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.fluent.value;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cthul.matchers.diagnose.SelfDescribingBase;
import org.cthul.matchers.diagnose.nested.Nested;
import org.cthul.matchers.diagnose.nested.NestedResultMatcher;
import org.cthul.matchers.diagnose.nested.PrecedencedSelfDescribing;
import org.cthul.matchers.diagnose.nested.PrecedencedSelfDescribingBase;
import org.cthul.matchers.diagnose.result.MatchResult;
import org.cthul.matchers.diagnose.result.MatchResultProxy;
import org.cthul.matchers.fluent.value.ElementMatcher;
import org.cthul.matchers.fluent.value.ElementMatcherWrapper;
import org.cthul.matchers.fluent.value.ExpectationStringDescription;
import org.cthul.matchers.fluent.value.MatchValue;
import org.cthul.matchers.fluent.value.MatchValueAdapter;
import org.cthul.matchers.fluent.value.MatchValueBase;
import org.cthul.proc.Proc;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.core.IsAnything;

public abstract class MatchValueAdapterBase<Value, Property>
extends SelfDescribingBase
implements MatchValueAdapter<Value, Property> {
    @Override
    public <Value0> MatchValueAdapter<Value0, Property> adapt(MatchValueAdapter<Value0, ? extends Value> adapter) {
        return new CombinedMatchValueAdapter(adapter, this);
    }

    @Override
    public Matcher<Value> adapt(Matcher<? super Property> matcher) {
        return new AdaptingMatcher(this, matcher);
    }

    @Override
    public MatchValue<Property> adapt(Object value) {
        return this.adapt(new SingleElementValue(value));
    }

    @Override
    public <Property2> MatchValueAdapter<Value, Property2> get(MatchValueAdapter<? super Property, Property2> adapter) {
        return adapter.adapt(this);
    }

    protected boolean hasDescription() {
        return true;
    }

    protected void describeConsumer(SelfDescribing consumer, Description description) {
        if (this.hasDescription()) {
            description.appendDescriptionOf((SelfDescribing)this).appendText(" ");
        }
        consumer.describeTo(description);
    }

    protected void describeProducer(SelfDescribing producer, Description description) {
        if (this.hasDescription()) {
            description.appendDescriptionOf((SelfDescribing)this).appendText(" of ");
        }
        producer.describeTo(description);
    }

    protected void describeResult(SelfDescribing result, Description description) {
        if (this.hasDescription()) {
            description.appendDescriptionOf((SelfDescribing)this).appendText(" ");
        }
        result.describeTo(description);
    }

    protected static abstract class InternalResult
    extends SelfDescribingBase
    implements ElementMatcher.Result {
        private final boolean match;

        public InternalResult() {
            this.match = false;
        }

        public InternalResult(boolean match) {
            this.match = match;
        }

        @Override
        public boolean matched() {
            return this.match;
        }
    }

    protected static class AdaptingMatcher<Value, Property>
    extends NestedResultMatcher<Value> {
        private final ElementMatcherWrapper<Property> matcher;
        private final MatchValueAdapterBase<Value, Property> adapter;

        public AdaptingMatcher(MatchValueAdapterBase<Value, Property> adapter, Matcher<? super Property> matcher, String prefix, boolean not) {
            this.adapter = adapter;
            this.matcher = new ElementMatcherWrapper<Property>(-1, matcher, prefix, not);
        }

        public AdaptingMatcher(MatchValueAdapterBase<Value, Property> adapter, Matcher<? super Property> matcher) {
            this.adapter = adapter;
            this.matcher = new ElementMatcherWrapper<Property>(-1, matcher);
        }

        public void describeTo(Description description) {
            this.adapter.describeConsumer(this.matcher, description);
        }

        @Override
        public int getDescriptionPrecedence() {
            return Nested.precedenceOf(this.matcher);
        }

        @Override
        public boolean matches(Object item) {
            return this.adapter.adapt(item).matches(this.matcher);
        }

        @Override
        public <I> MatchResult<I> matchResult(I item) {
            MatchValue<Property> mv = this.adapter.adapt(item);
            mv.matches(this.matcher);
            return new AdaptedResult<I>(mv.matchResult(), item);
        }

        class AdaptedResult<I>
        extends MatchResultProxy<I, AdaptingMatcher<?, ?>> {
            public AdaptedResult(MatchResult<?> result, I value) {
                super(result, value, AdaptingMatcher.this);
            }

            @Override
            protected boolean fastProxy() {
                return false;
            }

            @Override
            public void describeMatch(Description description) {
                AdaptingMatcher.this.adapter.describeResult(this.match().getMatchDescription(), description);
            }

            @Override
            public void describeExpected(Description description) {
                AdaptingMatcher.this.adapter.describeConsumer(this.mismatch().getExpectedDescription(), description);
            }

            @Override
            public void describeMismatch(Description description) {
                AdaptingMatcher.this.adapter.describeResult(this.mismatch().getMismatchDescription(), description);
            }
        }
    }

    protected static class SingleElementValue<Value>
    extends MatchValueBase<Value>
    implements ElementMatcher.Element<Object>,
    MatchResult.Match<Value>,
    MatchResult.Mismatch<Value> {
        private static final ElementMatcher<Object> ANYTHING = new ElementMatcherWrapper<Object>(-1, IsAnything.anything((String)"anything"));
        private final Object value;
        private boolean valid = true;
        private ElementMatcher<? super Value> last = ANYTHING;
        private ElementMatcher.Result internResult = null;
        private String valueType = null;

        public SingleElementValue(Object value) {
            this.value = value;
        }

        public SingleElementValue(Object value, String valueType) {
            this.value = value;
            this.valueType = valueType;
        }

        @Override
        public boolean matches(ElementMatcher<? super Value> matcher) {
            if (!this.valid) {
                return false;
            }
            this.valid = matcher.matches(this);
            this.last = matcher;
            this.internResult = null;
            return this.valid;
        }

        @Override
        public boolean matched() {
            return this.valid;
        }

        @Override
        public void describeValue(Description description) {
            description.appendValue(this.value);
        }

        @Override
        public void describeValueType(Description description) {
            description.appendText(this.getValueType());
        }

        public String getValueType() {
            if (this.valueType == null) {
                this.valueType = this.detectValueType();
            }
            return this.valueType;
        }

        protected String detectValueType() {
            if (this.value != null) {
                if (this.value instanceof Iterable) {
                    if (this.value instanceof List) {
                        return "list";
                    }
                    if (this.value instanceof Set) {
                        return "set";
                    }
                    if (this.value instanceof Collection) {
                        return "collection";
                    }
                    return "iterable";
                }
                if (this.value instanceof Map) {
                    return "map";
                }
                if (this.value.getClass().isArray()) {
                    return "array";
                }
                if (this.value instanceof Proc) {
                    return "call";
                }
            }
            return "value";
        }

        private ElementMatcher.Result result() {
            if (this.internResult == null) {
                this.internResult = this.last.matchResult(this);
            }
            return this.internResult;
        }

        @Override
        public MatchResult<?> matchResult() {
            return this;
        }

        @Override
        public Object value() {
            return this.value;
        }

        @Override
        public Value getValue() {
            return (Value)this.value;
        }

        @Override
        public void describeTo(Description description) {
            if (this.last == ANYTHING) {
                super.describeTo(description);
            } else {
                this.result().describeTo(description);
            }
        }

        @Override
        public int getDescriptionPrecedence() {
            return 0x1000000;
        }

        @Override
        public Matcher<?> getMatcher() {
            return ElementMatcherWrapper.asMatcher(this.last);
        }

        @Override
        public void describeMatcher(Description description) {
            this.last.describeTo(description);
        }

        @Override
        public int getMatcherPrecedence() {
            return this.last.getDescriptionPrecedence();
        }

        @Override
        public PrecedencedSelfDescribing getMatcherDescription() {
            return this.last;
        }

        @Override
        public MatchResult.Match<Value> getMatch() {
            return this.matched() ? this : null;
        }

        @Override
        public void describeMatch(Description description) {
            this.describeTo(description);
        }

        @Override
        public PrecedencedSelfDescribing getMatchDescription() {
            return this;
        }

        @Override
        public int getMatchPrecedence() {
            return this.getDescriptionPrecedence();
        }

        @Override
        public MatchResult.Mismatch<Value> getMismatch() {
            return this.matched() ? null : this;
        }

        @Override
        public void describeExpected(Description description) {
            ExpectationStringDescription exp = new ExpectationStringDescription();
            this.result().describeExpected(exp);
            exp.describeTo(description);
        }

        @Override
        public int getExpectedPrecedence() {
            return this.getDescriptionPrecedence();
        }

        @Override
        public PrecedencedSelfDescribing getExpectedDescription() {
            return new PrecedencedSelfDescribingBase(){

                @Override
                public void describeTo(Description description) {
                    SingleElementValue.this.describeExpected(description);
                }

                @Override
                public int getDescriptionPrecedence() {
                    return SingleElementValue.this.getExpectedPrecedence();
                }
            };
        }

        @Override
        public void describeMismatch(Description description) {
            this.describeTo(description);
        }

        @Override
        public int getMismatchPrecedence() {
            return this.getDescriptionPrecedence();
        }

        @Override
        public PrecedencedSelfDescribing getMismatchDescription() {
            return this;
        }
    }

    protected static class CombinedMatchValueAdapter<Value, Tmp, Property>
    extends MatchValueAdapterBase<Value, Property> {
        private final MatchValueAdapter<Value, ? extends Tmp> mva1;
        private final MatchValueAdapterBase<Tmp, Property> mva2;

        public CombinedMatchValueAdapter(MatchValueAdapter<Value, ? extends Tmp> mva1, MatchValueAdapterBase<Tmp, Property> mva2) {
            this.mva1 = mva1;
            this.mva2 = mva2;
        }

        @Override
        public MatchValue<Property> adapt(Object value) {
            return this.mva2.adapt(this.mva1.adapt(value));
        }

        @Override
        public MatchValue<Property> adapt(MatchValue<? extends Value> value) {
            return this.mva2.adapt(this.mva1.adapt(value));
        }

        @Override
        public void describeTo(Description description) {
            this.mva2.describeProducer(this.mva1, description);
        }
    }
}

