/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.hamcrest;

import org.cthul.matchers.diagnose.nested.NestedMatcher;
import org.cthul.matchers.diagnose.result.AbstractMatchResult;
import org.cthul.matchers.diagnose.result.MatchResult;
import org.cthul.matchers.diagnose.safe.TypesafeNestedResultMatcher;
import org.cthul.matchers.hamcrest.HasDescription;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;

public class IsMatchResult<T>
extends TypesafeNestedResultMatcher<MatchResult<T>> {
    private final boolean match;
    private final Matcher<? super MatchResult<T>> resultMatcher;

    @Factory
    public static <T> IsMatchResult<T> match() {
        return new IsMatchResult<T>();
    }

    @Factory
    public static <T> IsMatchResult<T> mismatch() {
        return new IsMatchResult<T>(false);
    }

    @Factory
    public static <T> IsMatchResult<T> match(Matcher<? super MatchResult<T>> resultMatcher) {
        return new IsMatchResult<T>(resultMatcher);
    }

    @Factory
    public static <T> IsMatchResult<T> mismatch(Matcher<? super MatchResult<T>> resultMatcher) {
        return new IsMatchResult<T>(false, resultMatcher);
    }

    @Factory
    public static <T> IsMatchResult<T> matchWithMessage(Matcher<? super String> resultMatcher) {
        return IsMatchResult.match(HasDescription.message(resultMatcher));
    }

    @Factory
    public static <T> IsMatchResult<T> mismatchWithMessage(Matcher<? super String> resultMatcher) {
        return IsMatchResult.mismatch(HasDescription.message(resultMatcher));
    }

    @Factory
    public static <T> IsMatchResult<T> matchWithMessage(String message) {
        return IsMatchResult.match(HasDescription.message(message));
    }

    @Factory
    public static <T> IsMatchResult<T> mismatchWithMessage(String message) {
        return IsMatchResult.mismatch(HasDescription.message(message));
    }

    @Factory
    public static <T> IsMatchResult<T> match(String message) {
        return IsMatchResult.match(HasDescription.message(message));
    }

    @Factory
    public static <T> IsMatchResult<T> mismatch(String message) {
        return IsMatchResult.mismatch(HasDescription.message(message));
    }

    public IsMatchResult() {
        super(MatchResult.class);
        this.match = true;
        this.resultMatcher = null;
    }

    public IsMatchResult(Matcher<? super MatchResult<T>> resultMatcher) {
        super(MatchResult.class);
        this.match = true;
        this.resultMatcher = resultMatcher;
    }

    public IsMatchResult(boolean match) {
        super(MatchResult.class);
        this.match = match;
        this.resultMatcher = null;
    }

    public IsMatchResult(boolean match, Matcher<? super MatchResult<T>> resultMatcher) {
        super(MatchResult.class);
        this.match = match;
        this.resultMatcher = resultMatcher;
    }

    public void describeTo(Description description) {
        if (this.resultMatcher == null) {
            description.appendText(this.match ? "a match" : " a mismatch");
        } else {
            description.appendText(this.match ? "match " : "mismatch ");
            this.nestedDescribeTo((SelfDescribing)this.resultMatcher, description);
        }
    }

    @Override
    public int getDescriptionPrecedence() {
        return this.resultMatcher == null ? 0x1000000 : 0x100000;
    }

    @Override
    protected boolean matchesSafely(MatchResult<T> item) {
        if (item.matched() != this.match) {
            return false;
        }
        if (this.resultMatcher == null) {
            return true;
        }
        return this.resultMatcher.matches(item);
    }

    @Override
    protected <I extends MatchResult<T>> MatchResult<I> matchResultSafely(I item) {
        if (this.resultMatcher == null || item.matched() != this.match) {
            return this.valueResult(item);
        }
        MatchResult<I> msgResult = IsMatchResult.quickMatchResult(this.resultMatcher, item);
        return this.messageResult(item, msgResult);
    }

    private <I extends MatchResult<T>> MatchResult<I> valueResult(final I item) {
        return new AbstractMatchResult<I, Matcher<?>>(item, this, item.matched() == this.match){

            @Override
            public void describeMatch(Description d) {
                d.appendText("was ").appendText(IsMatchResult.this.match ? "match " : "mismatch ").appendValue((Object)item);
            }

            @Override
            public void describeMismatch(Description d) {
                d.appendText("was ").appendText(IsMatchResult.this.match ? "mismatch " : "match ").appendValue((Object)item);
            }
        };
    }

    private <I extends MatchResult<T>> MatchResult<I> messageResult(I item, final MatchResult<I> mr) {
        return new NestedMatcher.NestedResult<I, Matcher<?>>(item, this, mr.matched()){

            @Override
            public void describeMatch(Description d) {
                d.appendText(IsMatchResult.this.match ? "match " : "mismatch ");
                this.nestedDescribeTo(this.getMatchPrecedence(), mr, d);
            }

            @Override
            public void describeMismatch(Description d) {
                d.appendText(IsMatchResult.this.match ? "match " : "mismatch ");
                this.nestedDescribeTo(this.getMismatchPrecedence(), mr, d);
            }
        };
    }
}

