/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.object;

import org.cthul.matchers.chain.AndChainMatcher;
import org.cthul.matchers.diagnose.QuickDiagnosingMatcherBase;
import org.cthul.matchers.object.InstanceThat;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;

public class InstanceOf<T>
extends QuickDiagnosingMatcherBase<Object> {
    private boolean prependIs;
    private final Class<T> clazz;
    private IsInstanceOf matcher = null;

    public InstanceOf(boolean prependIs, Class<T> expectedClass) {
        this.prependIs = prependIs;
        this.clazz = expectedClass;
    }

    public InstanceOf(Class<T> expectedClass) {
        this(false, expectedClass);
    }

    protected IsInstanceOf matcher() {
        if (this.matcher == null) {
            this.matcher = new IsInstanceOf(this.clazz);
        }
        return this.matcher;
    }

    @Override
    public boolean matches(Object o) {
        return this.matcher().matches(o);
    }

    @Override
    public boolean matches(Object item, Description mismatch) {
        return InstanceOf.quickMatch(this.matcher(), item, mismatch);
    }

    @Override
    public void describeMismatch(Object item, Description description) {
        this.matcher().describeMismatch(item, description);
    }

    public void describeTo(Description description) {
        if (this.prependIs) {
            description.appendText("is ");
        }
        this.matcher().describeTo(description);
    }

    public <X> AndChainMatcher.Builder<X> that(Matcher<? super T> m) {
        if (this.prependIs) {
            return InstanceThat.isInstanceThat(this.clazz, m);
        }
        return InstanceThat.instanceThat(this.clazz, m);
    }

    public <X> AndChainMatcher.Builder<X> thatIs(Matcher<? super T> m) {
        return this.that((Matcher<? super T>)Is.is(m));
    }

    public <X> Matcher<X> that(Matcher ... m) {
        if (this.prependIs) {
            return InstanceThat.isInstanceThat(this.clazz, m);
        }
        return InstanceThat.instanceThat(this.clazz, m);
    }

    @Factory
    public static <T> InstanceOf<T> isInstanceOf(Class<T> clazz) {
        return new InstanceOf<T>(true, clazz);
    }

    @Factory
    public static <T> InstanceOf<T> instanceOf(Class<T> clazz) {
        return new InstanceOf<T>(clazz);
    }

    @Factory
    public static <T> InstanceOf<T> isA(Class<T> clazz) {
        return new InstanceOf<T>(true, clazz);
    }

    @Factory
    public static <T> InstanceOf<T> _instanceOf(Class<T> clazz) {
        return new InstanceOf<T>(clazz);
    }

    @Factory
    public static <T> InstanceOf<T> _isA(Class<T> clazz) {
        return new InstanceOf<T>(true, clazz);
    }

    @Factory
    public static <T> InstanceOf<T> a(Class<T> clazz) {
        return new InstanceOf<T>(clazz);
    }
}

