/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.proc;

import org.cthul.proc.CurryProc;
import org.cthul.proc.P0;
import org.cthul.proc.P1;
import org.cthul.proc.P2;
import org.cthul.proc.P3;
import org.cthul.proc.P4;
import org.cthul.proc.Proc;
import org.cthul.proc.ProcError;
import org.hamcrest.Description;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;

public abstract class ProcBase<This extends ProcBase<This>>
implements Proc {
    protected static final Object[] NO_ARGS = new Object[0];
    protected final ProcBase source;
    private Object[] args = NO_ARGS;
    private String name = "";
    private boolean isRun = false;
    private Object result;
    private Throwable exception;

    protected ProcBase() {
        this.source = null;
    }

    protected ProcBase(Object ... args) {
        this();
        this.args(args);
    }

    protected ProcBase(ProcBase source) {
        this.name(source.name);
        this.source = source;
    }

    protected ProcBase(ProcBase source, Object ... args) {
        this(source);
        this.args(args);
    }

    protected final void args(Object ... args) {
        if (args == null) {
            args = NO_ARGS;
        }
        this.args = args;
        this.retry();
    }

    @Override
    public Object[] getArgs() {
        return this.args;
    }

    protected final void name(String name) {
        if (name == null) {
            name = "";
        }
        this.name = name;
    }

    protected void assertArgCount(Object[] args, int count) {
        if (args.length != count) {
            throw this.illegalArgumentException(String.format("Wrong number of arguments, expected %d got %d", count, args.length));
        }
    }

    protected ProcError notImplemented(String method) {
        return this.unsupportedOperationException(method + " is not implemented");
    }

    protected abstract Object run(Object[] var1) throws Throwable;

    protected This copy() {
        return this.createCopy(this.args);
    }

    protected This copy(Object ... args) {
        return this.createCopy(args);
    }

    protected abstract This createCopy(Object[] var1);

    public This retry() {
        this.isRun = false;
        return (This)this;
    }

    private synchronized void ensureIsRun() {
        if (!this.isRun) {
            this.isRun = true;
            try {
                this.result = this.executeProc(this.args);
                this.exception = null;
            }
            catch (ProcError e) {
                throw e.asRuntimeException();
            }
            catch (Throwable t) {
                this.exception = t;
                this.result = null;
            }
        }
    }

    protected Object executeProc(Object ... args) throws Throwable {
        if (this.source != null) {
            return this.source.executeProc(args);
        }
        return this.run(args);
    }

    public This callAgain() {
        return this.copy();
    }

    public This call(Object ... args) {
        return this.copy(args);
    }

    public This with(Object ... args) {
        return (This)this.call(args);
    }

    @Override
    public boolean hasResult() {
        this.ensureIsRun();
        return this.exception == null;
    }

    @Override
    public Object getResult() {
        this.ensureIsRun();
        return this.result;
    }

    @Override
    public Throwable getException() {
        this.ensureIsRun();
        return this.exception;
    }

    @Override
    public P0 asProc0() {
        return new P0(this, this.args);
    }

    public <A> P1<A> asProc1() {
        return new P1<Object[]>(this, this.args);
    }

    public <A, B> P2<A, B> asProc2() {
        return new P2<ProcBase, Object[]>(this, this.args);
    }

    public <A, B, C> P3<A, B, C> asProc3() {
        return new P3(this, this.args);
    }

    public <A, B, C, D> P4<A, B, C, D> asProc4() {
        return new P4(this, this.args);
    }

    @Override
    public Proc curry(Object ... args) {
        return new CurryProc(this, args);
    }

    @Override
    public Proc curryAt(int i, Object ... args) {
        return new CurryProc(this, i, args);
    }

    public void describeTo(Description description) {
        this.describeKeyTo(description);
        if (this.isRun) {
            if (this.hasResult()) {
                description.appendText(" = ").appendValue(this.getResult());
            } else {
                description.appendText("-> ").appendValue((Object)this.getException());
            }
        }
    }

    protected void describeKeyTo(Description description) {
        description.appendText("{");
        this.describeNameTo(description);
        description.appendText("}(");
        this.describeArgsTo(description);
        description.appendText(")");
    }

    protected void describeNameTo(Description description) {
        if (this.name != null) {
            description.appendText(this.name);
        } else if (this.source != null) {
            this.source.describeNameTo(description);
        }
    }

    protected int describeArgsTo(Description description) {
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                description.appendText(", ");
            }
            description.appendValue(this.args[i]);
        }
        return this.args.length;
    }

    public String toString() {
        return StringDescription.toString((SelfDescribing)this);
    }

    protected ProcError exception(Class<? extends RuntimeException> reClazz, String message, Throwable cause) {
        return new ProcError(reClazz, message, cause);
    }

    protected ProcError runtimeException(String message) {
        return this.exception(RuntimeException.class, message, null);
    }

    protected ProcError runtimeException(String message, Throwable cause) {
        return this.exception(RuntimeException.class, message, cause);
    }

    protected ProcError illegalArgumentException(String message) {
        return this.exception(IllegalArgumentException.class, message, null);
    }

    protected ProcError unsupportedOperationException(String message) {
        return this.exception(UnsupportedOperationException.class, message, null);
    }
}

