/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.fluent.lib.collection;

import java.lang.reflect.Array;
import org.cthul.matchers.diagnose.QuickDiagnosingMatcherBase;
import org.cthul.matchers.fluent.adapters.SimpleAdapter;
import org.cthul.matchers.fluent.value.MatchValue;
import org.cthul.matchers.fluent.value.MatchValueAdapter;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public class ArraySizeAdapter
extends SimpleAdapter<Object, Integer> {
    private static final ArraySizeAdapter INSTANCE = new ArraySizeAdapter();

    @Factory
    public static ArraySizeAdapter arraySize() {
        return INSTANCE;
    }

    @Factory
    public static MatchValue<Integer> arraySize(Object array) {
        return ArraySizeAdapter.arraySize().adapt(array);
    }

    @Factory
    public static MatchValue<Integer> arraySizeOf(MatchValue<?> value) {
        return ArraySizeAdapter.arraySize().adapt(value);
    }

    @Factory
    public static <V> MatchValueAdapter<V, Integer> arraySizeOf(MatchValueAdapter<V, ?> adapter) {
        return ArraySizeAdapter.arraySize().adapt(adapter);
    }

    public ArraySizeAdapter() {
        super("size", Object.class);
    }

    protected Matcher<? super Object> precondition() {
        return new QuickDiagnosingMatcherBase<Object>(){

            public boolean matches(Object item, Description mismatch) {
                if (item == null) {
                    mismatch.appendText("was <null>");
                    return false;
                }
                if (!item.getClass().isArray()) {
                    mismatch.appendValue(item).appendText(" was not an array");
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("an array");
            }
        };
    }

    protected Integer adaptValue(Object v) {
        return Array.getLength(v);
    }
}

