/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.matchers.fluent.lib.object;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.cthul.matchers.diagnose.QuickDiagnosingMatcherBase;
import org.cthul.matchers.fluent.adapters.SimpleAdapter;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public class PropertyAdapter<Property>
extends SimpleAdapter<Object, Property> {
    private final String name;
    private Class valueType = null;
    private Object property = null;
    private ConcurrentMap<Class, Object> properties = null;

    @Factory
    public static <P> PropertyAdapter<P> property(String name) {
        return new PropertyAdapter(name);
    }

    @Factory
    public static <P> PropertyAdapter<P> property(String name, Class<P> clazz) {
        return new PropertyAdapter(name);
    }

    @Factory
    public static <P> PropertyAdapter<P> get(String name) {
        return PropertyAdapter.property(name);
    }

    @Factory
    public static <P> PropertyAdapter<P> get(String name, Class<P> clazz) {
        return PropertyAdapter.property(name);
    }

    @Factory
    public static PropertyAdapter<Boolean> booleanProperty(String name) {
        return PropertyAdapter.property(name);
    }

    @Factory
    public static PropertyAdapter<Integer> intProperty(String name) {
        return PropertyAdapter.property(name);
    }

    public PropertyAdapter(String name) {
        super(name, Object.class);
        this.name = name;
    }

    private Object getProperty(Class clazz) {
        Object p;
        if (this.valueType == clazz && this.property != null) {
            return this.property;
        }
        if (this.properties != null && (p = this.properties.get(clazz)) != null) {
            return p;
        }
        p = this.findProperty(clazz);
        this.storeProperty(clazz, p);
        return p;
    }

    private Object findProperty(Class clazz) {
        try {
            return clazz.getField(this.name);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            try {
                return clazz.getMethod(this.name, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    String s = "get" + this.name.substring(0, 1).toUpperCase() + (this.name.length() == 1 ? "" : this.name.substring(1));
                    return clazz.getMethod(s, new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    return Void.class;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeProperty(Class clazz, Object p) {
        if (this.valueType == null) {
            PropertyAdapter propertyAdapter = this;
            synchronized (propertyAdapter) {
                if (this.valueType == null) {
                    this.property = p;
                    this.valueType = clazz;
                    return;
                }
            }
        }
        if (this.properties == null) {
            ConcurrentHashMap<Class, Object> map = new ConcurrentHashMap<Class, Object>();
            PropertyAdapter propertyAdapter = this;
            synchronized (propertyAdapter) {
                if (this.properties == null) {
                    this.properties = map;
                }
            }
        }
        this.properties.put(clazz, p);
    }

    protected Matcher<? super Object> precondition() {
        return new QuickDiagnosingMatcherBase<Object>(){

            public boolean matches(Object item, Description mismatch) {
                if (item == null) {
                    mismatch.appendText("was null");
                    return false;
                }
                if (PropertyAdapter.this.getProperty(item.getClass()) != null) {
                    return true;
                }
                mismatch.appendValue(item).appendText(" had no property '").appendText(PropertyAdapter.this.name).appendText("'");
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("a value with property '").appendText(PropertyAdapter.this.name).appendText("'");
            }
        };
    }

    protected Property adaptValue(Object v) {
        Object p;
        block4: {
            Object prop = this.getProperty(v.getClass());
            try {
                if (prop instanceof Field) {
                    p = ((Field)prop).get(v);
                    break block4;
                }
                if (prop instanceof Method) {
                    p = ((Method)prop).invoke(v, new Object[0]);
                    break block4;
                }
                throw new RuntimeException("Internal error: " + v + " has no property '" + this.name + "'");
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return (Property)p;
    }
}

