package org.cthul.matchers.fluent8;

public interface BigDecimalFluent<Value extends java.math.BigDecimal,BaseFluent,TheFluent extends BaseFluent,This extends BigDecimalFluent<Value,BaseFluent,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep<Value, BaseFluent, TheFluent, This>, ComparableFluent<java.math.BigDecimal,Value, BaseFluent, TheFluent, This> {

    /**
     * Creates a matcher of {@link java.math.BigDecimal}s that matches when an examined BigDecimal is equal
     * to the specified <code>operand</code>, within a range of +/- <code>error</code>. The comparison for equality
     * is done by BigDecimals {@link java.math.BigDecimal#compareTo(java.math.BigDecimal)} method.
     * <p>
     * For example:
     * <pre>assertThat(new BigDecimal("1.03"), is(closeTo(new BigDecimal("1.0"), new BigDecimal("0.03"))))</pre>
     *
     * @param operand
    the expected value of matching BigDecimals
     * @param error
    the delta (+/-) within which matches will be allowed
     * @see org.hamcrest.number.BigDecimalCloseTo#closeTo(java.math.BigDecimal,java.math.BigDecimal)
     * @return fluent
     */
    default TheFluent closeTo(java.math.BigDecimal operand, java.math.BigDecimal error) {
        return __(org.hamcrest.number.BigDecimalCloseTo.closeTo(operand, error));
    }

    @Override
    org.cthul.matchers.fluent8.BigDecimalFluent.OrChain<Value, TheFluent, ?> either();

    @Override
    org.cthul.matchers.fluent8.BigDecimalFluent.OrChain<Value, TheFluent, ?> either(org.hamcrest.Matcher<? super Value> matcher);

    @Override
    org.cthul.matchers.fluent8.BigDecimalFluent.AndChain<Value, TheFluent, ?> both();

    @Override
    org.cthul.matchers.fluent8.BigDecimalFluent.AndChain<Value, TheFluent, ?> both(org.hamcrest.Matcher<? super Value> matcher);

    @Override
    org.cthul.matchers.fluent8.BigDecimalFluent.AndChain<Value, TheFluent, ?> all();

    interface OrChain<Value extends java.math.BigDecimal,TheFluent,This extends OrChain<Value,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep.OrChain<Value, TheFluent, This>, org.cthul.matchers.fluent8.BigDecimalFluent<Value, org.cthul.matchers.fluent.Fluent<Value>, This, This>, ComparableFluent.OrChain<java.math.BigDecimal,Value, TheFluent, This> {

        @Override
        org.cthul.matchers.fluent8.BigDecimalFluent<Value, TheFluent, TheFluent, ?> or();

        @Override
        TheFluent or(org.hamcrest.Matcher<? super Value> matcher);

    }

    interface AndChain<Value extends java.math.BigDecimal,TheFluent,This extends AndChain<Value,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep.AndChain<Value, TheFluent, This>, org.cthul.matchers.fluent8.BigDecimalFluent<Value, org.cthul.matchers.fluent.Fluent<Value>, This, This>, ComparableFluent.AndChain<java.math.BigDecimal,Value, TheFluent, This> {

        @Override
        org.cthul.matchers.fluent8.BigDecimalFluent<Value, TheFluent, TheFluent, ?> and();

        @Override
        TheFluent and(org.hamcrest.Matcher<? super Value> matcher);

    }

    class Step<Value extends java.math.BigDecimal,TheFluent,This extends Step<Value,TheFluent,This>> extends org.cthul.matchers.fluent.builder.FluentStepBuilder<Value, TheFluent, This> implements org.cthul.matchers.fluent8.BigDecimalFluent<Value, TheFluent, TheFluent, This> {

        private static final org.cthul.matchers.fluent.ext.ExtensionFactory X_ADAPTER = org.cthul.matchers.fluent.ext.Extensions.typecastFactory(java.math.BigDecimal.class, Step::new, Assert::new);

        public Step(org.cthul.matchers.fluent.builder.Matchable<? extends Value, TheFluent> matchable) {
            super(matchable);
        }

        @Override
        public org.cthul.matchers.fluent8.BigDecimalFluent.OrChain<Value, TheFluent, ?> either() {
            return _either(org.cthul.matchers.fluent8.BigDecimalFluent.OrChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.BigDecimalFluent.OrChain<Value, TheFluent, ?> either(org.hamcrest.Matcher<? super Value> matcher) {
            return either().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.BigDecimalFluent.AndChain<Value, TheFluent, ?> both() {
            return _both(org.cthul.matchers.fluent8.BigDecimalFluent.AndChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.BigDecimalFluent.AndChain<Value, TheFluent, ?> both(org.hamcrest.Matcher<? super Value> matcher) {
            return both().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.BigDecimalFluent.AndChain<Value, TheFluent, ?> all() {
            return _all(org.cthul.matchers.fluent8.BigDecimalFluent.AndChain.class, Step.adapter());
        }

        public static <Value extends java.math.BigDecimal,TheFluent> org.cthul.matchers.fluent.ext.ExtensionFactory<java.lang.Object, org.cthul.matchers.fluent8.BigDecimalFluent.Assert<Value>, TheFluent, org.cthul.matchers.fluent8.BigDecimalFluent.Step<Value, TheFluent, ?>> adapter() {
            return X_ADAPTER;
        }

    }

    class Assert<Value extends java.math.BigDecimal> extends org.cthul.matchers.fluent.builder.FluentAssertBuilder<Value, Assert<Value>> implements org.cthul.matchers.fluent8.BigDecimalFluent<Value, org.cthul.matchers.fluent.Fluent<Value>, Assert<Value>, Assert<Value>> {

        public Assert(org.cthul.matchers.fluent.builder.FailureHandler handler,  org.cthul.matchers.fluent.value.MatchValue<Value> value) {
            super(handler, value);
        }

        protected Assert(org.cthul.matchers.fluent.builder.Matchable<? extends Value, ?> value) {
            super(value);
        }

        @Override
        public org.cthul.matchers.fluent8.BigDecimalFluent.OrChain<Value, Assert<Value>, ?> either() {
            return _either(org.cthul.matchers.fluent8.BigDecimalFluent.OrChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.BigDecimalFluent.OrChain<Value, Assert<Value>, ?> either(org.hamcrest.Matcher<? super Value> matcher) {
            return either().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.BigDecimalFluent.AndChain<Value, Assert<Value>, ?> both() {
            return _both(org.cthul.matchers.fluent8.BigDecimalFluent.AndChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.BigDecimalFluent.AndChain<Value, Assert<Value>, ?> both(org.hamcrest.Matcher<? super Value> matcher) {
            return both().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.BigDecimalFluent.AndChain<Value, Assert<Value>, ?> all() {
            return _all(org.cthul.matchers.fluent8.BigDecimalFluent.AndChain.class, Step.adapter());
        }

    }

}
