package org.cthul.matchers.fluent8;

public interface CollectionFluent<T,Value extends java.util.Collection<T>,BaseFluent,TheFluent extends BaseFluent,This extends CollectionFluent<T,Value,BaseFluent,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep<Value, BaseFluent, TheFluent, This>, IterableFluent<T,Value, BaseFluent, TheFluent, This> {

    /**
     * Creates a matcher for {@link Iterable}s that only matches when a single pass over the
     * examined {@link Iterable} yields at least one item that is matched by the specified
     * <code>itemMatcher</code>.  Whilst matching, the traversal of the examined {@link Iterable}
     * will stop as soon as a matching item is found.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar"), hasItem(startsWith("ba")))</pre>
     *
     * @param itemMatcher
    the matcher to apply to items provided by the examined {@link Iterable}
     * @see org.hamcrest.core.IsCollectionContaining#hasItem(org.hamcrest.Matcher)
     * @return fluent
     */
    default TheFluent hasItem(org.hamcrest.Matcher<? super T> itemMatcher) {
        return __(org.hamcrest.core.IsCollectionContaining.hasItem(itemMatcher));
    }

    /**
     * Creates a matcher for {@link Iterable}s that only matches when a single pass over the
     * examined {@link Iterable} yields at least one item that is equal to the specified
     * <code>item</code>.  Whilst matching, the traversal of the examined {@link Iterable}
     * will stop as soon as a matching item is found.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar"), hasItem("bar"))</pre>
     *
     * @param item
    the item to compare against the items provided by the examined {@link Iterable}
     * @see org.hamcrest.core.IsCollectionContaining#hasItem(java.lang.Object)
     * @return fluent
     */
    default TheFluent hasItem(T item) {
        return __(org.hamcrest.core.IsCollectionContaining.hasItem(item));
    }

    /**
     * Creates a matcher for {@link Iterable}s that matches when consecutive passes over the
     * examined {@link Iterable} yield at least one item that is matched by the corresponding
     * matcher from the specified <code>itemMatchers</code>.  Whilst matching, each traversal of
     * the examined {@link Iterable} will stop as soon as a matching item is found.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar", "baz"), hasItems(endsWith("z"), endsWith("o")))</pre>
     *
     * @param itemMatchers
    the matchers to apply to items provided by the examined {@link Iterable}
     * @see org.hamcrest.core.IsCollectionContaining#hasItems(org.hamcrest.Matcher...)
     * @return fluent
     */
    default TheFluent hasItems(org.hamcrest.Matcher<? super T>... itemMatchers) {
        return __(org.hamcrest.core.IsCollectionContaining.hasItems(itemMatchers));
    }

    /**
     * Creates a matcher for {@link Iterable}s that matches when consecutive passes over the
     * examined {@link Iterable} yield at least one item that is equal to the corresponding
     * item from the specified <code>items</code>.  Whilst matching, each traversal of the
     * examined {@link Iterable} will stop as soon as a matching item is found.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar", "baz"), hasItems("baz", "foo"))</pre>
     *
     * @param items
    the items to compare against the items provided by the examined {@link Iterable}
     * @see org.hamcrest.core.IsCollectionContaining#hasItems(java.lang.Object...)
     * @return fluent
     */
    default TheFluent hasItems(T... items) {
        return __(org.hamcrest.core.IsCollectionContaining.hasItems(items));
    }

    /**
     * Creates a matcher for {@link java.util.Collection}s that matches when the <code>size()</code> method returns
     * a value equal to the specified <code>size</code>.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar"), hasSize(2))</pre>
     *
     * @param size
    the expected size of an examined {@link java.util.Collection}
     * @see org.hamcrest.collection.IsCollectionWithSize#hasSize(int)
     * @return fluent
     */
    default TheFluent hasSize(int size) {
        return __(org.hamcrest.collection.IsCollectionWithSize.hasSize(size));
    }

    /**
     * Creates a matcher for {@link java.util.Collection}s matching examined collections whose <code>isEmpty</code>
     * method returns <code>true</code>.
     * <p>
     * For example:
     * <pre>assertThat(new ArrayList&lt;String&gt;(), is(empty()))</pre>
     *
     * @see org.hamcrest.collection.IsEmptyCollection#empty()
     * @return fluent
     */
    default TheFluent empty() {
        return __(org.hamcrest.collection.IsEmptyCollection.empty());
    }

    @Override
    org.cthul.matchers.fluent8.CollectionFluent.OrChain<T, Value, TheFluent, ?> either();

    @Override
    org.cthul.matchers.fluent8.CollectionFluent.OrChain<T, Value, TheFluent, ?> either(org.hamcrest.Matcher<? super Value> matcher);

    @Override
    org.cthul.matchers.fluent8.CollectionFluent.AndChain<T, Value, TheFluent, ?> both();

    @Override
    org.cthul.matchers.fluent8.CollectionFluent.AndChain<T, Value, TheFluent, ?> both(org.hamcrest.Matcher<? super Value> matcher);

    @Override
    org.cthul.matchers.fluent8.CollectionFluent.AndChain<T, Value, TheFluent, ?> all();

    interface OrChain<T,Value extends java.util.Collection<T>,TheFluent,This extends OrChain<T,Value,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep.OrChain<Value, TheFluent, This>, org.cthul.matchers.fluent8.CollectionFluent<T, Value, org.cthul.matchers.fluent.Fluent<Value>, This, This>, IterableFluent.OrChain<T,Value, TheFluent, This> {

        @Override
        org.cthul.matchers.fluent8.CollectionFluent<T, Value, TheFluent, TheFluent, ?> or();

        @Override
        TheFluent or(org.hamcrest.Matcher<? super Value> matcher);

    }

    interface AndChain<T,Value extends java.util.Collection<T>,TheFluent,This extends AndChain<T,Value,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep.AndChain<Value, TheFluent, This>, org.cthul.matchers.fluent8.CollectionFluent<T, Value, org.cthul.matchers.fluent.Fluent<Value>, This, This>, IterableFluent.AndChain<T,Value, TheFluent, This> {

        @Override
        org.cthul.matchers.fluent8.CollectionFluent<T, Value, TheFluent, TheFluent, ?> and();

        @Override
        TheFluent and(org.hamcrest.Matcher<? super Value> matcher);

    }

    class Step<T,Value extends java.util.Collection<T>,TheFluent,This extends Step<T,Value,TheFluent,This>> extends org.cthul.matchers.fluent.builder.FluentStepBuilder<Value, TheFluent, This> implements org.cthul.matchers.fluent8.CollectionFluent<T, Value, TheFluent, TheFluent, This> {

        private static final org.cthul.matchers.fluent.ext.ExtensionFactory X_ADAPTER = org.cthul.matchers.fluent.ext.Extensions.typecastFactory(java.util.Collection.class, Step::new, Assert::new);

        public Step(org.cthul.matchers.fluent.builder.Matchable<? extends Value, TheFluent> matchable) {
            super(matchable);
        }

        @Override
        public org.cthul.matchers.fluent8.CollectionFluent.OrChain<T, Value, TheFluent, ?> either() {
            return _either(org.cthul.matchers.fluent8.CollectionFluent.OrChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.CollectionFluent.OrChain<T, Value, TheFluent, ?> either(org.hamcrest.Matcher<? super Value> matcher) {
            return either().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.CollectionFluent.AndChain<T, Value, TheFluent, ?> both() {
            return _both(org.cthul.matchers.fluent8.CollectionFluent.AndChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.CollectionFluent.AndChain<T, Value, TheFluent, ?> both(org.hamcrest.Matcher<? super Value> matcher) {
            return both().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.CollectionFluent.AndChain<T, Value, TheFluent, ?> all() {
            return _all(org.cthul.matchers.fluent8.CollectionFluent.AndChain.class, Step.adapter());
        }

        public static <T,Value extends java.util.Collection<T>,TheFluent> org.cthul.matchers.fluent.ext.ExtensionFactory<java.lang.Object, org.cthul.matchers.fluent8.CollectionFluent.Assert<T, Value>, TheFluent, org.cthul.matchers.fluent8.CollectionFluent.Step<T, Value, TheFluent, ?>> adapter() {
            return X_ADAPTER;
        }

    }

    class Assert<T,Value extends java.util.Collection<T>> extends org.cthul.matchers.fluent.builder.FluentAssertBuilder<Value, Assert<T,Value>> implements org.cthul.matchers.fluent8.CollectionFluent<T, Value, org.cthul.matchers.fluent.Fluent<Value>, Assert<T,Value>, Assert<T,Value>> {

        public Assert(org.cthul.matchers.fluent.builder.FailureHandler handler,  org.cthul.matchers.fluent.value.MatchValue<Value> value) {
            super(handler, value);
        }

        protected Assert(org.cthul.matchers.fluent.builder.Matchable<? extends Value, ?> value) {
            super(value);
        }

        @Override
        public org.cthul.matchers.fluent8.CollectionFluent.OrChain<T, Value, Assert<T,Value>, ?> either() {
            return _either(org.cthul.matchers.fluent8.CollectionFluent.OrChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.CollectionFluent.OrChain<T, Value, Assert<T,Value>, ?> either(org.hamcrest.Matcher<? super Value> matcher) {
            return either().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.CollectionFluent.AndChain<T, Value, Assert<T,Value>, ?> both() {
            return _both(org.cthul.matchers.fluent8.CollectionFluent.AndChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.CollectionFluent.AndChain<T, Value, Assert<T,Value>, ?> both(org.hamcrest.Matcher<? super Value> matcher) {
            return both().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.CollectionFluent.AndChain<T, Value, Assert<T,Value>, ?> all() {
            return _all(org.cthul.matchers.fluent8.CollectionFluent.AndChain.class, Step.adapter());
        }

    }

}
