package org.cthul.matchers.fluent8;

public interface ComparableFluent<C extends java.lang.Comparable<C>,Value extends C,BaseFluent,TheFluent extends BaseFluent,This extends ComparableFluent<C,Value,BaseFluent,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep<Value, BaseFluent, TheFluent, This>, ObjectFluent<Value, BaseFluent, TheFluent, This> {

    /**
     * Creates a matcher of {@link Comparable} object that matches when the examined object is
     * equal to the specified value, as reported by the <code>compareTo</code> method of the
     * <b>examined</b> object.
     * <p>
     * For example:
     * <pre>assertThat(1, comparesEqualTo(1))</pre>
     *
     * @param value
    the value which, when passed to the compareTo method of the examined object, should return zero
     * @see org.hamcrest.number.OrderingComparison#comparesEqualTo(java.lang.Comparable)
     * @return fluent
     */
    default TheFluent comparesEqualTo(Value value) {
        return __(org.hamcrest.number.OrderingComparison.comparesEqualTo(value));
    }

    /**
     * Creates a matcher of {@link Comparable} object that matches when the examined object is
     * greater than the specified value, as reported by the <code>compareTo</code> method of the
     * <b>examined</b> object.
     * <p>
     * For example:
     * <pre>assertThat(2, greaterThan(1))</pre>
     *
     * @param value
    the value which, when passed to the compareTo method of the examined object, should return greater
    than zero
     * @see org.hamcrest.number.OrderingComparison#greaterThan(java.lang.Comparable)
     * @return fluent
     */
    default TheFluent greaterThan(Value value) {
        return __(org.hamcrest.number.OrderingComparison.greaterThan(value));
    }

    /**
     * Creates a matcher of {@link Comparable} object that matches when the examined object is
     * greater than or equal to the specified value, as reported by the <code>compareTo</code> method
     * of the <b>examined</b> object.
     * <p>
     * For example:
     * <pre>assertThat(1, greaterThanOrEqualTo(1))</pre>
     *
     * @param value
    the value which, when passed to the compareTo method of the examined object, should return greater
    than or equal to zero
     * @see org.hamcrest.number.OrderingComparison#greaterThanOrEqualTo(java.lang.Comparable)
     * @return fluent
     */
    default TheFluent greaterThanOrEqualTo(Value value) {
        return __(org.hamcrest.number.OrderingComparison.greaterThanOrEqualTo(value));
    }

    /**
     * Creates a matcher of {@link Comparable} object that matches when the examined object is
     * less than the specified value, as reported by the <code>compareTo</code> method of the
     * <b>examined</b> object.
     * <p>
     * For example:
     * <pre>assertThat(1, lessThan(2))</pre>
     *
     * @param value
    the value which, when passed to the compareTo method of the examined object, should return less
    than zero
     * @see org.hamcrest.number.OrderingComparison#lessThan(java.lang.Comparable)
     * @return fluent
     */
    default TheFluent lessThan(Value value) {
        return __(org.hamcrest.number.OrderingComparison.lessThan(value));
    }

    /**
     * Creates a matcher of {@link Comparable} object that matches when the examined object is
     * less than or equal to the specified value, as reported by the <code>compareTo</code> method
     * of the <b>examined</b> object.
     * <p>
     * For example:
     * <pre>assertThat(1, lessThanOrEqualTo(1))</pre>
     *
     * @param value
    the value which, when passed to the compareTo method of the examined object, should return less
    than or equal to zero
     * @see org.hamcrest.number.OrderingComparison#lessThanOrEqualTo(java.lang.Comparable)
     * @return fluent
     */
    default TheFluent lessThanOrEqualTo(Value value) {
        return __(org.hamcrest.number.OrderingComparison.lessThanOrEqualTo(value));
    }

    @Override
    org.cthul.matchers.fluent8.ComparableFluent.OrChain<C, Value, TheFluent, ?> either();

    @Override
    org.cthul.matchers.fluent8.ComparableFluent.OrChain<C, Value, TheFluent, ?> either(org.hamcrest.Matcher<? super Value> matcher);

    @Override
    org.cthul.matchers.fluent8.ComparableFluent.AndChain<C, Value, TheFluent, ?> both();

    @Override
    org.cthul.matchers.fluent8.ComparableFluent.AndChain<C, Value, TheFluent, ?> both(org.hamcrest.Matcher<? super Value> matcher);

    @Override
    org.cthul.matchers.fluent8.ComparableFluent.AndChain<C, Value, TheFluent, ?> all();

    interface OrChain<C extends java.lang.Comparable<C>,Value extends C,TheFluent,This extends OrChain<C,Value,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep.OrChain<Value, TheFluent, This>, org.cthul.matchers.fluent8.ComparableFluent<C, Value, org.cthul.matchers.fluent.Fluent<Value>, This, This>, ObjectFluent.OrChain<Value, TheFluent, This> {

        @Override
        org.cthul.matchers.fluent8.ComparableFluent<C, Value, TheFluent, TheFluent, ?> or();

        @Override
        TheFluent or(org.hamcrest.Matcher<? super Value> matcher);

    }

    interface AndChain<C extends java.lang.Comparable<C>,Value extends C,TheFluent,This extends AndChain<C,Value,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep.AndChain<Value, TheFluent, This>, org.cthul.matchers.fluent8.ComparableFluent<C, Value, org.cthul.matchers.fluent.Fluent<Value>, This, This>, ObjectFluent.AndChain<Value, TheFluent, This> {

        @Override
        org.cthul.matchers.fluent8.ComparableFluent<C, Value, TheFluent, TheFluent, ?> and();

        @Override
        TheFluent and(org.hamcrest.Matcher<? super Value> matcher);

    }

    class Step<C extends java.lang.Comparable<C>,Value extends C,TheFluent,This extends Step<C,Value,TheFluent,This>> extends org.cthul.matchers.fluent.builder.FluentStepBuilder<Value, TheFluent, This> implements org.cthul.matchers.fluent8.ComparableFluent<C, Value, TheFluent, TheFluent, This> {

        private static final org.cthul.matchers.fluent.ext.ExtensionFactory X_ADAPTER = org.cthul.matchers.fluent.ext.Extensions.typecastFactory(java.lang.Comparable.class, Step::new, Assert::new);

        public Step(org.cthul.matchers.fluent.builder.Matchable<? extends Value, TheFluent> matchable) {
            super(matchable);
        }

        @Override
        public org.cthul.matchers.fluent8.ComparableFluent.OrChain<C, Value, TheFluent, ?> either() {
            return _either(org.cthul.matchers.fluent8.ComparableFluent.OrChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.ComparableFluent.OrChain<C, Value, TheFluent, ?> either(org.hamcrest.Matcher<? super Value> matcher) {
            return either().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.ComparableFluent.AndChain<C, Value, TheFluent, ?> both() {
            return _both(org.cthul.matchers.fluent8.ComparableFluent.AndChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.ComparableFluent.AndChain<C, Value, TheFluent, ?> both(org.hamcrest.Matcher<? super Value> matcher) {
            return both().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.ComparableFluent.AndChain<C, Value, TheFluent, ?> all() {
            return _all(org.cthul.matchers.fluent8.ComparableFluent.AndChain.class, Step.adapter());
        }

        public static <C extends java.lang.Comparable<C>,Value extends C,TheFluent> org.cthul.matchers.fluent.ext.ExtensionFactory<java.lang.Object, org.cthul.matchers.fluent8.ComparableFluent.Assert<C, Value>, TheFluent, org.cthul.matchers.fluent8.ComparableFluent.Step<C, Value, TheFluent, ?>> adapter() {
            return X_ADAPTER;
        }

    }

    class Assert<C extends java.lang.Comparable<C>,Value extends C> extends org.cthul.matchers.fluent.builder.FluentAssertBuilder<Value, Assert<C,Value>> implements org.cthul.matchers.fluent8.ComparableFluent<C, Value, org.cthul.matchers.fluent.Fluent<Value>, Assert<C,Value>, Assert<C,Value>> {

        public Assert(org.cthul.matchers.fluent.builder.FailureHandler handler,  org.cthul.matchers.fluent.value.MatchValue<Value> value) {
            super(handler, value);
        }

        protected Assert(org.cthul.matchers.fluent.builder.Matchable<? extends Value, ?> value) {
            super(value);
        }

        @Override
        public org.cthul.matchers.fluent8.ComparableFluent.OrChain<C, Value, Assert<C,Value>, ?> either() {
            return _either(org.cthul.matchers.fluent8.ComparableFluent.OrChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.ComparableFluent.OrChain<C, Value, Assert<C,Value>, ?> either(org.hamcrest.Matcher<? super Value> matcher) {
            return either().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.ComparableFluent.AndChain<C, Value, Assert<C,Value>, ?> both() {
            return _both(org.cthul.matchers.fluent8.ComparableFluent.AndChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.ComparableFluent.AndChain<C, Value, Assert<C,Value>, ?> both(org.hamcrest.Matcher<? super Value> matcher) {
            return both().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.ComparableFluent.AndChain<C, Value, Assert<C,Value>, ?> all() {
            return _all(org.cthul.matchers.fluent8.ComparableFluent.AndChain.class, Step.adapter());
        }

    }

}
