package org.cthul.matchers.fluent8;

public interface DoubleFluent<Value extends java.lang.Double,BaseFluent,TheFluent extends BaseFluent,This extends DoubleFluent<Value,BaseFluent,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep<Value, BaseFluent, TheFluent, This>, ComparableFluent<java.lang.Double,Value, BaseFluent, TheFluent, This> {

    /**
     * Creates a matcher of {@link Double}s that matches when an examined double is equal
     * to the specified <code>operand</code>, within a range of +/- <code>error</code>.
     * <p>
     * For example:
     * <pre>assertThat(1.03, is(closeTo(1.0, 0.03)))</pre>
     *
     * @param operand
    the expected value of matching doubles
     * @param error
    the delta (+/-) within which matches will be allowed
     * @see org.hamcrest.number.IsCloseTo#closeTo(double,double)
     * @return fluent
     */
    default TheFluent closeTo(double operand, double error) {
        return __(org.hamcrest.number.IsCloseTo.closeTo(operand, error));
    }

    @Override
    org.cthul.matchers.fluent8.DoubleFluent.OrChain<Value, TheFluent, ?> either();

    @Override
    org.cthul.matchers.fluent8.DoubleFluent.OrChain<Value, TheFluent, ?> either(org.hamcrest.Matcher<? super Value> matcher);

    @Override
    org.cthul.matchers.fluent8.DoubleFluent.AndChain<Value, TheFluent, ?> both();

    @Override
    org.cthul.matchers.fluent8.DoubleFluent.AndChain<Value, TheFluent, ?> both(org.hamcrest.Matcher<? super Value> matcher);

    @Override
    org.cthul.matchers.fluent8.DoubleFluent.AndChain<Value, TheFluent, ?> all();

    interface OrChain<Value extends java.lang.Double,TheFluent,This extends OrChain<Value,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep.OrChain<Value, TheFluent, This>, org.cthul.matchers.fluent8.DoubleFluent<Value, org.cthul.matchers.fluent.Fluent<Value>, This, This>, ComparableFluent.OrChain<java.lang.Double,Value, TheFluent, This> {

        @Override
        org.cthul.matchers.fluent8.DoubleFluent<Value, TheFluent, TheFluent, ?> or();

        @Override
        TheFluent or(org.hamcrest.Matcher<? super Value> matcher);

    }

    interface AndChain<Value extends java.lang.Double,TheFluent,This extends AndChain<Value,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep.AndChain<Value, TheFluent, This>, org.cthul.matchers.fluent8.DoubleFluent<Value, org.cthul.matchers.fluent.Fluent<Value>, This, This>, ComparableFluent.AndChain<java.lang.Double,Value, TheFluent, This> {

        @Override
        org.cthul.matchers.fluent8.DoubleFluent<Value, TheFluent, TheFluent, ?> and();

        @Override
        TheFluent and(org.hamcrest.Matcher<? super Value> matcher);

    }

    class Step<Value extends java.lang.Double,TheFluent,This extends Step<Value,TheFluent,This>> extends org.cthul.matchers.fluent.builder.FluentStepBuilder<Value, TheFluent, This> implements org.cthul.matchers.fluent8.DoubleFluent<Value, TheFluent, TheFluent, This> {

        private static final org.cthul.matchers.fluent.ext.ExtensionFactory X_ADAPTER = org.cthul.matchers.fluent.ext.Extensions.typecastFactory(java.lang.Double.class, Step::new, Assert::new);

        public Step(org.cthul.matchers.fluent.builder.Matchable<? extends Value, TheFluent> matchable) {
            super(matchable);
        }

        @Override
        public org.cthul.matchers.fluent8.DoubleFluent.OrChain<Value, TheFluent, ?> either() {
            return _either(org.cthul.matchers.fluent8.DoubleFluent.OrChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.DoubleFluent.OrChain<Value, TheFluent, ?> either(org.hamcrest.Matcher<? super Value> matcher) {
            return either().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.DoubleFluent.AndChain<Value, TheFluent, ?> both() {
            return _both(org.cthul.matchers.fluent8.DoubleFluent.AndChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.DoubleFluent.AndChain<Value, TheFluent, ?> both(org.hamcrest.Matcher<? super Value> matcher) {
            return both().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.DoubleFluent.AndChain<Value, TheFluent, ?> all() {
            return _all(org.cthul.matchers.fluent8.DoubleFluent.AndChain.class, Step.adapter());
        }

        public static <Value extends java.lang.Double,TheFluent> org.cthul.matchers.fluent.ext.ExtensionFactory<java.lang.Object, org.cthul.matchers.fluent8.DoubleFluent.Assert<Value>, TheFluent, org.cthul.matchers.fluent8.DoubleFluent.Step<Value, TheFluent, ?>> adapter() {
            return X_ADAPTER;
        }

    }

    class Assert<Value extends java.lang.Double> extends org.cthul.matchers.fluent.builder.FluentAssertBuilder<Value, Assert<Value>> implements org.cthul.matchers.fluent8.DoubleFluent<Value, org.cthul.matchers.fluent.Fluent<Value>, Assert<Value>, Assert<Value>> {

        public Assert(org.cthul.matchers.fluent.builder.FailureHandler handler,  org.cthul.matchers.fluent.value.MatchValue<Value> value) {
            super(handler, value);
        }

        protected Assert(org.cthul.matchers.fluent.builder.Matchable<? extends Value, ?> value) {
            super(value);
        }

        @Override
        public org.cthul.matchers.fluent8.DoubleFluent.OrChain<Value, Assert<Value>, ?> either() {
            return _either(org.cthul.matchers.fluent8.DoubleFluent.OrChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.DoubleFluent.OrChain<Value, Assert<Value>, ?> either(org.hamcrest.Matcher<? super Value> matcher) {
            return either().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.DoubleFluent.AndChain<Value, Assert<Value>, ?> both() {
            return _both(org.cthul.matchers.fluent8.DoubleFluent.AndChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.DoubleFluent.AndChain<Value, Assert<Value>, ?> both(org.hamcrest.Matcher<? super Value> matcher) {
            return both().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.DoubleFluent.AndChain<Value, Assert<Value>, ?> all() {
            return _all(org.cthul.matchers.fluent8.DoubleFluent.AndChain.class, Step.adapter());
        }

    }

}
