package org.cthul.matchers.fluent8;

public interface IterableFluent<T,Value extends java.lang.Iterable<T>,BaseFluent,TheFluent extends BaseFluent,This extends IterableFluent<T,Value,BaseFluent,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep<Value, BaseFluent, TheFluent, This>, ObjectFluent<Value, BaseFluent, TheFluent, This> {

    /**
     * Creates a matcher for {@link Iterable}s matching examined iterables that yield no items.
     * <p>
     * For example:
     * <pre>assertThat(new ArrayList&lt;String&gt;(), is(emptyIterable()))</pre>
     *
     * @see org.hamcrest.collection.IsEmptyIterable#emptyIterable()
     * @return fluent
     */
    default TheFluent empty() {
        return __(org.hamcrest.collection.IsEmptyIterable.emptyIterable());
    }

    /**
     * Creates a matcher for {@link Iterable}s that matches when a single pass over the
     * examined {@link Iterable} yields a series of items, each logically equal to the
     * corresponding item in the specified items.  For a positive match, the examined iterable
     * must be of the same length as the number of specified items.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar"), contains("foo", "bar"))</pre>
     *
     * @param items
    the items that must equal the items provided by an examined {@link Iterable}
     * @see org.hamcrest.collection.IsIterableContainingInOrder#contains(java.lang.Object...)
     * @return fluent
     */
    default TheFluent contains(T... items) {
        return __(org.hamcrest.collection.IsIterableContainingInOrder.contains(items));
    }

    /**
     * Creates a matcher for {@link Iterable}s that matches when a single pass over the
     * examined {@link Iterable} yields a single item that satisfies the specified matcher.
     * For a positive match, the examined iterable must only yield one item.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo"), contains(equalTo("foo")))</pre>
     *
     * @param itemMatcher
    the matcher that must be satisfied by the single item provided by an
    examined {@link Iterable}
     * @see org.hamcrest.collection.IsIterableContainingInOrder#contains(org.hamcrest.Matcher)
     * @return fluent
     */
    default TheFluent contains(org.hamcrest.Matcher<? super T> itemMatcher) {
        return __(org.hamcrest.collection.IsIterableContainingInOrder.contains(itemMatcher));
    }

    /**
     * Creates a matcher for {@link Iterable}s that matches when a single pass over the
     * examined {@link Iterable} yields a series of items, each satisfying the corresponding
     * matcher in the specified matchers.  For a positive match, the examined iterable
     * must be of the same length as the number of specified matchers.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar"), contains(equalTo("foo"), equalTo("bar")))</pre>
     *
     * @param itemMatchers
    the matchers that must be satisfied by the items provided by an examined {@link Iterable}
     * @see org.hamcrest.collection.IsIterableContainingInOrder#contains(org.hamcrest.Matcher...)
     * @return fluent
     */
    default TheFluent contains(org.hamcrest.Matcher<? super T>... itemMatchers) {
        return __(org.hamcrest.collection.IsIterableContainingInOrder.contains(itemMatchers));
    }

    /**
     * Creates a matcher for {@link Iterable}s that matches when a single pass over the
     * examined {@link Iterable} yields a series of items, each satisfying the corresponding
     * matcher in the specified list of matchers.  For a positive match, the examined iterable
     * must be of the same length as the specified list of matchers.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar"), contains(Arrays.asList(equalTo("foo"), equalTo("bar"))))</pre>
     *
     * @param itemMatchers
    a list of matchers, each of which must be satisfied by the corresponding item provided by
    an examined {@link Iterable}
     * @see org.hamcrest.collection.IsIterableContainingInOrder#contains(java.util.List)
     * @return fluent
     */
    default TheFluent contains(java.util.List<org.hamcrest.Matcher<? super T>> itemMatchers) {
        return __(org.hamcrest.collection.IsIterableContainingInOrder.contains(itemMatchers));
    }

    /**
     * Creates an order agnostic matcher for {@link Iterable}s that matches when a single pass over
     * the examined {@link Iterable} yields a series of items, each satisfying one matcher anywhere
     * in the specified matchers.  For a positive match, the examined iterable must be of the same
     * length as the number of specified matchers.
     * <p>
     * N.B. each of the specified matchers will only be used once during a given examination, so be
     * careful when specifying matchers that may be satisfied by more than one entry in an examined
     * iterable.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar"), containsInAnyOrder(equalTo("bar"), equalTo("foo")))</pre>
     *
     * @param itemMatchers
    a list of matchers, each of which must be satisfied by an item provided by an examined {@link Iterable}
     * @see org.hamcrest.collection.IsIterableContainingInAnyOrder#containsInAnyOrder(org.hamcrest.Matcher...)
     * @return fluent
     */
    default TheFluent containsInAnyOrder(org.hamcrest.Matcher<? super T>... itemMatchers) {
        return __(org.hamcrest.collection.IsIterableContainingInAnyOrder.containsInAnyOrder(itemMatchers));
    }

    /**
     * Creates an order agnostic matcher for {@link Iterable}s that matches when a single pass over
     * the examined {@link Iterable} yields a series of items, each logically equal to one item
     * anywhere in the specified items. For a positive match, the examined iterable
     * must be of the same length as the number of specified items.
     * <p>
     * N.B. each of the specified items will only be used once during a given examination, so be
     * careful when specifying items that may be equal to more than one entry in an examined
     * iterable.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar"), containsInAnyOrder("bar", "foo"))</pre>
     *
     * @param items
    the items that must equal the items provided by an examined {@link Iterable} in any order
     * @see org.hamcrest.collection.IsIterableContainingInAnyOrder#containsInAnyOrder(java.lang.Object...)
     * @return fluent
     */
    default TheFluent containsInAnyOrder(T... items) {
        return __(org.hamcrest.collection.IsIterableContainingInAnyOrder.containsInAnyOrder(items));
    }

    /**
     * Creates an order agnostic matcher for {@link Iterable}s that matches when a single pass over
     * the examined {@link Iterable} yields a series of items, each satisfying one matcher anywhere
     * in the specified collection of matchers.  For a positive match, the examined iterable
     * must be of the same length as the specified collection of matchers.
     * <p>
     * N.B. each matcher in the specified collection will only be used once during a given
     * examination, so be careful when specifying matchers that may be satisfied by more than
     * one entry in an examined iterable.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar"), containsInAnyOrder(Arrays.asList(equalTo("bar"), equalTo("foo"))))</pre>
     *
     * @param itemMatchers
    a list of matchers, each of which must be satisfied by an item provided by an examined {@link Iterable}
     * @see org.hamcrest.collection.IsIterableContainingInAnyOrder#containsInAnyOrder(java.util.Collection)
     * @return fluent
     */
    default TheFluent containsInAnyOrder(java.util.Collection<org.hamcrest.Matcher<? super T>> itemMatchers) {
        return __(org.hamcrest.collection.IsIterableContainingInAnyOrder.containsInAnyOrder(itemMatchers));
    }

    /**
     * Creates a matcher for {@link Iterable}s that matches when a single pass over the
     * examined {@link Iterable} yields an item count that is equal to the specified
     * <code>size</code> argument.
     * <p>
     * For example:
     * <pre>assertThat(Arrays.asList("foo", "bar"), iterableWithSize(2))</pre>
     *
     * @param size
    the number of items that should be yielded by an examined {@link Iterable}
     * @see org.hamcrest.collection.IsIterableWithSize#iterableWithSize(int)
     * @return fluent
     */
    default TheFluent hasSize(int size) {
        return __(org.hamcrest.collection.IsIterableWithSize.iterableWithSize(size));
    }

    /**
     * @see org.cthul.matchers.fluent.lib.collection.IterableSizeAdapter#size()
     * @return integer fluent step step
     */
    default IntegerFluent.Step<java.lang.Integer,TheFluent,?> size() {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.lib.collection.IterableSizeAdapter.size(), IntegerFluent.Step.Step.adapter()));
    }

    /**
     * @see org.cthul.matchers.fluent.adapters.AnyOfAdapter#any()
     * @return object fluent step step
     */
    default <I> ObjectFluent.Step<I,TheFluent,?> any() {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.adapters.AnyOfAdapter.any(), ObjectFluent.Step.Step.adapter()));
    }

    /**
     * @see org.cthul.matchers.fluent.adapters.AnyOfAdapter#anyString()
     * @return string fluent step step
     */
    default StringFluent.Step<java.lang.String,TheFluent,?> anyString() {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.adapters.AnyOfAdapter.anyString(), StringFluent.Step.Step.adapter()));
    }

    /**
     * @see org.cthul.matchers.fluent.adapters.AnyOfAdapter#anyBoolean()
     * @return object fluent step step
     */
    default ObjectFluent.Step<java.lang.Boolean,TheFluent,?> anyBoolean() {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.adapters.AnyOfAdapter.anyBoolean(), ObjectFluent.Step.Step.adapter()));
    }

    /**
     * @see org.cthul.matchers.fluent.adapters.AnyOfAdapter#anyDouble()
     * @return double fluent step step
     */
    default DoubleFluent.Step<java.lang.Double,TheFluent,?> anyDouble() {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.adapters.AnyOfAdapter.anyDouble(), DoubleFluent.Step.Step.adapter()));
    }

    /**
     * @see org.cthul.matchers.fluent.adapters.AnyOfAdapter#anyInt()
     * @return integer fluent step step
     */
    default IntegerFluent.Step<java.lang.Integer,TheFluent,?> anyInt() {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.adapters.AnyOfAdapter.anyInt(), IntegerFluent.Step.Step.adapter()));
    }

    /**
     * @see org.cthul.matchers.fluent.adapters.AnyOfAdapter#anyLong()
     * @return comparable fluent step step
     */
    default ComparableFluent.Step<java.lang.Long,java.lang.Long,TheFluent,?> anyLong() {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.adapters.AnyOfAdapter.anyLong(), ComparableFluent.Step.Step.adapter()));
    }

    /**
     * @see org.cthul.matchers.fluent.adapters.EachOfAdapter#each()
     * @return object fluent step step
     */
    default <I> ObjectFluent.Step<I,TheFluent,?> each() {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.adapters.EachOfAdapter.each(), ObjectFluent.Step.Step.adapter()));
    }

    /**
     * @see org.cthul.matchers.fluent.adapters.EachOfAdapter#eachString()
     * @return string fluent step step
     */
    default StringFluent.Step<java.lang.String,TheFluent,?> eachString() {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.adapters.EachOfAdapter.eachString(), StringFluent.Step.Step.adapter()));
    }

    /**
     * @see org.cthul.matchers.fluent.adapters.EachOfAdapter#eachBoolean()
     * @return object fluent step step
     */
    default ObjectFluent.Step<java.lang.Boolean,TheFluent,?> eachBoolean() {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.adapters.EachOfAdapter.eachBoolean(), ObjectFluent.Step.Step.adapter()));
    }

    /**
     * @see org.cthul.matchers.fluent.adapters.EachOfAdapter#eachDouble()
     * @return double fluent step step
     */
    default DoubleFluent.Step<java.lang.Double,TheFluent,?> eachDouble() {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.adapters.EachOfAdapter.eachDouble(), DoubleFluent.Step.Step.adapter()));
    }

    /**
     * @see org.cthul.matchers.fluent.adapters.EachOfAdapter#eachInt()
     * @return integer fluent step step
     */
    default IntegerFluent.Step<java.lang.Integer,TheFluent,?> eachInt() {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.adapters.EachOfAdapter.eachInt(), IntegerFluent.Step.Step.adapter()));
    }

    /**
     * @see org.cthul.matchers.fluent.adapters.EachOfAdapter#eachLong()
     * @return comparable fluent step step
     */
    default ComparableFluent.Step<java.lang.Long,java.lang.Long,TheFluent,?> eachLong() {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.adapters.EachOfAdapter.eachLong(), ComparableFluent.Step.Step.adapter()));
    }

    @Override
    org.cthul.matchers.fluent8.IterableFluent.OrChain<T, Value, TheFluent, ?> either();

    @Override
    org.cthul.matchers.fluent8.IterableFluent.OrChain<T, Value, TheFluent, ?> either(org.hamcrest.Matcher<? super Value> matcher);

    @Override
    org.cthul.matchers.fluent8.IterableFluent.AndChain<T, Value, TheFluent, ?> both();

    @Override
    org.cthul.matchers.fluent8.IterableFluent.AndChain<T, Value, TheFluent, ?> both(org.hamcrest.Matcher<? super Value> matcher);

    @Override
    org.cthul.matchers.fluent8.IterableFluent.AndChain<T, Value, TheFluent, ?> all();

    interface OrChain<T,Value extends java.lang.Iterable<T>,TheFluent,This extends OrChain<T,Value,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep.OrChain<Value, TheFluent, This>, org.cthul.matchers.fluent8.IterableFluent<T, Value, org.cthul.matchers.fluent.Fluent<Value>, This, This>, ObjectFluent.OrChain<Value, TheFluent, This> {

        @Override
        org.cthul.matchers.fluent8.IterableFluent<T, Value, TheFluent, TheFluent, ?> or();

        @Override
        TheFluent or(org.hamcrest.Matcher<? super Value> matcher);

    }

    interface AndChain<T,Value extends java.lang.Iterable<T>,TheFluent,This extends AndChain<T,Value,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep.AndChain<Value, TheFluent, This>, org.cthul.matchers.fluent8.IterableFluent<T, Value, org.cthul.matchers.fluent.Fluent<Value>, This, This>, ObjectFluent.AndChain<Value, TheFluent, This> {

        @Override
        org.cthul.matchers.fluent8.IterableFluent<T, Value, TheFluent, TheFluent, ?> and();

        @Override
        TheFluent and(org.hamcrest.Matcher<? super Value> matcher);

    }

    class Step<T,Value extends java.lang.Iterable<T>,TheFluent,This extends Step<T,Value,TheFluent,This>> extends org.cthul.matchers.fluent.builder.FluentStepBuilder<Value, TheFluent, This> implements org.cthul.matchers.fluent8.IterableFluent<T, Value, TheFluent, TheFluent, This> {

        private static final org.cthul.matchers.fluent.ext.ExtensionFactory X_ADAPTER = org.cthul.matchers.fluent.ext.Extensions.typecastFactory(java.lang.Iterable.class, Step::new, Assert::new);

        public Step(org.cthul.matchers.fluent.builder.Matchable<? extends Value, TheFluent> matchable) {
            super(matchable);
        }

        @Override
        public org.cthul.matchers.fluent8.IterableFluent.OrChain<T, Value, TheFluent, ?> either() {
            return _either(org.cthul.matchers.fluent8.IterableFluent.OrChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.IterableFluent.OrChain<T, Value, TheFluent, ?> either(org.hamcrest.Matcher<? super Value> matcher) {
            return either().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.IterableFluent.AndChain<T, Value, TheFluent, ?> both() {
            return _both(org.cthul.matchers.fluent8.IterableFluent.AndChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.IterableFluent.AndChain<T, Value, TheFluent, ?> both(org.hamcrest.Matcher<? super Value> matcher) {
            return both().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.IterableFluent.AndChain<T, Value, TheFluent, ?> all() {
            return _all(org.cthul.matchers.fluent8.IterableFluent.AndChain.class, Step.adapter());
        }

        public static <T,Value extends java.lang.Iterable<T>,TheFluent> org.cthul.matchers.fluent.ext.ExtensionFactory<java.lang.Object, org.cthul.matchers.fluent8.IterableFluent.Assert<T, Value>, TheFluent, org.cthul.matchers.fluent8.IterableFluent.Step<T, Value, TheFluent, ?>> adapter() {
            return X_ADAPTER;
        }

    }

    class Assert<T,Value extends java.lang.Iterable<T>> extends org.cthul.matchers.fluent.builder.FluentAssertBuilder<Value, Assert<T,Value>> implements org.cthul.matchers.fluent8.IterableFluent<T, Value, org.cthul.matchers.fluent.Fluent<Value>, Assert<T,Value>, Assert<T,Value>> {

        public Assert(org.cthul.matchers.fluent.builder.FailureHandler handler,  org.cthul.matchers.fluent.value.MatchValue<Value> value) {
            super(handler, value);
        }

        protected Assert(org.cthul.matchers.fluent.builder.Matchable<? extends Value, ?> value) {
            super(value);
        }

        @Override
        public org.cthul.matchers.fluent8.IterableFluent.OrChain<T, Value, Assert<T,Value>, ?> either() {
            return _either(org.cthul.matchers.fluent8.IterableFluent.OrChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.IterableFluent.OrChain<T, Value, Assert<T,Value>, ?> either(org.hamcrest.Matcher<? super Value> matcher) {
            return either().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.IterableFluent.AndChain<T, Value, Assert<T,Value>, ?> both() {
            return _both(org.cthul.matchers.fluent8.IterableFluent.AndChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.IterableFluent.AndChain<T, Value, Assert<T,Value>, ?> both(org.hamcrest.Matcher<? super Value> matcher) {
            return both().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.IterableFluent.AndChain<T, Value, Assert<T,Value>, ?> all() {
            return _all(org.cthul.matchers.fluent8.IterableFluent.AndChain.class, Step.adapter());
        }

    }

}
