package org.cthul.matchers.fluent8;

public interface MapFluent<K,V,Value extends java.util.Map<K, V>,BaseFluent,TheFluent extends BaseFluent,This extends MapFluent<K,V,Value,BaseFluent,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep<Value, BaseFluent, TheFluent, This>, ObjectFluent<Value, BaseFluent, TheFluent, This> {

    /**
     * Creates a matcher for {@link java.util.Map}s matching when the examined {@link java.util.Map} contains
     * at least one entry whose key equals the specified <code>key</code> <b>and</b> whose value equals the
     * specified <code>value</code>.
     * <p>
     * For example:
     * <pre>assertThat(myMap, hasEntry("bar", "foo"))</pre>
     *
     * @param key
    the key that, in combination with the value, must be describe at least one entry
     * @param value
    the value that, in combination with the key, must be describe at least one entry
     * @see org.hamcrest.collection.IsMapContaining#hasEntry(java.lang.Object,java.lang.Object)
     * @return fluent
     */
    default TheFluent hasEntry(K key, V value) {
        return __(org.hamcrest.collection.IsMapContaining.hasEntry(key, value));
    }

    /**
     * Creates a matcher for {@link java.util.Map}s matching when the examined {@link java.util.Map} contains
     * at least one key that is equal to the specified key.
     * <p>
     * For example:
     * <pre>assertThat(myMap, hasKey("bar"))</pre>
     *
     * @param key
    the key that satisfying maps must contain
     * @see org.hamcrest.collection.IsMapContaining#hasKey(java.lang.Object)
     * @return fluent
     */
    default TheFluent hasKey(K key) {
        return __(org.hamcrest.collection.IsMapContaining.hasKey(key));
    }

    /**
     * Creates a matcher for {@link java.util.Map}s matching when the examined {@link java.util.Map} contains
     * at least one value that is equal to the specified value.
     * <p>
     * For example:
     * <pre>assertThat(myMap, hasValue("foo"))</pre>
     *
     * @param value
    the value that satisfying maps must contain
     * @see org.hamcrest.collection.IsMapContaining#hasValue(java.lang.Object)
     * @return fluent
     */
    default TheFluent hasValue(V value) {
        return __(org.hamcrest.collection.IsMapContaining.hasValue(value));
    }

    /**
     * @see org.cthul.matchers.fluent.lib.collection.MapAdapters#mapKeys()
     * @return collection fluent step step
     */
    default CollectionFluent.Step<K,java.util.Set<K>,TheFluent,?> keys() {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.lib.collection.MapAdapters.mapKeys(), CollectionFluent.Step.Step.adapter()));
    }

    /**
     * @see org.cthul.matchers.fluent.lib.collection.MapAdapters#mapValues()
     * @return collection fluent step step
     */
    default CollectionFluent.Step<V,java.util.Collection<V>,TheFluent,?> values() {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.lib.collection.MapAdapters.mapValues(), CollectionFluent.Step.Step.adapter()));
    }

    /**
     * @see org.cthul.matchers.fluent.lib.collection.MapAdapters#value(java.lang.Object)
     * @return object fluent step step
     */
    default ObjectFluent.Step<V,TheFluent,?> value(java.lang.Object key) {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.lib.collection.MapAdapters.value(key), ObjectFluent.Step.Step.adapter()));
    }

    /**
     * @see org.cthul.matchers.fluent.lib.collection.MapAdapters#byteValue(java.lang.Object)
     * @return object fluent step step
     */
    default ObjectFluent.Step<java.lang.Byte,TheFluent,?> byteValue(java.lang.Object key) {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.lib.collection.MapAdapters.byteValue(key), ObjectFluent.Step.Step.adapter()));
    }

    /**
     * @see org.cthul.matchers.fluent.lib.collection.MapAdapters#booleanValue(java.lang.Object)
     * @return object fluent step step
     */
    default ObjectFluent.Step<java.lang.Boolean,TheFluent,?> booleanValue(java.lang.Object key) {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.lib.collection.MapAdapters.booleanValue(key), ObjectFluent.Step.Step.adapter()));
    }

    /**
     * @see org.cthul.matchers.fluent.lib.collection.MapAdapters#floatValue(java.lang.Object)
     * @return comparable fluent step step
     */
    default ComparableFluent.Step<java.lang.Float,java.lang.Float,TheFluent,?> floatValue(java.lang.Object key) {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.lib.collection.MapAdapters.floatValue(key), ComparableFluent.Step.Step.adapter()));
    }

    /**
     * @see org.cthul.matchers.fluent.lib.collection.MapAdapters#doubleValue(java.lang.Object)
     * @return double fluent step step
     */
    default DoubleFluent.Step<java.lang.Double,TheFluent,?> doubleValue(java.lang.Object key) {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.lib.collection.MapAdapters.doubleValue(key), DoubleFluent.Step.Step.adapter()));
    }

    /**
     * @see org.cthul.matchers.fluent.lib.collection.MapAdapters#intValue(java.lang.Object)
     * @return integer fluent step step
     */
    default IntegerFluent.Step<java.lang.Integer,TheFluent,?> intValue(java.lang.Object key) {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.lib.collection.MapAdapters.intValue(key), IntegerFluent.Step.Step.adapter()));
    }

    /**
     * @see org.cthul.matchers.fluent.lib.collection.MapAdapters#longValue(java.lang.Object)
     * @return comparable fluent step step
     */
    default ComparableFluent.Step<java.lang.Long,java.lang.Long,TheFluent,?> longValue(java.lang.Object key) {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.lib.collection.MapAdapters.longValue(key), ComparableFluent.Step.Step.adapter()));
    }

    /**
     * @see org.cthul.matchers.fluent.lib.collection.MapAdapters#shortValue(java.lang.Object)
     * @return object fluent step step
     */
    default ObjectFluent.Step<java.lang.Short,TheFluent,?> shortValue(java.lang.Object key) {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.lib.collection.MapAdapters.shortValue(key), ObjectFluent.Step.Step.adapter()));
    }

    /**
     * @see org.cthul.matchers.fluent.lib.collection.MapAdapters#stringValue(java.lang.Object)
     * @return string fluent step step
     */
    default StringFluent.Step<java.lang.String,TheFluent,?> stringValue(java.lang.Object key) {
        return as(org.cthul.matchers.fluent.ext.Extensions.uncheckedFactory(org.cthul.matchers.fluent.lib.collection.MapAdapters.stringValue(key), StringFluent.Step.Step.adapter()));
    }

    @Override
    org.cthul.matchers.fluent8.MapFluent.OrChain<K, V, Value, TheFluent, ?> either();

    @Override
    org.cthul.matchers.fluent8.MapFluent.OrChain<K, V, Value, TheFluent, ?> either(org.hamcrest.Matcher<? super Value> matcher);

    @Override
    org.cthul.matchers.fluent8.MapFluent.AndChain<K, V, Value, TheFluent, ?> both();

    @Override
    org.cthul.matchers.fluent8.MapFluent.AndChain<K, V, Value, TheFluent, ?> both(org.hamcrest.Matcher<? super Value> matcher);

    @Override
    org.cthul.matchers.fluent8.MapFluent.AndChain<K, V, Value, TheFluent, ?> all();

    interface OrChain<K,V,Value extends java.util.Map<K, V>,TheFluent,This extends OrChain<K,V,Value,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep.OrChain<Value, TheFluent, This>, org.cthul.matchers.fluent8.MapFluent<K, V, Value, org.cthul.matchers.fluent.Fluent<Value>, This, This>, ObjectFluent.OrChain<Value, TheFluent, This> {

        @Override
        org.cthul.matchers.fluent8.MapFluent<K, V, Value, TheFluent, TheFluent, ?> or();

        @Override
        TheFluent or(org.hamcrest.Matcher<? super Value> matcher);

    }

    interface AndChain<K,V,Value extends java.util.Map<K, V>,TheFluent,This extends AndChain<K,V,Value,TheFluent,This>> extends org.cthul.matchers.fluent.ext.ExtensibleFluentStep.AndChain<Value, TheFluent, This>, org.cthul.matchers.fluent8.MapFluent<K, V, Value, org.cthul.matchers.fluent.Fluent<Value>, This, This>, ObjectFluent.AndChain<Value, TheFluent, This> {

        @Override
        org.cthul.matchers.fluent8.MapFluent<K, V, Value, TheFluent, TheFluent, ?> and();

        @Override
        TheFluent and(org.hamcrest.Matcher<? super Value> matcher);

    }

    class Step<K,V,Value extends java.util.Map<K, V>,TheFluent,This extends Step<K,V,Value,TheFluent,This>> extends org.cthul.matchers.fluent.builder.FluentStepBuilder<Value, TheFluent, This> implements org.cthul.matchers.fluent8.MapFluent<K, V, Value, TheFluent, TheFluent, This> {

        private static final org.cthul.matchers.fluent.ext.ExtensionFactory X_ADAPTER = org.cthul.matchers.fluent.ext.Extensions.typecastFactory(java.util.Map.class, Step::new, Assert::new);

        public Step(org.cthul.matchers.fluent.builder.Matchable<? extends Value, TheFluent> matchable) {
            super(matchable);
        }

        @Override
        public org.cthul.matchers.fluent8.MapFluent.OrChain<K, V, Value, TheFluent, ?> either() {
            return _either(org.cthul.matchers.fluent8.MapFluent.OrChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.MapFluent.OrChain<K, V, Value, TheFluent, ?> either(org.hamcrest.Matcher<? super Value> matcher) {
            return either().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.MapFluent.AndChain<K, V, Value, TheFluent, ?> both() {
            return _both(org.cthul.matchers.fluent8.MapFluent.AndChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.MapFluent.AndChain<K, V, Value, TheFluent, ?> both(org.hamcrest.Matcher<? super Value> matcher) {
            return both().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.MapFluent.AndChain<K, V, Value, TheFluent, ?> all() {
            return _all(org.cthul.matchers.fluent8.MapFluent.AndChain.class, Step.adapter());
        }

        public static <K,V,Value extends java.util.Map<K, V>,TheFluent> org.cthul.matchers.fluent.ext.ExtensionFactory<java.lang.Object, org.cthul.matchers.fluent8.MapFluent.Assert<K, V, Value>, TheFluent, org.cthul.matchers.fluent8.MapFluent.Step<K, V, Value, TheFluent, ?>> adapter() {
            return X_ADAPTER;
        }

    }

    class Assert<K,V,Value extends java.util.Map<K, V>> extends org.cthul.matchers.fluent.builder.FluentAssertBuilder<Value, Assert<K,V,Value>> implements org.cthul.matchers.fluent8.MapFluent<K, V, Value, org.cthul.matchers.fluent.Fluent<Value>, Assert<K,V,Value>, Assert<K,V,Value>> {

        public Assert(org.cthul.matchers.fluent.builder.FailureHandler handler,  org.cthul.matchers.fluent.value.MatchValue<Value> value) {
            super(handler, value);
        }

        protected Assert(org.cthul.matchers.fluent.builder.Matchable<? extends Value, ?> value) {
            super(value);
        }

        @Override
        public org.cthul.matchers.fluent8.MapFluent.OrChain<K, V, Value, Assert<K,V,Value>, ?> either() {
            return _either(org.cthul.matchers.fluent8.MapFluent.OrChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.MapFluent.OrChain<K, V, Value, Assert<K,V,Value>, ?> either(org.hamcrest.Matcher<? super Value> matcher) {
            return either().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.MapFluent.AndChain<K, V, Value, Assert<K,V,Value>, ?> both() {
            return _both(org.cthul.matchers.fluent8.MapFluent.AndChain.class, Step.adapter());
        }

        @Override
        public org.cthul.matchers.fluent8.MapFluent.AndChain<K, V, Value, Assert<K,V,Value>, ?> both(org.hamcrest.Matcher<? super Value> matcher) {
            return both().__(matcher);
        }

        @Override
        public org.cthul.matchers.fluent8.MapFluent.AndChain<K, V, Value, Assert<K,V,Value>, ?> all() {
            return _all(org.cthul.matchers.fluent8.MapFluent.AndChain.class, Step.adapter());
        }

    }

}
